/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.generic;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.addons.tinkersconstruct.AddonTinkersTiles;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AddonGenericTiles
implements IWailaDataProvider {
    private static final String CONFIG_CORRECT_TOOL = "wawla.harvest.showTool";
    private static final String CONFIG_SHOW_HARVESTABILITY = "wawla.harvest.showHarvest";
    private static final String CONFIG_CORRECT_TIER = "wawla.harvest.showTier";
    private static final String CONFIG_BREAK_PROGRESSION = "wawla.harvest.showProgress";
    private static final String CONFIG_DAYLIGHT = "wawla.light.showDay";
    private static final String CONFIG_MONSTERLIGHT = "wawla.light.monsterSpawn";
    private static final String CONFIG_LIGHTLEVEL = "wawla.light.lightLevel";
    private static final String CONFIG_SLEEPY = "wawla.bed.sleepable";
    private static final String CONFIG_HARDNESS = "wawla.info.showHardness";
    private static final String CONFIG_RESISTANCE = "wawla.info.showResistance";

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        double progress;
        int itemLevel;
        MovingObjectPosition pos = data.getPosition();
        Block block = data.getBlock();
        ItemStack item = data.getPlayer().func_70694_bm();
        String tool = block != null ? block.getHarvestTool(data.getMetadata()) : "";
        int blockLevel = block.getHarvestLevel(data.getMetadata());
        int n = itemLevel = item != null ? item.func_77973_b().getHarvestLevel(item, tool) : 0;
        if (tool != null && tool.equalsIgnoreCase("chisel")) {
            if (block == Blocks.field_150348_b) {
                tool = "pickaxe";
            }
            if (block == Blocks.field_150344_f) {
                tool = "axe";
            }
        }
        if (item != null && (item.func_77973_b().getToolClasses(item).contains(tool) || AddonTinkersTiles.canHarvest(item, tool))) {
            if (cfg.getConfig(CONFIG_SHOW_HARVESTABILITY) && (blockLevel <= itemLevel || blockLevel == 0)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"tooltip.wawla.yes"));
            } else {
                if (cfg.getConfig(CONFIG_SHOW_HARVESTABILITY)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.wawla.no"));
                }
                if (cfg.getConfig(CONFIG_CORRECT_TIER)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.blockLevel") + ": " + blockLevel);
                }
                if (tool != null && cfg.getConfig(CONFIG_CORRECT_TOOL)) {
                    String translation = StatCollector.func_74838_a((String)("tooltip.wawla.tooltype." + tool));
                    if (translation.startsWith("tooltip.wawla.tooltype.")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + tool);
                    } else {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + translation);
                    }
                }
            }
        }
        if (cfg.getConfig(CONFIG_LIGHTLEVEL) && (!data.getWorld().func_147445_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d, false) || data.getWorld().func_147437_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d))) {
            int dayLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, true);
            int nightLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, false);
            String display = StatCollector.func_74838_a((String)"tooltip.wawla.lightLevel") + ": ";
            if (cfg.getConfig(CONFIG_MONSTERLIGHT)) {
                if (nightLevel <= 7) {
                    display = display + EnumChatFormatting.DARK_RED + "" + nightLevel + " ";
                } else if (nightLevel > 7) {
                    display = display + EnumChatFormatting.GREEN + "" + nightLevel + " ";
                }
            }
            if (cfg.getConfig(CONFIG_DAYLIGHT)) {
                display = display + EnumChatFormatting.YELLOW + "(" + dayLevel + ")";
            }
            tip.add(display);
        }
        if (cfg.getConfig(CONFIG_HARDNESS)) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.hardness") + ": " + data.getBlock().func_149712_f(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d));
        }
        if (cfg.getConfig(CONFIG_RESISTANCE)) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.resistance") + ": " + data.getBlock().func_149638_a((Entity)data.getPlayer()));
        }
        if (cfg.getConfig(CONFIG_BREAK_PROGRESSION) && data.getPlayer().field_70170_p.field_72995_K && (progress = Utilities.round(Utilities.getBlockDamage(), 2)) > 0.0) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.progress") + ": " + (int)(progress * 100.0) + "%");
        }
        if (cfg.getConfig(CONFIG_SLEEPY) && block.isBed((IBlockAccess)data.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (EntityLivingBase)data.getPlayer())) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.sleepable") + ": " + Utilities.canPlayerSleep(data.getPlayer()));
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonGenericTiles dataProvider = new AddonGenericTiles();
        String catagory = "Wawla-General";
        register.addConfig(catagory, CONFIG_CORRECT_TOOL);
        register.addConfig(catagory, CONFIG_SHOW_HARVESTABILITY);
        register.addConfig(catagory, CONFIG_CORRECT_TIER);
        register.addConfig(catagory, CONFIG_BREAK_PROGRESSION);
        register.addConfig(catagory, CONFIG_LIGHTLEVEL);
        register.addConfig(catagory, CONFIG_MONSTERLIGHT);
        register.addConfig(catagory, CONFIG_DAYLIGHT);
        register.addConfig(catagory, CONFIG_SLEEPY);
        register.addConfig(catagory, CONFIG_HARDNESS, false);
        register.addConfig(catagory, CONFIG_RESISTANCE, false);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, Block.class);
    }
}

