/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InvWrapper
implements IItemHandlerModifiable {
    private final IInventory inv;

    public InvWrapper(IInventory inv) {
        this.inv = Objects.requireNonNull(inv);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvWrapper that = (InvWrapper)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().func_70302_i_();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().func_70301_a(slot);
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack == null) {
            return null;
        }
        ItemStack stackInSlot = this.getInv().func_70301_a(slot);
        if (stackInSlot != null) {
            if (stackInSlot.field_77994_a >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().func_94041_b(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.field_77994_a;
            if (stack.field_77994_a <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a += stackInSlot.field_77994_a;
                    this.getInv().func_70299_a(slot, copy);
                    this.getInv().func_70296_d();
                }
                return null;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.field_77994_a += stackInSlot.field_77994_a;
                this.getInv().func_70299_a(slot, copy);
                this.getInv().func_70296_d();
            } else {
                stack.field_77994_a -= m;
            }
            return stack;
        }
        if (!this.getInv().func_94041_b(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.field_77994_a) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.getInv().func_70299_a(slot, stack.func_77979_a(m));
                this.getInv().func_70296_d();
            } else {
                stack.field_77994_a -= m;
            }
            return stack;
        }
        if (!simulate) {
            this.getInv().func_70299_a(slot, stack);
            this.getInv().func_70296_d();
        }
        return null;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        ItemStack stackInSlot = this.getInv().func_70301_a(slot);
        if (stackInSlot == null) {
            return null;
        }
        if (simulate) {
            if (stackInSlot.field_77994_a < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.field_77994_a = amount;
            return copy;
        }
        int m = Math.min(stackInSlot.field_77994_a, amount);
        ItemStack decrStackSize = this.getInv().func_70298_a(slot, m);
        this.getInv().func_70296_d();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.getInv().func_70299_a(slot, stack == null ? null : stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().func_70297_j_();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getInv().func_94041_b(slot, stack);
    }

    @Deprecated
    public IInventory getInv() {
        return this.inv;
    }

    @Override
    public boolean isSlotFromInventory(int index, IInventory inventory, int invIndex) {
        return inventory == this.inv && index == invIndex && invIndex >= 0 && invIndex < this.inv.func_70302_i_();
    }
}

