/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands;

import betterquesting.api.questing.IQuest;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class BQ_CopyProgress
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        if (p_71516_2_.length > 2) {
            return null;
        }
        String s = p_71516_2_.length != 0 ? p_71516_2_[p_71516_2_.length - 1] : "";
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().filter(i -> i instanceof EntityPlayerMP).filter(o -> o.getDisplayName().startsWith(s)).map(EntityPlayer::getDisplayName).collect(Collectors.toList());
    }

    public String func_71517_b() {
        return "bq_copyquests";
    }

    public List func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{this.func_71517_b()});
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bq_copyquests <toPlayer> |OR| /bq_copyquests <fromPlayer> <toPlayer>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        UUID toUUID;
        UUID fromUUID;
        if (args.length == 0 || args.length > 2) {
            throw new CommandException("Wrong arguments", new Object[0]);
        }
        if (args.length == 2) {
            fromUUID = BQ_CopyProgress.GetPlayerUUID(args[0]);
            toUUID = BQ_CopyProgress.GetPlayerUUID(args[1]);
        } else if (sender instanceof EntityPlayer) {
            fromUUID = ((EntityPlayer)sender).getPersistentID();
            toUUID = BQ_CopyProgress.GetPlayerUUID(args[0]);
        } else {
            throw new CommandException("Wrong arguments", new Object[0]);
        }
        long current = System.currentTimeMillis();
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Map.Entry questDBEntry : QuestDatabase.INSTANCE.entrySet()) {
            IQuest quest = (IQuest)questDBEntry.getValue();
            if (!quest.isComplete(fromUUID) || quest.isComplete(toUUID)) continue;
            quest.setComplete(toUUID, current);
            ids.add(questDBEntry.getKey());
        }
        EntityPlayerMP player = BQ_CopyProgress.getPlayerAdvanced(sender, toUUID.toString());
        if (player != null) {
            NetQuestSync.sendSync(player, ids, false, true);
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("Completed " + ids.size() + " for " + toUUID));
    }

    public static EntityPlayerMP getPlayerAdvanced(ICommandSender p_82359_0_, String p_82359_1_) {
        Optional<EntityPlayerMP> onlinePlayer = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().filter(i -> i instanceof EntityPlayerMP).filter(o -> o.getPersistentID().toString().equals(p_82359_1_) || o.getDisplayName().equals(p_82359_1_)).findFirst();
        try {
            return onlinePlayer.isPresent() ? onlinePlayer.get() : BQ_CopyProgress.func_82359_c((ICommandSender)p_82359_0_, (String)p_82359_1_);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static UUID GetPlayerUUID(String data) {
        try {
            return UUID.fromString(data);
        }
        catch (IllegalArgumentException e) {
            Optional<EntityPlayerMP> onlinePlayer = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().filter(i -> i instanceof EntityPlayerMP).filter(o -> o.getPersistentID().toString().equals(data) || o.getDisplayName().equals(data)).findFirst();
            if (onlinePlayer.isPresent()) {
                return onlinePlayer.get().getPersistentID();
            }
            GameProfile gameProfile = new PlayerProfileCache(MinecraftServer.func_71276_C(), MinecraftServer.field_152367_a).func_152655_a(data);
            if (gameProfile != null) {
                return gameProfile.getId();
            }
            return UUID.nameUUIDFromBytes(data.getBytes(StandardCharsets.UTF_8));
        }
    }
}

