/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.decorate;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockNylium;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenWeepingVines;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenHugeFungus
extends WorldGenAbstractTree {
    private final boolean planted;
    public final Block log;
    private final Block hat;
    private final int logMeta;
    private final int hatMeta;

    public WorldGenHugeFungus(boolean notify, int metaLog, int metaLeaf, Block log, Block leaf) {
        this(notify, metaLog, metaLeaf, log, leaf, false);
    }

    public WorldGenHugeFungus(boolean notify, int metaLog, int metaLeaf, Block log, Block leaf, boolean planted) {
        super(notify);
        this.logMeta = metaLog;
        this.hatMeta = metaLeaf;
        this.log = log;
        this.hat = leaf;
        this.planted = planted;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        Block blockstate = world.func_147439_a(x, y - 1, z);
        if (blockstate instanceof BlockNylium) {
            int i = MathHelper.func_76136_a((Random)random, (int)4, (int)13);
            if (random.nextInt(12) == 0) {
                i *= 2;
            }
            boolean flag = !this.planted && random.nextFloat() < 0.06f;
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            if (!this.planted) {
                world.func_147449_b(x, y - 1, z, Blocks.field_150424_aL);
            }
            this.placeStem(world, random, x, y, z, i, flag);
            this.placeHat(world, random, x, y, z, i, flag);
            return true;
        }
        return false;
    }

    protected boolean isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockLeavesBase || block instanceof BlockSapling || block instanceof BlockFlower || block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    private void placeStem(World world, Random rand, int x, int y, int z, int p_285249_, boolean p_285355_) {
        int i = p_285355_ ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean flag = p_285355_ && MathHelper.func_76135_e((float)j) == (float)i && MathHelper.func_76135_e((float)k) == (float)i;
                for (int l = 0; l < p_285249_; ++l) {
                    int offX = x + j;
                    int offY = y + l;
                    int offZ = z + k;
                    if (!this.isReplaceable(world, offX, offY, offZ)) continue;
                    if (this.planted) {
                        if (!world.func_147437_c(offX, offY - 1, offZ)) {
                            world.func_147468_f(offX, offY, offZ);
                        }
                        this.func_150516_a(world, offX, offY, offZ, this.log, this.logMeta);
                        continue;
                    }
                    if (flag) {
                        if (!(rand.nextFloat() < 0.1f)) continue;
                        this.func_150516_a(world, offX, offY, offZ, this.log, this.logMeta);
                        continue;
                    }
                    this.func_150516_a(world, offX, offY, offZ, this.log, this.logMeta);
                }
            }
        }
    }

    private void placeHat(World world, Random rand, int x, int y, int z, int p_285156_, boolean p_285265_) {
        int j;
        boolean flag = this.hat == ModBlocks.NETHER_WART.get() && this.hatMeta == 0;
        int i = Math.min(rand.nextInt(1 + p_285156_ / 3) + 5, p_285156_);
        for (int k = j = p_285156_ - i; k <= p_285156_; ++k) {
            int l;
            int n = l = k < p_285156_ - rand.nextInt(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (p_285265_) {
                ++l;
            }
            for (int i1 = -l; i1 <= l; ++i1) {
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1 = i1 == -l || i1 == l;
                    boolean flag2 = j1 == -l || j1 == l;
                    boolean flag3 = !flag1 && !flag2 && k != p_285156_;
                    boolean flag4 = flag1 && flag2;
                    boolean flag5 = k < j + 3;
                    int offX = x + i1;
                    int offY = y + k;
                    int offZ = z + j1;
                    if (!this.isReplaceable(world, offX, offY, offZ)) continue;
                    if (flag5) {
                        if (flag3) continue;
                        this.placeHatDropBlock(world, rand, offX, offY, offZ, flag);
                        continue;
                    }
                    if (flag3) {
                        this.placeHatBlock(world, rand, offX, offY, offZ, 0.1f, 0.2f, flag ? 0.1f : 0.0f);
                        continue;
                    }
                    if (flag4) {
                        this.placeHatBlock(world, rand, offX, offY, offZ, 0.01f, 0.7f, flag ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock(world, rand, offX, offY, offZ, 5.0E-4f, 0.98f, flag ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(World world, Random rand, int x, int y, int z, float p_225054_, float p_225055_, float p_225056_) {
        if (rand.nextFloat() < p_225054_) {
            world.func_147465_d(x, y, z, ModBlocks.SHROOMLIGHT.get(), 0, 3);
        } else if (rand.nextFloat() < p_225055_) {
            this.func_150516_a(world, x, y, z, this.hat, this.hatMeta);
            if (rand.nextFloat() < p_225056_) {
                WorldGenHugeFungus.tryPlaceWeepingVines(world, rand, x, y, z);
            }
        }
    }

    private void placeHatDropBlock(World world, Random rand, int x, int y, int z, boolean p_225069_) {
        if (world.func_147439_a(x, y - 1, z) == this.hat && world.func_72805_g(x, y - 1, z) == this.hatMeta) {
            this.func_150516_a(world, x, y, z, this.hat, this.hatMeta);
        } else if ((double)rand.nextFloat() < 0.15) {
            this.func_150516_a(world, x, y, z, this.hat, this.hatMeta);
            if (p_225069_ && rand.nextInt(11) == 0) {
                WorldGenHugeFungus.tryPlaceWeepingVines(world, rand, x, y, z);
            }
        }
    }

    private static void tryPlaceWeepingVines(World world, Random rand, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151579_a) {
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)5);
            if (rand.nextInt(7) == 0) {
                i *= 2;
            }
            WorldGenWeepingVines.placeWeepingVinesColumn(world, rand, x, y, z, i);
        }
    }
}

