/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BaseDoor;
import ganymedes01.etfuturum.blocks.IDegradable;
import ganymedes01.etfuturum.blocks.ISubBlocksBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCopperDoor
extends BaseDoor
implements IDegradable {
    private final ThreadLocal<Boolean> playSound = ThreadLocal.withInitial(() -> true);

    public BlockCopperDoor(int meta) {
        super(Material.field_151573_f, "copper_door");
        this.setBlockSound(ModSounds.soundCopper);
        this.func_149675_a(meta < 7);
        String name = ((ISubBlocksBlock)ModBlocks.COPPER_BLOCK.get()).getTypes()[meta].replace("_block", "");
        this.func_149658_d(name.replace("waxed_", "") + "_door");
        this.func_149663_c(Utils.getUnlocalisedName(name + "_door"));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.tickDegradation(world, x, y, z, rand);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.tryWaxOnWaxOff(world, x, y + (meta < 8 ? 1 : 0), z, player)) {
            int i1 = this.func_150012_g((IBlockAccess)world, x, y, z);
            int j1 = i1 & 7;
            j1 ^= 4;
            int multiplier = this.getCopperMeta(meta) % 4 + 1;
            if ((i1 & 8) == 0) {
                world.func_72921_c(x, y, z, j1, 2);
                world.func_147458_c(x, y, z, x, y, z);
                world.func_147454_a(x, y, z, (Block)this, 20 * multiplier, 10);
            } else {
                world.func_72921_c(x, y - 1, z, j1, 2);
                world.func_147458_c(x, y - 1, z, x, y, z);
                world.func_147454_a(x, y - 1, z, (Block)this, 20 * multiplier, 10);
            }
            world.func_72889_a(player, 1003, x, y, z, 0);
        }
        return true;
    }

    @Override
    public int getCopperMeta(int meta) {
        if (this == ModBlocks.COPPER_DOOR.get()) {
            return 0;
        }
        if (this == ModBlocks.EXPOSED_COPPER_DOOR.get()) {
            return 1;
        }
        if (this == ModBlocks.WEATHERED_COPPER_DOOR.get()) {
            return 2;
        }
        if (this == ModBlocks.OXIDIZED_COPPER_DOOR.get()) {
            return 3;
        }
        if (this == ModBlocks.WAXED_COPPER_DOOR.get()) {
            return 8;
        }
        if (this == ModBlocks.WAXED_EXPOSED_COPPER_DOOR.get()) {
            return 9;
        }
        if (this == ModBlocks.WAXED_WEATHERED_COPPER_DOOR.get()) {
            return 10;
        }
        if (this == ModBlocks.WAXED_OXIDIZED_COPPER_DOOR.get()) {
            return 11;
        }
        return 0;
    }

    @Override
    public Block getCopperBlockFromMeta(int i) {
        Block block;
        switch (i) {
            case 1: {
                block = ModBlocks.EXPOSED_COPPER_DOOR.get();
                break;
            }
            case 2: {
                block = ModBlocks.WEATHERED_COPPER_DOOR.get();
                break;
            }
            case 3: {
                block = ModBlocks.OXIDIZED_COPPER_DOOR.get();
                break;
            }
            case 8: {
                block = ModBlocks.WAXED_COPPER_DOOR.get();
                break;
            }
            case 9: {
                block = ModBlocks.WAXED_EXPOSED_COPPER_DOOR.get();
                break;
            }
            case 10: {
                block = ModBlocks.WAXED_WEATHERED_COPPER_DOOR.get();
                break;
            }
            case 11: {
                block = ModBlocks.WAXED_OXIDIZED_COPPER_DOOR.get();
                break;
            }
            default: {
                block = ModBlocks.COPPER_DOOR.get();
            }
        }
        return block;
    }

    @Override
    public int getFinalCopperMeta(IBlockAccess world, int x, int y, int z, int meta, int worldMeta) {
        return worldMeta;
    }

    @Override
    public void setCopperBlock(Block newBlock, int newMeta, World world, int x, int y, int z) {
        IDegradable.super.setCopperBlock(newBlock, newMeta, world, x, y, z);
        if (newBlock != world.func_147439_a(x, y - 1, z)) {
            world.func_147465_d(x, y - 1, z, newBlock, world.func_72805_g(x, y - 1, z), 2);
        }
    }

    @Override
    public boolean countTowardsDegredation(int meta, IBlockAccess world, int x, int y, int z) {
        return IDegradable.super.countTowardsDegredation(meta, world, x, y, z) && world.func_72805_g(x, y, z) > 7;
    }

    @Override
    public void playSound(World world, double x, double y, double z, int type) {
        if (this.playSound.get().booleanValue()) {
            IDegradable.super.playSound(world, x, y + 0.5, z, type);
        }
    }

    @Override
    public void spawnParticles(World world, int x, int y, int z, int type) {
        boolean top = world.func_72805_g(x, y, z) > 7;
        this.playSound.set(!top);
        IDegradable.super.spawnParticles(world, x, y, z, type);
        this.playSound.set(top);
        IDegradable.super.spawnParticles(world, x, top ? y - 1 : y + 1, z, type);
        this.playSound.set(true);
    }
}

