/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mantle.blocks.MantleBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;

public class SlimeGrass
extends MantleBlock {
    public String[] textureNames = new String[]{"slimegrass_green_top", "slimedirt_blue", "slimegrass_green_blue_side", "slimegrass_green_dirt_side"};
    public IIcon[] icons;

    public SlimeGrass() {
        super(Material.field_151577_b);
        this.func_149711_c(0.6f);
        this.func_149675_a(true);
        this.func_149647_a(TConstructRegistry.blockTab);
    }

    public int func_149692_a(int meta) {
        if (meta == 1) {
            return 0;
        }
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= 2) {
            meta = 0;
        }
        if (side == 0) {
            return meta % 2 == 1 ? Blocks.field_150346_d.func_149691_a(0, 0) : this.icons[1];
        }
        if (side == 1) {
            return this.icons[0];
        }
        return this.icons[meta + 2];
    }

    public void func_149666_a(Item b, CreativeTabs tab, List<ItemStack> list) {
        for (int iter = 0; iter < 1; ++iter) {
            list.add(new ItemStack(b, 1, iter));
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        EnumPlantType plantType = plant.getPlantType(world, x, y + 1, z);
        return plantType == EnumPlantType.Plains && plant.getPlant(world, x, y + 1, z) != Blocks.field_150329_H;
    }

    public void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        world.func_147465_d(x, y, z, TinkerTools.craftedSoil, 5, 3);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            if (world.func_72957_l(x, y + 1, z) < 4 && world.getBlockLightOpacity(x, y + 1, z) > 2) {
                world.func_147465_d(x, y, z, TinkerTools.craftedSoil, 5, 3);
            } else if (world.func_72957_l(x, y + 1, z) >= 9) {
                for (int l = 0; l < 4; ++l) {
                    int posX = x + random.nextInt(3) - 1;
                    int posY = y + random.nextInt(5) - 3;
                    int posZ = z + random.nextInt(3) - 1;
                    Block blockAbove = world.func_147439_a(posX, posY + 1, posZ);
                    if (world.func_72957_l(posX, posY + 1, posZ) < 4 || world.getBlockLightOpacity(posX, posY + 1, posZ) > 2 || blockAbove == TinkerTools.craftedSoil || blockAbove == this) continue;
                    Block block = world.func_147439_a(posX, posY, posZ);
                    if (block == Blocks.field_150346_d) {
                        world.func_147465_d(posX, posY, posZ, (Block)this, 1, 3);
                        return;
                    }
                    int blockMeta = world.func_72805_g(posX, posY, posZ);
                    if (block != TinkerTools.craftedSoil || blockMeta != 5) continue;
                    world.func_147465_d(posX, posY, posZ, (Block)this, 0, 3);
                }
            }
        }
    }

    public Block blockDropped(int metadata, Random random, int fortune) {
        if (metadata == 1) {
            return Blocks.field_150346_d;
        }
        return TinkerTools.craftedSoil;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (metadata == 1) {
            return Blocks.field_150346_d.func_149650_a(metadata, random, fortune);
        }
        return ItemSaddle.func_150898_a((Block)TinkerTools.craftedSoil);
    }
}

