/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.client.gui.GuiViewCommands;
import serverutils.lib.command.CommandTreeBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.ICommandWithPermission;

public class MessageCommandsResponse
extends MessageToClient {
    private Map<String, IChatComponent> commands;

    public MessageCommandsResponse() {
    }

    public MessageCommandsResponse(EntityPlayerMP player) {
        this.commands = new HashMap<String, IChatComponent>();
        for (ICommand command : CommandUtils.getAllCommands((ICommandSender)player)) {
            IChatComponent usage = CommandUtils.getTranslatedUsage(command, (ICommandSender)player);
            if (command instanceof CommandTreeBase) {
                CommandTreeBase cmdTree = (CommandTreeBase)command;
                StringBuilder builder = new StringBuilder();
                builder.append(" [");
                for (ICommand subCommand : cmdTree.getSubCommands()) {
                    builder.append(subCommand.func_71517_b()).append("|");
                }
                int index = builder.lastIndexOf("|");
                if (index != -1) {
                    builder.deleteCharAt(index);
                }
                builder.append("]");
                ChatComponentText subCommands = new ChatComponentText(builder.toString());
                usage.func_150257_a((IChatComponent)subCommands);
            }
            if (command instanceof ICommandWithPermission) {
                ICommandWithPermission cmd = (ICommandWithPermission)command;
                usage.func_150258_a("\n").func_150257_a((IChatComponent)new ChatComponentText("Added by: " + EnumChatFormatting.GOLD + cmd.serverutilities$getModName()));
            }
            this.commands.put(command.func_71517_b(), usage);
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeMap(this.commands, DataOut.STRING, DataOut.TEXT_COMPONENT);
    }

    @Override
    public void readData(DataIn data) {
        this.commands = data.readMap(DataIn.STRING, DataIn.TEXT_COMPONENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiViewCommands(this.commands).openGui();
    }
}

