/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.invsee.InvseeContainer;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.inventories.InvSeeInventories;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CmdTreeBase;
import serverutils.lib.command.CmdTreeHelp;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.net.MessageInvseeContainer;

public class CmdInv
extends CmdTreeBase {
    public CmdInv() {
        super("inv");
        this.addSubcommand(new CmdView());
        this.addSubcommand(new CmdDisableRightClick());
        this.addSubcommand((ICommand)new CmdTreeHelp(this));
    }

    public static class CmdView
    extends CmdBase {
        public CmdView() {
            super("view", CmdBase.Level.OP);
        }

        @Override
        public List<String> func_71516_a(ICommandSender sender, String[] args) {
            if (args.length == 1) {
                return Universe.get().getPlayers().stream().map(ForgePlayer::getName).filter(e -> StringUtils.startsWithIgnoreCase((CharSequence)e, (CharSequence)args[0])).collect(Collectors.toList());
            }
            return super.func_71516_a(sender, args);
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("edit");
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            this.checkArgs(sender, args, 1);
            EntityPlayerMP self = CmdView.func_71521_c((ICommandSender)sender);
            ForgePlayer other = Universe.get().getPlayer(args[0]);
            if (other == null || other.isFake() || other.getPlayerNBT() == null) {
                throw new CommandException("commands.generic.player.notFound", new Object[]{args[0]});
            }
            LinkedHashMap<InvSeeInventories, IInventory> inventories = new LinkedHashMap<InvSeeInventories, IInventory>();
            for (InvSeeInventories inv : InvSeeInventories.getActiveInventories()) {
                IModdedInventory modInv = inv.getInventory();
                IInventory inventory = other.isOnline() ? modInv.loadOnlineInventory(other.getPlayer()) : modInv.loadOfflineInventory(other);
                if (inventory == null) continue;
                inventories.put(inv, inventory);
            }
            self.func_71117_bO();
            new MessageInvseeContainer(other, inventories, self.field_71139_cq).sendTo(self);
            self.field_71070_bA = new InvseeContainer(inventories, (EntityPlayer)self, other);
            self.field_71070_bA.field_75152_c = self.field_71139_cq;
            self.field_71070_bA.func_75132_a((ICrafting)self);
        }
    }

    public static class CmdDisableRightClick
    extends CmdBase {
        public CmdDisableRightClick() {
            super("disable_right_click", CmdBase.Level.OP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            ItemStack stack;
            String s;
            LinkedHashSet<String> list = new LinkedHashSet<String>(Arrays.asList(ServerUtilitiesConfig.world.disabled_right_click_items));
            if (list.contains(s = (stack = CmdDisableRightClick.func_71521_c((ICommandSender)sender).func_70694_bm()).func_77973_b().func_77658_a() + (stack.func_77981_g() ? "@" + stack.func_77960_j() : ""))) {
                list.remove(s);
            } else {
                list.add(s);
            }
            ServerUtilitiesConfig.world.disabled_right_click_items = list.toArray(new String[0]);
            ConfigurationManager.save((Class[])new Class[]{ServerUtilitiesConfig.class});
        }
    }
}

