/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.google.gson.JsonElement;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.PanelScrollBar;
import serverutils.lib.gui.ScrollBar;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.TextField;
import serverutils.lib.gui.Theme;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.DataReader;
import serverutils.lib.io.HttpDataReader;
import serverutils.lib.io.RequestMethod;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageViewCrashDelete;

public class GuiViewCrash
extends GuiBase {
    private final TextField name;
    private final TextField text;
    private final Panel textPanel;
    private final PanelScrollBar scrollH;
    private final PanelScrollBar scrollV;
    private final Button close;
    private final Button upload;
    private final Button delete;
    private final Button reset;

    public GuiViewCrash(String n, Collection<String> l) {
        this.name = new TextField(this).setText(n);
        this.name.setPos(8, 12);
        this.textPanel = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(GuiViewCrash.this.text);
            }

            @Override
            public void alignWidgets() {
                GuiViewCrash.this.scrollH.setMaxValue(((GuiViewCrash)GuiViewCrash.this).text.width + 4);
                GuiViewCrash.this.scrollV.setMaxValue(((GuiViewCrash)GuiViewCrash.this).text.height);
            }

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawContainerSlot(x, y, w, h);
            }
        };
        this.text = new TextField(this.textPanel);
        this.text.setX(2);
        this.text.addFlags(8);
        this.text.setText(StringUtils.fixTabs(String.join((CharSequence)"\n", l), 2));
        this.textPanel.setPos(9, 33);
        this.textPanel.setUnicode(true);
        this.scrollH = new PanelScrollBar((Panel)this, ScrollBar.Plane.HORIZONTAL, this.textPanel);
        this.scrollH.setCanAlwaysScroll(true);
        this.scrollH.setCanAlwaysScrollPlane(false);
        this.scrollH.setScrollStep(30);
        this.scrollV = new PanelScrollBar(this, this.textPanel);
        this.scrollV.setCanAlwaysScroll(true);
        this.scrollV.setCanAlwaysScrollPlane(false);
        this.scrollV.setScrollStep(30);
        this.close = new SimpleButton(this, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]), GuiIcons.CLOSE, (widget, button) -> widget.getGui().closeGui());
        this.upload = new SimpleButton(this, I18n.func_135052_a((String)"serverutilities.lang.upload_crash", (Object[])new Object[0]), GuiIcons.UP, (widget, button) -> {
            new ThreadUploadCrash().start();
            widget.getGui().closeGui(false);
        });
        this.delete = new SimpleButton(this, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, (widget, button) -> this.openYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.name.text[0]}), "", () -> new MessageViewCrashDelete(this.name.text[0]).sendToServer()));
        this.reset = new SimpleButton(this, "", Icon.EMPTY, (widget, button) -> {
            this.scrollH.setValue(0);
            this.scrollV.setValue(0);
        });
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.textPanel);
        this.add(this.scrollH);
        this.add(this.scrollV);
        this.add(this.close);
        this.add(this.upload);
        this.add(this.delete);
        this.add(this.reset);
        this.add(this.name);
    }

    @Override
    public void alignWidgets() {
        this.close.setPosAndSize(this.width - 24, 8, 20, 20);
        this.upload.setPosAndSize(this.width - 48, 8, 20, 20);
        this.delete.setPosAndSize(this.width - 72, 8, 20, 20);
        this.reset.setPos(this.width - 24, this.height - 24);
        this.scrollH.setPosAndSize(8, this.height - 24, this.width - 32, 16);
        this.scrollV.setPosAndSize(this.width - 24, 32, 16, this.height - 56);
        this.textPanel.setSize(this.scrollH.width - 2, this.scrollV.height - 2);
        this.textPanel.alignWidgets();
    }

    public class ThreadUploadCrash
    extends Thread {
        @Override
        public void run() {
            try {
                String outText;
                URL mclogsURL;
                JsonElement json;
                File urlFile = new File(Minecraft.func_71410_x().field_71412_D, "serverutilities/server/uploaded_crash_reports/" + ((GuiViewCrash)GuiViewCrash.this).name.text[0]);
                String url = DataReader.get(urlFile).safeString();
                if (url.isEmpty() && (json = DataReader.get(mclogsURL = new URL("https://api.mclo.gs/1/log"), RequestMethod.POST, "application/x-www-form-urlencoded; charset=utf-8", new HttpDataReader.HttpDataOutput.StringOutput(outText = "content=" + URLEncoder.encode(StringUtils.fromStringList(Arrays.asList(((GuiViewCrash)GuiViewCrash.this).text.text)), "UTF-8")), Minecraft.func_71410_x().func_110437_J()).json()).isJsonObject() && json.getAsJsonObject().has("id")) {
                    url = "https://mclo.gs/" + json.getAsJsonObject().get("id").getAsString();
                    FileUtils.saveSafe(urlFile, url);
                }
                if (!url.isEmpty()) {
                    ChatComponentTranslation link = new ChatComponentTranslation("click_here", new Object[0]);
                    link.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                    link.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(url)));
                    link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation("serverutilities.lang.uploaded_crash", new Object[]{link}));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

