/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import com.brandon3055.draconicevolution.common.container.ContainerDataSync;
import com.brandon3055.draconicevolution.common.inventory.InventoryTool;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;

public class ContainerAdvTool
extends ContainerDataSync {
    public InventoryTool inventoryTool;
    private EntityPlayer player;
    public int inventoryItemSlot = -1;
    private boolean slotsActive = false;

    public ContainerAdvTool(InventoryPlayer invPlayer, InventoryTool inventory) {
        this.inventoryTool = inventory;
        this.inventoryTool.setContainer(this);
        this.player = invPlayer.field_70458_d;
        this.setSlotsActive(false);
    }

    public void setSlotsActive(boolean active) {
        this.slotsActive = active;
        this.field_75153_a = new ArrayList();
        this.field_75151_b = new ArrayList();
        if (this.slotsActive) {
            int y;
            int x;
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotPlayerInv((IInventory)this.player.field_71071_by, x, 8 + 18 * x, 103, this.inventoryItemSlot));
            }
            for (y = 0; y < 3; ++y) {
                for (int x2 = 0; x2 < 9; ++x2) {
                    this.func_75146_a(new SlotPlayerInv((IInventory)this.player.field_71071_by, x2 + y * 9 + 9, 8 + 18 * x2, 45 + y * 18, this.inventoryItemSlot));
                }
            }
            for (x = 0; x < this.inventoryTool.size; ++x) {
                this.func_75146_a(new SlotOblitFilter(this.inventoryTool, x, 8 + 18 * x, 19));
            }
            for (y = 0; y < 5; ++y) {
                this.func_75146_a(new SlotEnchantment(this.inventoryTool, this.inventoryTool.size + y, 173, 19 + y * 21));
            }
        } else {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotPlayerInv((IInventory)this.player.field_71071_by, x, -992 + 18 * x, -897, this.inventoryItemSlot));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new SlotPlayerInv((IInventory)this.player.field_71071_by, x + y * 9 + 9, -992 + 18 * x, -955 + y * 18, this.inventoryItemSlot));
                }
            }
        }
        if (this.player.field_70170_p.field_72995_K) {
            this.sendObjectToServer(null, 1, active ? 1 : 0);
        }
    }

    public void setInventory(InventoryTool inventory) {
        this.inventoryTool = inventory;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        return null;
    }

    @Override
    public void receiveSyncData(int index, int value) {
        if (index == 0) {
            this.updateInventoryStack(value);
        } else if (index == 1) {
            this.setSlotsActive(value == 1);
        }
    }

    public void updateInventoryStack(int slot) {
        this.inventoryItemSlot = slot;
        if (this.player.field_70170_p.field_72995_K) {
            this.sendObjectToServer(null, 0, slot);
        }
        if (this.player.field_71071_by.func_70301_a(slot) != null && this.player.field_71071_by.func_70301_a(slot).func_77973_b() instanceof IInventoryTool) {
            this.inventoryTool.setAndReadFromStack(this.player.field_71071_by.func_70301_a(slot), slot);
        }
    }

    public class SlotPlayerInv
    extends Slot {
        public int inventoryItemSlot;

        public SlotPlayerInv(IInventory iInventory, int slot, int x, int y, int inventoryItemSlot) {
            super(iInventory, slot, x, y);
            this.inventoryItemSlot = -1;
            this.inventoryItemSlot = inventoryItemSlot;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.inventoryItemSlot != this.field_75222_d && super.func_82869_a(player);
        }
    }

    public class SlotOblitFilter
    extends Slot {
        public SlotOblitFilter(IInventory iInventory, int slot, int x, int y) {
            super(iInventory, slot, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof ItemBlock && super.func_75214_a(stack);
        }
    }

    public class SlotEnchantment
    extends Slot {
        InventoryTool field_75224_c;

        public SlotEnchantment(IInventory iInventory, int slot, int x, int y) {
            super(iInventory, slot, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack == null || stack.func_77973_b() != Items.field_151134_bR || !stack.func_77942_o()) {
                return false;
            }
            NBTTagList list = stack.func_77978_p().func_150295_c("StoredEnchantments", 10);
            if (list.func_74745_c() != 1) {
                return false;
            }
            Enchantment enchant = Enchantment.field_77331_b[list.func_150305_b(0).func_74762_e("id")];
            if (ContainerAdvTool.this.inventoryTool.inventoryItem == null || !(ContainerAdvTool.this.inventoryTool.inventoryItem.func_77973_b() instanceof IInventoryTool) || !((IInventoryTool)ContainerAdvTool.this.inventoryTool.inventoryItem.func_77973_b()).isEnchantValid(enchant) && enchant.field_77351_y != EnumEnchantmentType.all) {
                return false;
            }
            if (EnchantmentHelper.func_82781_a((ItemStack)ContainerAdvTool.this.inventoryTool.inventoryItem).containsKey(list.func_150305_b(0).func_74762_e("id"))) {
                return false;
            }
            return super.func_75214_a(stack);
        }
    }
}

