/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools;

import com.github.dcysteine.neicustomdiagram.api.Formatter;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialtools.AutoValue_RecipeHandler_BaseTool;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.Registry;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFormatting;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import detrav.items.DetravMetaGeneratedTool01;
import gregtech.api.enums.Materials;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.recipe.RecipeMaps;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

class RecipeHandler {
    private static final Comparator<DisplayComponent> EU_CAPACITY_COMPARATOR = Comparator.comparing(d -> RecipeHandler.getEuCapacity((ItemComponent)d.component()).orElse(-1L)).thenComparing(Comparator.naturalOrder());
    private static final ImmutableList<Integer> TURBINE_TOOL_IDS = ImmutableList.of((Object)IDMetaTool01.TURBINE_SMALL.ID, (Object)IDMetaTool01.TURBINE.ID, (Object)IDMetaTool01.TURBINE_LARGE.ID, (Object)IDMetaTool01.TURBINE_HUGE.ID);
    private static final int ELECTRIC_SCANNER_ID_START = 100;
    private final SortedSetMultimap<BaseTool, ItemComponent> toolsMultimap = MultimapBuilder.hashKeys().treeSetValues().build();
    private final SortedSetMultimap<BaseTool, ItemComponent> gtPlusPlusToolsMultimap = MultimapBuilder.hashKeys().treeSetValues().build();
    private final SortedSetMultimap<BaseTool, ItemComponent> scannersMultimap = MultimapBuilder.hashKeys().treeSetValues().build();
    private final ListMultimap<Materials, ImmutableList<DisplayComponent>> materialToolsMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
    private final ListMultimap<Materials, ImmutableList<DisplayComponent>> materialTurbinesMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
    private final ListMultimap<Materials, ImmutableList<DisplayComponent>> materialScannersMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
    private final ListMultimap<Materials, ImmutableList<DisplayComponent>> materialElectricScannersMultimap = MultimapBuilder.hashKeys().arrayListValues().build();

    RecipeHandler() {
    }

    void initialize() {
        ImmutableList displayComponents;
        CraftingManager.func_77594_a().func_77592_b().forEach(recipe -> this.addTool(recipe.func_77571_b()));
        RecipeMaps.assemblerRecipes.getAllRecipes().forEach(recipe -> this.addTool(recipe.getOutput(0)));
        for (BaseTool baseTool : ImmutableSortedSet.copyOf((Collection)this.toolsMultimap.keySet())) {
            displayComponents = ImmutableList.copyOf((Collection)this.toolsMultimap.get((Object)baseTool).stream().map(RecipeHandler::buildDisplayComponent).sorted(EU_CAPACITY_COMPARATOR).collect(Collectors.toList()));
            if (TURBINE_TOOL_IDS.contains((Object)baseTool.itemComponent().damage())) {
                this.materialTurbinesMultimap.put((Object)baseTool.primaryMaterial(), (Object)displayComponents);
                continue;
            }
            this.materialToolsMultimap.put((Object)baseTool.primaryMaterial(), (Object)displayComponents);
        }
        for (BaseTool baseTool : ImmutableSortedSet.copyOf((Collection)this.gtPlusPlusToolsMultimap.keySet())) {
            displayComponents = ImmutableList.copyOf((Collection)this.gtPlusPlusToolsMultimap.get((Object)baseTool).stream().map(RecipeHandler::buildDisplayComponent).sorted(EU_CAPACITY_COMPARATOR).collect(Collectors.toList()));
            this.materialToolsMultimap.put((Object)baseTool.primaryMaterial(), (Object)displayComponents);
        }
        for (BaseTool baseTool : ImmutableSortedSet.copyOf((Collection)this.scannersMultimap.keySet())) {
            displayComponents = ImmutableList.copyOf((Collection)this.scannersMultimap.get((Object)baseTool).stream().map(RecipeHandler::buildDisplayComponent).sorted(EU_CAPACITY_COMPARATOR).collect(Collectors.toList()));
            if (baseTool.itemComponent().damage() >= 100) {
                this.materialElectricScannersMultimap.put((Object)baseTool.primaryMaterial(), (Object)displayComponents);
                continue;
            }
            this.materialScannersMultimap.put((Object)baseTool.primaryMaterial(), (Object)displayComponents);
        }
    }

    ImmutableList<ImmutableList<DisplayComponent>> getTools(Materials material) {
        return ImmutableList.copyOf((Collection)this.materialToolsMultimap.get((Object)material));
    }

    ImmutableList<ImmutableList<DisplayComponent>> getTurbines(Materials material) {
        return ImmutableList.copyOf((Collection)this.materialTurbinesMultimap.get((Object)material));
    }

    ImmutableList<ImmutableList<DisplayComponent>> getScanners(Materials material) {
        return ImmutableList.copyOf((Collection)this.materialScannersMultimap.get((Object)material));
    }

    ImmutableList<ImmutableList<DisplayComponent>> getElectricScanners(Materials material) {
        return ImmutableList.copyOf((Collection)this.materialElectricScannersMultimap.get((Object)material));
    }

    private void addTool(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() == MetaGeneratedTool01.INSTANCE) {
            this.toolsMultimap.put((Object)BaseTool.create(itemStack), (Object)ItemComponent.createWithNbt(itemStack));
        }
        if (Registry.ModDependency.GT_PLUS_PLUS.isLoaded() && itemStack.func_77973_b() == MetaGeneratedGregtechTools.INSTANCE) {
            this.gtPlusPlusToolsMultimap.put((Object)BaseTool.create(itemStack), (Object)ItemComponent.createWithNbt(itemStack));
        }
        if (Registry.ModDependency.DETRAV_SCANNER.isLoaded() && itemStack.func_77973_b() == DetravMetaGeneratedTool01.INSTANCE) {
            this.scannersMultimap.put((Object)BaseTool.create(itemStack), (Object)ItemComponent.createWithNbt(itemStack));
        }
    }

    private static Optional<Long> getEuCapacity(ItemComponent itemComponent) {
        Long[] electricStats = ((MetaGeneratedTool)itemComponent.item()).getElectricStats(itemComponent.stack());
        if (electricStats == null) {
            return Optional.empty();
        }
        return Optional.of(electricStats[0]);
    }

    private static DisplayComponent buildDisplayComponent(ItemComponent itemComponent) {
        DisplayComponent.Builder builder = DisplayComponent.builder(itemComponent);
        ItemStack itemStack = itemComponent.stack();
        Materials primaryMaterial = MetaGeneratedTool.getPrimaryMaterial((ItemStack)itemStack);
        Materials secondaryMaterial = MetaGeneratedTool.getSecondaryMaterial((ItemStack)itemStack);
        builder.setAdditionalTooltip(Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.GREGTECH_5_MATERIAL_TOOLS.transf("primarymateriallabel", GregTechFormatting.getMaterialDescription(primaryMaterial))).addTextLine(Lang.GREGTECH_5_MATERIAL_TOOLS.transf("secondarymateriallabel", GregTechFormatting.getMaterialDescription(secondaryMaterial))).build());
        RecipeHandler.getEuCapacity(itemComponent).ifPresent(euCapacity -> builder.setAdditionalInfo(Formatter.smartFormatInteger(euCapacity)));
        return builder.build();
    }

    @AutoValue
    static abstract class BaseTool
    implements Comparable<BaseTool> {
        private static final Comparator<BaseTool> COMPARATOR = Comparator.comparing(b -> b.primaryMaterial().mMetaItemSubID).thenComparing(b -> b.primaryMaterial().mName).thenComparing(BaseTool::itemComponent);

        BaseTool() {
        }

        private static BaseTool create(ItemStack itemStack) {
            return new AutoValue_RecipeHandler_BaseTool(ItemComponent.create(itemStack), MetaGeneratedTool.getPrimaryMaterial((ItemStack)itemStack));
        }

        abstract ItemComponent itemComponent();

        abstract Materials primaryMaterial();

        @Override
        public int compareTo(BaseTool other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

