/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.ComponentLabel;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import gregtech.api.enums.ItemList;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

class LabelHandler {
    private final EnumMap<ItemLabel, ItemComponent> componentMap = new EnumMap(ItemLabel.class);

    LabelHandler() {
    }

    void initialize() {
        for (ItemLabel itemLabel : ItemLabel.values()) {
            this.componentMap.put(itemLabel, itemLabel.itemComponentSupplier.get());
        }
    }

    CustomInteractable buildLabel(ItemLabel itemLabel, Point pos) {
        ComponentLabel label = ComponentLabel.create(this.componentMap.get((Object)itemLabel), pos);
        Tooltip tooltip = Tooltip.create(Lang.GREGTECH_5_CIRCUITS.trans(itemLabel.tooltipKey), Tooltip.INFO_FORMATTING);
        return CustomInteractable.builder(label).setTooltip(tooltip).build();
    }

    static enum ItemLabel {
        CRAFTING_TABLE(() -> ItemComponent.create(Blocks.field_150462_ai, 0).get(), "craftingtablelabel"),
        ASSEMBLING_MACHINE(() -> GregTechOreDictUtil.getComponent(ItemList.Machine_HV_Assembler), "assemblingmachinelabel"),
        ASSEMBLING_LINE(() -> GregTechOreDictUtil.getComponent(ItemList.Machine_Multi_Assemblyline), "assemblinglinelabel"),
        CIRCUIT_ASSEMBLING_MACHINE(() -> GregTechOreDictUtil.getComponent(ItemList.Machine_HV_CircuitAssembler), "circuitassemblingmachinelabel"),
        CLEAN_ROOM(() -> GregTechOreDictUtil.getComponent(ItemList.Machine_Multi_Cleanroom), "requirescleanroomlabel"),
        LOW_GRAVITY(() -> ItemComponent.create(Items.field_151008_G, 0), "requireslowgravitylabel");

        final Supplier<ItemComponent> itemComponentSupplier;
        final String tooltipKey;

        private ItemLabel(Supplier<ItemComponent> itemComponentSupplier, String tooltipKey) {
            this.itemComponentSupplier = itemComponentSupplier;
            this.tooltipKey = tooltipKey;
        }
    }
}

