/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.bugfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class MobCapHandler {
    private static Map<Class<? extends Entity>, Optional<EnumCreatureType>> creatureTypeLookup = new HashMap<Class<? extends Entity>, Optional<EnumCreatureType>>();

    public static boolean isCreatureType(Entity entity, EnumCreatureType type) {
        Class<?> cls = entity.getClass();
        Optional<EnumCreatureType> spawnTypeOpt = creatureTypeLookup.get(cls);
        if (spawnTypeOpt == null) {
            EnumCreatureType spawnType;
            List<EnumCreatureType> vanillaTypes = MobCapHandler.computeVanillaCreatureTypes(entity);
            if (entity.getClass().getName().startsWith("net.minecraft.")) {
                spawnType = vanillaTypes.isEmpty() ? null : vanillaTypes.get(0);
            } else if (vanillaTypes.isEmpty()) {
                CoreTweaks.LOGGER.debug("Creature " + entity.getClass().getName() + " has no type according to vanilla logic, leaving type as default: " + vanillaTypes);
                spawnType = null;
            } else {
                spawnType = MobCapHandler.computeSpawnType(entity);
                if (spawnType == null) {
                    CoreTweaks.LOGGER.debug("Creature " + entity.getClass().getName() + " is not in the biome spawn registry, leaving type as default: " + vanillaTypes);
                    spawnType = vanillaTypes.get(0);
                }
            }
            spawnTypeOpt = Optional.ofNullable(spawnType);
            creatureTypeLookup.put(cls, spawnTypeOpt);
            if (vanillaTypes.size() > 1 || vanillaTypes.size() == 1 && vanillaTypes.get(0) != spawnType) {
                CoreTweaks.LOGGER.debug("Changed creature type of " + entity.getClass().getName() + " from " + vanillaTypes + " to " + spawnType);
            }
        }
        return spawnTypeOpt.orElse(null) == type;
    }

    private static EnumCreatureType computeSpawnType(Entity entity) {
        int[] counts = new int[EnumCreatureType.values().length];
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            block1: for (EnumCreatureType type : EnumCreatureType.values()) {
                List spawnableList = biome.func_76747_a(type);
                if (spawnableList == null) continue;
                for (BiomeGenBase.SpawnListEntry entry : spawnableList) {
                    if (entry.field_76300_b != entity.getClass()) continue;
                    int n = type.ordinal();
                    counts[n] = counts[n] + 1;
                    continue block1;
                }
            }
        }
        int candidateCount = MobCapHandler.countNonZero(counts);
        if (candidateCount == 0) {
            return null;
        }
        EnumCreatureType type = EnumCreatureType.values()[MobCapHandler.maxIndex(counts)];
        if (candidateCount != 1) {
            ArrayList<EnumCreatureType> types = new ArrayList<EnumCreatureType>();
            for (int i = 0; i < counts.length; ++i) {
                if (counts[i] == 0) continue;
                types.add(EnumCreatureType.values()[i]);
            }
            CoreTweaks.LOGGER.debug("Entity " + entity.getClass().getName() + " has multiple spawn types registered: " + types + ". Choosing " + type);
        }
        return type;
    }

    private static List<EnumCreatureType> computeVanillaCreatureTypes(Entity entity) {
        ArrayList<EnumCreatureType> types = new ArrayList<EnumCreatureType>();
        for (EnumCreatureType type : EnumCreatureType.values()) {
            if (!MobCapHandler.vanillaIsCreatureType(entity, type)) continue;
            types.add(type);
        }
        return types;
    }

    private static boolean vanillaIsCreatureType(Entity entity, EnumCreatureType type) {
        return type.func_75598_a().isAssignableFrom(entity.getClass());
    }

    private static int maxIndex(int[] a) {
        int max = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    private static int countNonZero(int[] a) {
        int c = 0;
        for (int i : a) {
            if (i == 0) continue;
            ++c;
        }
        return c;
    }
}

