/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMConfig;
import com.recursive_pineapple.matter_manipulator.common.networking.Messages;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class Transform {
    public boolean flipX;
    public boolean flipY;
    public boolean flipZ;
    public ForgeDirection forward = ExtendedFacing.DEFAULT.getRelativeForwardInWorld();
    public ForgeDirection up = ForgeDirection.UP;
    public transient Matrix4f rotation;
    public static final int FLIP_X = 1;
    public static final int FLIP_Y = 2;
    public static final int FLIP_Z = 4;
    public static final int FORWARD_MASK = 56;
    public static final int FORWARD_SHIFT = 3;
    public static final int UP_MASK = 448;
    public static final int UP_SHIFT = 6;

    public static void sendRotate(ForgeDirection dir, boolean positive) {
        Messages.RotateTransform.sendToServer(dir.ordinal() & 0xFF | (positive ? 1 : 0) << 8);
    }

    public Matrix4f getRotation() {
        if (this.rotation != null) {
            return this.rotation;
        }
        Matrix4f flip = new Matrix4f();
        flip.scale(this.flipX ? -1.0f : 1.0f, this.flipY ? -1.0f : 1.0f, this.flipZ ? -1.0f : 1.0f);
        Matrix4f rot = new Matrix4f().lookAlong((Vector3fc)Transform.v(this.forward), (Vector3fc)Transform.v(this.up));
        return rot.mul((Matrix4fc)flip);
    }

    public void cacheRotation() {
        this.rotation = this.getRotation();
    }

    public void uncacheRotation() {
        this.rotation = null;
    }

    public ExtendedFacing apply(ExtendedFacing facing) {
        if (facing == null) {
            return null;
        }
        return Transform.transform(facing, this.getRotation());
    }

    public ForgeDirection apply(ForgeDirection dir) {
        if (dir == null) {
            return null;
        }
        if (dir == ForgeDirection.UNKNOWN) {
            return ForgeDirection.UNKNOWN;
        }
        return Transform.vprime(Transform.v(dir).mulTransposeDirection((Matrix4fc)this.getRotation()));
    }

    public byte applyBits(int bitmask) {
        if (bitmask == 0) {
            return 0;
        }
        int out = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if ((bitmask & dir.flag) == 0) continue;
            out |= this.apply((ForgeDirection)dir).flag;
        }
        return (byte)out;
    }

    public Vector3i apply(Vector3i v) {
        Vector3f v2 = new Vector3f((Vector3ic)v).mulTransposeDirection((Matrix4fc)this.getRotation());
        v.x = Math.round(v2.x);
        v.y = Math.round(v2.y);
        v.z = Math.round(v2.z);
        return v;
    }

    public MMConfig.VoxelAABB apply(MMConfig.VoxelAABB bb) {
        bb.a.sub((Vector3ic)bb.origin);
        this.apply(bb.a);
        bb.a.add((Vector3ic)bb.origin);
        bb.b.sub((Vector3ic)bb.origin);
        this.apply(bb.b);
        bb.b.add((Vector3ic)bb.origin);
        return bb;
    }

    public void rotate(ForgeDirection dir, int amount) {
        this.rotation = null;
        Matrix4f rot = new Matrix4f().rotate((float)(1.5707963267948966 * (double)amount), (Vector3fc)Transform.v(dir));
        this.up = Transform.transform(this.up, rot);
        this.forward = Transform.transform(this.forward, rot);
    }

    public String toString() {
        return "Transform [flipX=" + this.flipX + ", flipY=" + this.flipY + ", flipZ=" + this.flipZ + ", forward=" + this.forward + ", up=" + this.up + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flipX ? 1231 : 1237);
        result = 31 * result + (this.flipY ? 1231 : 1237);
        result = 31 * result + (this.flipZ ? 1231 : 1237);
        result = 31 * result + (this.forward == null ? 0 : this.forward.hashCode());
        result = 31 * result + (this.up == null ? 0 : this.up.hashCode());
        result = 31 * result + (this.rotation == null ? 0 : this.rotation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transform other = (Transform)obj;
        if (this.flipX != other.flipX) {
            return false;
        }
        if (this.flipY != other.flipY) {
            return false;
        }
        if (this.flipZ != other.flipZ) {
            return false;
        }
        if (this.forward != other.forward) {
            return false;
        }
        if (this.up != other.up) {
            return false;
        }
        return !(this.rotation == null ? other.rotation != null : !this.rotation.equals((Object)other.rotation));
    }

    private static Vector3f v(ForgeDirection dir) {
        return new Vector3f((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
    }

    private static ForgeDirection vprime(Vector3f dir) {
        ForgeDirection forgeDirection;
        switch (dir.maxComponent()) {
            case 0: {
                if (dir.x > 0.0f) {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 1: {
                if (dir.y > 0.0f) {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case 2: {
                if (dir.z > 0.0f) {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return forgeDirection;
    }

    public static Matrix4f fromFacing(ExtendedFacing facing) {
        Matrix4f matrix4f;
        Matrix4f matrix4f2;
        switch (facing.getDirection()) {
            case UP: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.UP), (Vector3fc)Transform.v(ForgeDirection.NORTH));
                break;
            }
            case DOWN: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.DOWN), (Vector3fc)Transform.v(ForgeDirection.NORTH));
                break;
            }
            case NORTH: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.NORTH), (Vector3fc)Transform.v(ForgeDirection.UP));
                break;
            }
            case SOUTH: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.SOUTH), (Vector3fc)Transform.v(ForgeDirection.UP));
                break;
            }
            case EAST: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.EAST), (Vector3fc)Transform.v(ForgeDirection.UP));
                break;
            }
            case WEST: {
                matrix4f2 = new Matrix4f().lookAlong((Vector3fc)Transform.v(ForgeDirection.WEST), (Vector3fc)Transform.v(ForgeDirection.UP));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Matrix4f dir = matrix4f2;
        switch (facing.getRotation()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CLOCKWISE: {
                matrix4f = new Matrix4f().rotate(1.5707964f, (Vector3fc)Transform.v(ForgeDirection.NORTH));
                break;
            }
            case COUNTER_CLOCKWISE: {
                matrix4f = new Matrix4f().rotate(-1.5707964f, (Vector3fc)Transform.v(ForgeDirection.NORTH));
                break;
            }
            case NORMAL: {
                matrix4f = new Matrix4f();
                break;
            }
            case UPSIDE_DOWN: {
                matrix4f = new Matrix4f().rotate((float)Math.PI, (Vector3fc)Transform.v(ForgeDirection.NORTH));
            }
        }
        Matrix4f rot = matrix4f;
        Matrix4f flip = new Matrix4f();
        if (facing.getFlip().isHorizontallyFlipped()) {
            flip.scale(-1.0f, 1.0f, 1.0f);
        }
        if (facing.getFlip().isVerticallyFliped()) {
            flip.scale(1.0f, -1.0f, 1.0f);
        }
        return rot.mul((Matrix4fc)flip).mul((Matrix4fc)dir);
    }

    public static ForgeDirection transform(ForgeDirection dir, Matrix4f transform) {
        return Transform.vprime(Transform.v(dir).mulTransposeDirection((Matrix4fc)transform));
    }

    public static ExtendedFacing transform(ExtendedFacing facing, Matrix4f transform) {
        ForgeDirection forward = Transform.transform(facing.getRelativeForwardInWorld(), transform);
        ForgeDirection left = Transform.transform(facing.getRelativeLeftInWorld(), transform);
        ForgeDirection down = Transform.transform(facing.getRelativeDownInWorld(), transform);
        for (ExtendedFacing candidate : ExtendedFacing.getAllWith((ForgeDirection)forward)) {
            if (candidate.getRelativeLeftInWorld() != left || candidate.getRelativeDownInWorld() != down || candidate.getFlip().isVerticallyFliped()) continue;
            return candidate;
        }
        return null;
    }
}

