/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.material;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.block.base.BlockBaseOre;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.base.bolts.BaseItemBolt;
import gtPlusPlus.core.item.base.dusts.BaseItemDust;
import gtPlusPlus.core.item.base.gears.BaseItemGear;
import gtPlusPlus.core.item.base.ingots.BaseItemIngot;
import gtPlusPlus.core.item.base.ingots.BaseItemIngotHot;
import gtPlusPlus.core.item.base.nugget.BaseItemNugget;
import gtPlusPlus.core.item.base.ore.BaseItemCentrifugedCrushedOre;
import gtPlusPlus.core.item.base.ore.BaseItemCrushedOre;
import gtPlusPlus.core.item.base.ore.BaseItemImpureDust;
import gtPlusPlus.core.item.base.ore.BaseItemPurifiedCrushedOre;
import gtPlusPlus.core.item.base.ore.BaseItemPurifiedDust;
import gtPlusPlus.core.item.base.ore.BaseItemRawOre;
import gtPlusPlus.core.item.base.plates.BaseItemPlate;
import gtPlusPlus.core.item.base.plates.BaseItemPlateDense;
import gtPlusPlus.core.item.base.plates.BaseItemPlateDouble;
import gtPlusPlus.core.item.base.rings.BaseItemRing;
import gtPlusPlus.core.item.base.rods.BaseItemRod;
import gtPlusPlus.core.item.base.rods.BaseItemRodLong;
import gtPlusPlus.core.item.base.rotors.BaseItemRotor;
import gtPlusPlus.core.item.base.screws.BaseItemScrew;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.nuclear.MaterialsFluorides;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenAlloySmelter;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenAssembler;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBlastSmelter;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenDustGeneration;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenExtruder;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenFluidCanning;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenFluids;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenFluorite;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenMaterialProcessing;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenMetalRecipe;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenOre;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenPlasma;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenPlates;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenRecycling;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenShapedCrafting;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MaterialGenerator {
    public static final ArrayList<Set<RunnableWithInfo<Material>>> mRecipeMapsToGenerate = new ArrayList();
    private static volatile Item temp;
    private static volatile Block tempBlock;

    @Deprecated
    public static boolean addFluidCannerRecipe(ItemStack aEmpty, ItemStack aFullContainer, FluidStack aFluidIn, FluidStack rFluidOut) {
        return MaterialGenerator.addFluidCannerRecipe(aEmpty, aFullContainer, aFluidIn, rFluidOut, null, null);
    }

    @Deprecated
    public static boolean addFluidCannerRecipe(ItemStack aEmpty, ItemStack aFullContainer, FluidStack aFluidIn, FluidStack rFluidOut, Integer aTime, Integer aEu) {
        RecipeGenFluidCanning g = new RecipeGenFluidCanning(false, aEmpty, aFullContainer, aFluidIn, null, null, 0);
        return g.valid();
    }

    public static void generate(Material matInfo) {
        MaterialGenerator.generate(matInfo, true);
    }

    public static void generate(Material matInfo, boolean generateEverything) {
        MaterialGenerator.generate(matInfo, generateEverything, true);
    }

    public static boolean generate(Material matInfo, boolean generateEverything, boolean generateBlastSmelterRecipes) {
        try {
            String unlocalizedName = matInfo.getUnlocalizedName();
            String materialName = matInfo.getLocalizedName();
            short[] C = matInfo.getRGBA();
            int Colour = Utils.rgbtoHexValue(C[0], C[1], C[2]);
            boolean hotIngot = matInfo.requiresBlastFurnace();
            int materialTier = matInfo.vTier;
            if (materialTier > 10 || materialTier <= 0) {
                materialTier = 2;
            }
            byte sRadiation = 0;
            if (ItemUtils.getRadioactivityLevel(materialName) > 0 || matInfo.vRadiationLevel != 0) {
                sRadiation = matInfo.vRadiationLevel;
            }
            if (matInfo.getState() == MaterialState.SOLID) {
                if (generateEverything) {
                    if (sRadiation >= 1) {
                        tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
                        temp = new BaseItemIngot(matInfo);
                        temp = new BaseItemDust(matInfo);
                        temp = new BaseItemNugget(matInfo);
                        temp = new BaseItemPlate(matInfo);
                        temp = new BaseItemRod(matInfo);
                        temp = new BaseItemRodLong(matInfo);
                    } else {
                        tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
                        tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.FRAME);
                        temp = new BaseItemIngot(matInfo);
                        if (hotIngot) {
                            temp = new BaseItemIngotHot(matInfo);
                        }
                        temp = new BaseItemDust(matInfo);
                        temp = new BaseItemNugget(matInfo);
                        temp = new BaseItemPlate(matInfo);
                        temp = new BaseItemPlateDouble(matInfo);
                        temp = new BaseItemBolt(matInfo);
                        temp = new BaseItemRod(matInfo);
                        temp = new BaseItemRodLong(matInfo);
                        temp = new BaseItemRing(matInfo);
                        temp = new BaseItemScrew(matInfo);
                        temp = new BaseItemRotor(matInfo);
                        temp = new BaseItemGear(matInfo);
                        temp = new BaseItemPlateDense(matInfo);
                    }
                } else {
                    tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
                    temp = new BaseItemIngot(matInfo);
                    temp = new BaseItemDust(matInfo);
                    temp = new BaseItemNugget(matInfo);
                    temp = new BaseItemPlate(matInfo);
                    temp = new BaseItemPlateDouble(matInfo);
                }
            } else if (matInfo.getState() == MaterialState.LIQUID) {
                if (generateEverything) {
                    tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
                }
                temp = new BaseItemIngot(matInfo);
                temp = new BaseItemDust(matInfo);
                temp = new BaseItemNugget(matInfo);
                temp = new BaseItemPlate(matInfo);
                temp = new BaseItemPlateDouble(matInfo);
            } else if (matInfo.getState() == MaterialState.GAS) {
                temp = new BaseItemDust(matInfo);
                FluidUtils.generateGas(unlocalizedName, materialName, matInfo.getMeltingPointK(), C, true);
            } else {
                if (matInfo.getState() == MaterialState.PURE_GAS) {
                    FluidUtils.generateGas(unlocalizedName, materialName, matInfo.getMeltingPointK(), C, true);
                    return true;
                }
                if (matInfo.getState() == MaterialState.PURE_LIQUID) {
                    FluidUtils.generateFluidNoPrefix(unlocalizedName, materialName, matInfo.getMeltingPointK(), C);
                    return true;
                }
            }
            new RecipeGenAlloySmelter(matInfo);
            new RecipeGenAssembler(matInfo);
            if (generateBlastSmelterRecipes) {
                new RecipeGenBlastSmelter(matInfo);
            }
            new RecipeGenMetalRecipe(matInfo);
            new RecipeGenExtruder(matInfo);
            new RecipeGenFluids(matInfo);
            new RecipeGenPlates(matInfo);
            new RecipeGenShapedCrafting(matInfo);
            new RecipeGenMaterialProcessing(matInfo);
            new RecipeGenDustGeneration(matInfo);
            new RecipeGenRecycling(matInfo);
            new RecipeGenPlasma(matInfo);
            return true;
        }
        catch (Throwable t) {
            Logger.MATERIALS(matInfo.getLocalizedName() + " failed to generate.");
            return false;
        }
    }

    public static void generateDusts(Material matInfo) {
        String unlocalizedName = matInfo.getUnlocalizedName();
        String materialName = matInfo.getLocalizedName();
        short[] C = matInfo.getRGBA();
        int Colour = Utils.rgbtoHexValue(C[0], C[1], C[2]);
        int materialTier = matInfo.vTier;
        if (materialTier > 10 || materialTier <= 0) {
            materialTier = 2;
        }
        byte sRadiation = 0;
        if (ItemUtils.getRadioactivityLevel(materialName) > 0 || matInfo.vRadiationLevel != 0) {
            sRadiation = matInfo.vRadiationLevel;
        }
        if (matInfo.getState() == MaterialState.SOLID) {
            temp = new BaseItemDust(matInfo);
        }
        try {
            RecipeGenDustGeneration.addMixerRecipe_Standalone(matInfo);
            new RecipeGenFluids(matInfo);
            new RecipeGenMaterialProcessing(matInfo);
        }
        catch (Throwable t) {
            Logger.MATERIALS("Failed to generate some recipes for " + materialName);
            Logger.ERROR("Failed to generate some recipes for " + materialName);
            t.printStackTrace();
        }
    }

    public static void generateNuclearMaterial(Material matInfo) {
        MaterialGenerator.generateNuclearMaterial(matInfo, true);
    }

    public static void generateNuclearDusts(Material matInfo) {
        MaterialGenerator.generateNuclearDusts(matInfo, true);
    }

    public static void generateNuclearDusts(Material matInfo, boolean generateDehydratorRecipe) {
        MaterialGenerator.generateNuclearMaterial(matInfo, false, true, false, false, true);
        if (generateDehydratorRecipe && matInfo.getFluid() != null && matInfo.getDust(0) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20)).itemOutputs(matInfo.getDust(1)).fluidInputs(matInfo.getFluidStack(144)).eut(matInfo.vVoltageMultiplier).duration(10 * (matInfo.vVoltageMultiplier / 5)).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        } else {
            Logger.INFO("Nuclear Dehydrator: Did not generate recipe for " + matInfo.getLocalizedName() + " | Null Fluid? " + (matInfo.getFluid() == null) + " | Null Dust? " + (matInfo.getDust(0) == null));
        }
    }

    public static void generateNuclearMaterial(Material matInfo, boolean generatePlates) {
        MaterialGenerator.generateNuclearMaterial(matInfo, true, true, true, generatePlates, true);
    }

    public static void generateNuclearMaterial(Material matInfo, boolean generateBlock, boolean generateDusts, boolean generateIngot, boolean generatePlates, boolean disableOptionalRecipes) {
        try {
            if (generateBlock) {
                tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
            }
            if (generateDusts) {
                temp = new BaseItemDust(matInfo);
            }
            if (generateIngot) {
                temp = new BaseItemIngot(matInfo);
                temp = new BaseItemNugget(matInfo);
            }
            if (generatePlates) {
                temp = new BaseItemPlate(matInfo);
                temp = new BaseItemPlateDouble(matInfo);
                new RecipeGenPlates(matInfo);
                new RecipeGenExtruder(matInfo);
                new RecipeGenAssembler(matInfo);
            }
            if (!disableOptionalRecipes) {
                new RecipeGenShapedCrafting(matInfo);
                new RecipeGenMaterialProcessing(matInfo);
            }
            new RecipeGenRecycling(matInfo);
            new RecipeGenFluids(matInfo);
            new RecipeGenMetalRecipe(matInfo);
            new RecipeGenDustGeneration(matInfo, disableOptionalRecipes);
            new RecipeGenPlasma(matInfo);
        }
        catch (Throwable t) {
            Logger.MATERIALS(matInfo.getLocalizedName() + " failed to generate.");
        }
    }

    public static void generateOreMaterial(Material matInfo) {
        MaterialGenerator.generateOreMaterial(matInfo, true, true, true, matInfo.getRGBA());
    }

    public static void generateOreMaterial(Material matInfo, boolean generateOre, boolean generateDust, boolean generateSmallTinyDusts, short[] customRGB) {
        try {
            BaseItemDust.DustState aState;
            if (matInfo == null) {
                Logger.DEBUG_MATERIALS("Invalid Material while constructing null material.");
                return;
            }
            String unlocalizedName = matInfo.getUnlocalizedName();
            String materialName = matInfo.getLocalizedName();
            byte sRadiation = 0;
            if (matInfo.vRadiationLevel > 0) {
                sRadiation = matInfo.vRadiationLevel;
            }
            if (generateOre) {
                tempBlock = new BlockBaseOre(matInfo, BasicBlock.BlockTypes.ORE);
            }
            if (!(aState = new BaseItemDust.DustState(generateDust, generateSmallTinyDusts, generateSmallTinyDusts)).generatesDust()) {
                if (aState.generatesSmallDust()) {
                    temp = new BaseItemComponent(matInfo, BaseItemComponent.ComponentTypes.DUSTSMALL);
                }
                if (aState.generatesTinyDust()) {
                    temp = new BaseItemComponent(matInfo, BaseItemComponent.ComponentTypes.DUSTTINY);
                }
            } else {
                temp = new BaseItemDust(aState, matInfo);
            }
            temp = new BaseItemCrushedOre(matInfo);
            temp = new BaseItemCentrifugedCrushedOre(matInfo);
            temp = new BaseItemPurifiedCrushedOre(matInfo);
            temp = new BaseItemImpureDust(matInfo);
            temp = new BaseItemPurifiedDust(matInfo);
            temp = new BaseItemRawOre(matInfo);
            Logger.MATERIALS("Generated all ore components for " + matInfo.getLocalizedName() + ", now generating processing recipes.");
            if (matInfo == MaterialsFluorides.FLUORITE) {
                new RecipeGenFluorite(matInfo);
            } else {
                new RecipeGenOre(matInfo);
            }
        }
        catch (Throwable t) {
            Logger.MATERIALS("[Error] " + (matInfo != null ? matInfo.getLocalizedName() : "Null Material") + " failed to generate.");
            t.printStackTrace();
        }
    }

    public static boolean generateOreMaterialWithAllExcessComponents(Material matInfo) {
        try {
            if (matInfo == null) {
                Logger.DEBUG_MATERIALS("Invalid Material while constructing null material.");
                return false;
            }
            short[] C = matInfo.getRGBA();
            Integer Colour = Utils.rgbtoHexValue(C[0], C[1], C[2]);
            tempBlock = new BlockBaseOre(matInfo, BasicBlock.BlockTypes.ORE);
            tempBlock = new BlockBaseModular(matInfo, BasicBlock.BlockTypes.STANDARD);
            temp = new BaseItemIngot(matInfo);
            temp = new BaseItemDust(matInfo);
            temp = new BaseItemNugget(matInfo);
            temp = new BaseItemPlate(matInfo);
            temp = new BaseItemPlateDouble(matInfo);
            temp = new BaseItemCrushedOre(matInfo);
            temp = new BaseItemCentrifugedCrushedOre(matInfo);
            temp = new BaseItemPurifiedCrushedOre(matInfo);
            temp = new BaseItemImpureDust(matInfo);
            temp = new BaseItemPurifiedDust(matInfo);
            temp = new BaseItemRawOre(matInfo);
            Logger.MATERIALS("Generated all ore & base components for " + matInfo.getLocalizedName() + ", now generating processing recipes.");
            new RecipeGenOre(matInfo, true);
            new RecipeGenAlloySmelter(matInfo);
            new RecipeGenAssembler(matInfo);
            new RecipeGenBlastSmelter(matInfo);
            new RecipeGenMetalRecipe(matInfo);
            new RecipeGenExtruder(matInfo);
            new RecipeGenFluids(matInfo);
            new RecipeGenPlates(matInfo);
            new RecipeGenShapedCrafting(matInfo);
            new RecipeGenMaterialProcessing(matInfo);
            new RecipeGenDustGeneration(matInfo);
            new RecipeGenRecycling(matInfo);
            new RecipeGenPlasma(matInfo);
            return true;
        }
        catch (Throwable t) {
            Logger.MATERIALS(matInfo.getLocalizedName() + " failed to generate.");
            t.printStackTrace();
            return false;
        }
    }
}

