/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.redstonecircuits;

import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.util.CircuitryBehavior;
import net.minecraft.util.StatCollector;

public class CircuitRandomizer
extends CircuitryBehavior {
    public CircuitRandomizer(int aIndex) {
        super(aIndex);
    }

    @Override
    public void initParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        aCircuitData[0] = 1;
        aCircuitData[4] = 0;
    }

    @Override
    public void validateParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        if (aCircuitData[0] < 1) {
            aCircuitData[0] = 1;
        }
        if (aCircuitData[3] < 0) {
            aCircuitData[3] = 0;
        }
        if (aCircuitData[3] > 1) {
            aCircuitData[3] = 1;
        }
        if (aCircuitData[4] < 0) {
            aCircuitData[4] = 0;
        }
    }

    @Override
    public void onTick(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        aCircuitData[4] = aCircuitData[3] == 1 ? (CircuitRandomizer.getAnyRedstone(aRedstoneCircuitBlock) ? aCircuitData[4] + 1 : 0) : (CircuitRandomizer.getAnyRedstone(aRedstoneCircuitBlock) ? 0 : aCircuitData[4] + 1);
        if (aCircuitData[4] >= aCircuitData[0]) {
            aCircuitData[4] = 0;
            aRedstoneCircuitBlock.setRedstone((byte)aRedstoneCircuitBlock.getRandom(16), aRedstoneCircuitBlock.getOutputFacing());
        }
    }

    @Override
    public String getName() {
        return StatCollector.func_74838_a((String)"GT5U.gui.circuit.randomizer.name");
    }

    @Override
    public String getDescription() {
        return StatCollector.func_74838_a((String)"GT5U.gui.circuit.randomizer.description");
    }

    @Override
    public String getDataDescription(int[] aCircuitData, int aCircuitDataIndex) {
        String string;
        switch (aCircuitDataIndex) {
            case 0: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.data_description.delay");
                break;
            }
            case 3: {
                if (aCircuitData[aCircuitDataIndex] == 1) {
                    string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.data_description.rs_on");
                    break;
                }
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.data_description.rs_off");
                break;
            }
            case 4: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.randomizer.data_description.status");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getDataDisplay(int[] aCircuitData, int aCircuitDataIndex) {
        if (aCircuitDataIndex != 0) {
            return "";
        }
        return null;
    }
}

