/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import appeng.api.util.DimensionalCoord;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class PacketDebugRedstoneCover
extends GTPacket {
    private int dim;
    private int[] coords;
    private boolean teleportPlayer;
    private EntityPlayerMP player;

    public PacketDebugRedstoneCover() {
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.DEBUG_COVER.id;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt(this.dim);
        for (int i = 0; i < 3; ++i) {
            buf.writeInt(this.coords[i]);
        }
        buf.writeBoolean(this.teleportPlayer);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buf) {
        return new PacketDebugRedstoneCover(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.player = ((NetHandlerPlayServer)aHandler).field_147369_b;
        }
    }

    @Override
    public void process(IBlockAccess world) {
        int x = this.coords[0];
        int y = this.coords[1];
        int z = this.coords[2];
        ServerConfigurationManager manager = this.player.field_71133_b.func_71203_ab();
        if (this.teleportPlayer && manager.func_152596_g(this.player.func_146103_bH())) {
            if (this.player.field_71093_bK != this.dim) {
                manager.func_72356_a(this.player, this.dim);
            }
            this.player.field_71135_a.func_147364_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, this.player.field_71109_bG, this.player.field_70726_aT);
        }
        ArrayList<DimensionalCoord> list = new ArrayList<DimensionalCoord>();
        list.add(new DimensionalCoord(x, y, z, this.dim));
        double deltaX = (double)x + 0.5 - this.player.field_70165_t;
        double deltaY = (double)y - this.player.field_70163_u - 1.0;
        double deltaZ = (double)z + 0.5 - this.player.field_70161_v;
        double distanceXZ = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)Math.toDegrees(Math.atan2(-deltaX, deltaZ));
        float pitch = (float)Math.toDegrees(Math.atan2(-deltaY, distanceXZ));
        if (this.dim == this.player.field_71093_bK) {
            this.player.field_71135_a.func_147364_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, yaw, pitch);
        } else {
            this.player.func_145747_a((IChatComponent)new ChatComponentText("Cannot highlight because you're not in the same dimension!"));
        }
    }

    public PacketDebugRedstoneCover(int dim, int x, int y, int z, boolean teleportPlayer) {
        this.dim = dim;
        this.coords = new int[]{x, y, z};
        this.teleportPlayer = teleportPlayer;
    }
}

