/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GTPacketBlockEvent
extends GTPacket {
    private int worldId;
    private int eventCount;
    private LongList packedCoordinates;
    private ShortList idsAndValues;

    public GTPacketBlockEvent() {
    }

    public GTPacketBlockEvent(int worldID, int eventCount, LongList packedCoordinates, ShortList idsAndValues) {
        this.worldId = worldID;
        this.eventCount = eventCount;
        this.packedCoordinates = packedCoordinates;
        this.idsAndValues = idsAndValues;
    }

    @Override
    public void encode(ByteBuf buffer) {
        int i;
        buffer.writeInt(this.worldId);
        buffer.writeInt(this.eventCount);
        for (i = 0; i < this.eventCount; ++i) {
            buffer.writeLong(this.packedCoordinates.getLong(i));
        }
        for (i = 0; i < this.eventCount; ++i) {
            buffer.writeShort((int)this.idsAndValues.getShort(i));
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        int i;
        GTPacketBlockEvent packet = new GTPacketBlockEvent();
        packet.worldId = buffer.readInt();
        packet.eventCount = buffer.readInt();
        packet.packedCoordinates = new LongArrayList();
        packet.idsAndValues = new ShortArrayList();
        for (i = 0; i < packet.eventCount; ++i) {
            packet.packedCoordinates.add(buffer.readLong());
        }
        for (i = 0; i < packet.eventCount; ++i) {
            packet.idsAndValues.add(buffer.readShort());
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return;
        }
        World world = (World)blockAccess;
        if (world.field_73011_w.field_76574_g != this.worldId) {
            return;
        }
        for (int i = 0; i < this.eventCount; ++i) {
            int z;
            int y;
            long packedCoordinate = this.packedCoordinates.getLong(i);
            int x = CoordinatePacker.unpackX((long)packedCoordinate);
            TileEntity tileEntity = world.func_147438_o(x, y = CoordinatePacker.unpackY((long)packedCoordinate), z = CoordinatePacker.unpackZ((long)packedCoordinate));
            if (tileEntity == null) continue;
            short idAndValue = this.idsAndValues.getShort(i);
            byte id = (byte)(idAndValue >>> 8);
            byte type = (byte)(idAndValue & 0xFF);
            tileEntity.func_145842_c((int)id, (int)type);
        }
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.BLOCK_EVENT.id;
    }
}

