/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.pollution.Pollution;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchMuffler
extends MTEHatch {
    private static final String localizedDescFormat = GTLanguageManager.addStringLocalization("gt.blockmachines.hatch.muffler.desc.format", "Outputs the Pollution (Might cause ... things)%nDO NOT OBSTRUCT THE OUTPUT!%nReduces Pollution to %d%%%n");
    private final int pollutionReduction = this.calculatePollutionReduction(100);
    private final int pollutionRecover = 100 - this.pollutionReduction;
    private final String[] description = String.format(localizedDescFormat, this.pollutionReduction, this.pollutionRecover).split("\\R");

    public MTEHatchMuffler(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
    }

    public MTEHatchMuffler(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTEHatchMuffler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, 0, aDescription, aTextures);
    }

    public MTEHatchMuffler(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchMuffler(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.getBaseMetaTileEntity().isActive()) {
            this.pollutionParticles(this.getBaseMetaTileEntity().getWorld(), ParticleFX.LARGE_SMOKE.toString());
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void pollutionParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        boolean chk3;
        boolean chk2;
        float ran3;
        float ran2;
        boolean chk1;
        float ran1 = XSTR.XSTR_INSTANCE.nextFloat();
        boolean bl = chk1 = ran1 * 100.0f < (float)this.calculatePollutionReduction(100);
        if (Pollution.getPollution(this.getBaseMetaTileEntity()) >= GTMod.proxy.mPollutionSmogLimit) {
            ran2 = XSTR.XSTR_INSTANCE.nextFloat();
            ran3 = XSTR.XSTR_INSTANCE.nextFloat();
            chk2 = ran2 * 100.0f < (float)this.calculatePollutionReduction(100);
            boolean bl2 = chk3 = ran3 * 100.0f < (float)this.calculatePollutionReduction(100);
            if (!(chk1 || chk2 || chk3)) {
                return;
            }
        } else {
            if (!chk1) {
                return;
            }
            ran3 = 0.0f;
            ran2 = 0.0f;
            chk3 = false;
            chk2 = false;
        }
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = aMuffler.getFrontFacing();
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.25f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * XSTR.XSTR_INSTANCE.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = XSTR.XSTR_INSTANCE.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * XSTR.XSTR_INSTANCE.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * XSTR.XSTR_INSTANCE.nextFloat());
        }
        WorldSpawnedEventBuilder.ParticleEventBuilder events = new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier(name).setWorld(aWorld).setMotion(xSpd, ySpd, zSpd);
        if (chk1) {
            events.setPosition(xPos + ran1 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
        if (chk2) {
            events.setPosition(xPos + ran2 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
        if (chk3) {
            events.setPosition(xPos + ran3 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
    }

    public int calculatePollutionReduction(int aPollution) {
        if (this.mTier < 2) {
            return aPollution;
        }
        return (int)((float)aPollution * ((100.0f - 12.5f * ((float)this.mTier - 1.0f)) / 100.0f));
    }

    public boolean polluteEnvironment(MetaTileEntity mte, int pollutionAmount) {
        if (this.getBaseMetaTileEntity().getAirAtSide(this.getBaseMetaTileEntity().getFrontFacing())) {
            Pollution.addPollution(this.getBaseMetaTileEntity(), this.calculatePollutionReduction(pollutionAmount));
            return true;
        }
        return false;
    }
}

