/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API.recipe;

import com.gtnewhorizons.modularui.api.math.Alignment;
import gregtech.api.enums.GTValues;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.recipe.Sievert;
import gregtech.nei.GTNEIDefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BacterialVatFrontend
extends RecipeMapFrontend {
    public BacterialVatFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GTNEIDefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.input.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemInputTooltip(currentTip, pStack);
    }

    @Override
    protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GTNEIDefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isFluid()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"nei.biovat.output.tooltip"));
            return currentTip;
        }
        return super.handleNEIItemOutputTooltip(currentTip, pStack);
    }

    @Override
    protected void drawNEIOverlayForInput(GTNEIDefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    @Override
    protected void drawNEIOverlayForOutput(GTNEIDefaultHandler.FixedPositionedStack stack) {
        this.drawFluidOverlay(stack);
    }

    private void drawFluidOverlay(GTNEIDefaultHandler.FixedPositionedStack stack) {
        if (stack.isFluid()) {
            this.drawNEIOverlayText("+", stack, this.colorOverride.getTextColorOrDefault("nei_overlay_yellow", 16635957), 0.5f, true, Alignment.TopRight);
            return;
        }
        super.drawNEIOverlayForOutput(stack);
    }

    @Override
    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        long eut = recipeInfo.recipe.mEUt;
        long duration = recipeInfo.recipe.mDuration;
        int glassTier = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.GLASS, 3);
        Sievert data = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.SIEVERT, new Sievert(0, false));
        int sievert = data.sievert;
        boolean isExact = data.isExact;
        recipeInfo.drawText(StatCollector.func_74837_a((String)"GT5U.nei.display.total", (Object[])new Object[]{GTUtility.formatNumbers(eut * duration)}));
        recipeInfo.drawText(StatCollector.func_74837_a((String)"GT5U.nei.display.usage", (Object[])new Object[]{GTUtility.formatNumbers(eut), GTUtility.getTierNameWithParentheses(eut)}));
        recipeInfo.drawText(StatCollector.func_74837_a((String)"nei.biovat.0.name", (Object[])new Object[]{GTValues.VN[glassTier]}));
        if (sievert != 0) {
            if (!isExact) {
                recipeInfo.drawText(StatCollector.func_74837_a((String)"nei.biovat.1.name", (Object[])new Object[]{sievert}));
            } else {
                recipeInfo.drawText(StatCollector.func_74837_a((String)"nei.biovat.2.name", (Object[])new Object[]{sievert}));
            }
        }
    }
}

