/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.helpers;

import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;

public class CascadeDetectionHelper {
    private static final ThreadLocal<LinkedList<ChunkCoordIntPair>> arch$populatingChunk = ThreadLocal.withInitial(LinkedList::new);
    private static final LoadController controller = (LoadController)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"modController"});
    private static final ListMultimap<String, ModContainer> packageOwners = (ListMultimap)ReflectionHelper.getPrivateValue(LoadController.class, (Object)controller, (String[])new String[]{"packageOwners"});
    private static final MethodHandle callingStackGetter;

    private static Class<?>[] getCallingStack() {
        try {
            return callingStackGetter.invokeExact();
        }
        catch (Throwable e) {
            return new Class[0];
        }
    }

    private static ModContainer findModContainer() {
        for (Class<?> clz : CascadeDetectionHelper.getCallingStack()) {
            String pkg;
            List containers;
            int idx;
            if (clz.getName().startsWith("net.minecraft") || clz.getName().startsWith("org.embeddedt.archaicfix") || clz.getName().startsWith("cpw.mods.fml") || (idx = clz.getName().lastIndexOf(46)) == -1 || (containers = packageOwners.get((Object)(pkg = clz.getName().substring(0, idx)))) == null) continue;
            return (ModContainer)containers.get(0);
        }
        return null;
    }

    private static void logCascadingWorldGeneration(Chunk chunk, LinkedList<ChunkCoordIntPair> stack) {
        ModContainer activeModContainer = CascadeDetectionHelper.findModContainer();
        String format = "{} loaded a new chunk {} in dimension {} ({}) while populating chunk {}, causing cascading worldgen lag.";
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        if (activeModContainer == null) {
            ArchaicLogger.LOGGER.warn(format, new Object[]{"Minecraft", pos, chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76637_e.field_73011_w.func_80007_l(), stack.peek()});
        } else {
            ArchaicLogger.LOGGER.warn(format, new Object[]{activeModContainer.getName(), pos, chunk.field_76637_e.field_73011_w.field_76574_g, chunk.field_76637_e.field_73011_w.func_80007_l(), stack.peek()});
            ArchaicLogger.LOGGER.warn("Please report this to the mod's issue tracker. This log can be disabled in the ArchaicFix config.");
        }
        if (ArchaicConfig.logCascadingWorldgenStacktrace) {
            ArchaicLogger.LOGGER.warn("Stacktrace", (Throwable)new Exception("Cascading world generation"));
        }
    }

    public static void arch$populateWithCascadeDetection(Chunk chunk, Runnable runnable) {
        LinkedList<ChunkCoordIntPair> populationStack = arch$populatingChunk.get();
        if (populationStack.size() > 0 && ArchaicConfig.logCascadingWorldgen) {
            CascadeDetectionHelper.logCascadingWorldGeneration(chunk, populationStack);
        }
        populationStack.push(new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h));
        try {
            runnable.run();
        }
        finally {
            populationStack.pop();
        }
    }

    static {
        try {
            callingStackGetter = MethodHandles.publicLookup().unreflect(ReflectionHelper.findMethod(LoadController.class, (Object)controller, (String[])new String[]{"getCallingStack"}, (Class[])new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

