/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.DeepslateOreRegistry;
import ganymedes01.etfuturum.api.RawOreRegistry;
import ganymedes01.etfuturum.blocks.BaseSlab;
import ganymedes01.etfuturum.blocks.IDegradable;
import ganymedes01.etfuturum.blocks.ores.BaseDeepslateOre;
import ganymedes01.etfuturum.blocks.ores.BaseSubtypesDeepslateOre;
import ganymedes01.etfuturum.blocks.ores.modded.BlockGeneralModdedDeepslateOre;
import ganymedes01.etfuturum.blocks.rawore.modded.BlockGeneralModdedRawOre;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigExperiments;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.ItemNewBoat;
import ganymedes01.etfuturum.items.rawore.modded.ItemGeneralModdedRawOre;
import ganymedes01.etfuturum.lib.EnumColor;
import ganymedes01.etfuturum.recipes.crafting.RecipeAddPattern;
import ganymedes01.etfuturum.recipes.crafting.RecipeDuplicatePattern;
import ganymedes01.etfuturum.recipes.crafting.RecipeDyedShulkerBox;
import ganymedes01.etfuturum.recipes.crafting.RecipeFixedFireworks;
import ganymedes01.etfuturum.recipes.crafting.RecipeTippedArrow;
import ganymedes01.etfuturum.recipes.crafting.ShapedEtFuturumRecipe;
import ganymedes01.etfuturum.recipes.crafting.ShapelessEtFuturumRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModRecipes {
    public static final String[] ore_dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    public static final String[] dye_names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static final String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
    public static final String[] modernWoodTypes = new String[]{"crimson", "warped", "mangrove", "cherry"};
    private static final boolean[] modernWoodTypesEnabled = new boolean[5];

    public static void init() {
        if (ConfigBlocksItems.enableBanners) {
            RecipeSorter.register((String)"etfuturum.RecipeDuplicatePattern", RecipeDuplicatePattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            RecipeSorter.register((String)"etfuturum.RecipeAddPattern", RecipeAddPattern.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        }
        RecipeSorter.register((String)"etfuturum:shaped", ShapedEtFuturumRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"etfuturum:shapeless", ShapelessEtFuturumRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
        ModRecipes.modernWoodTypesEnabled[0] = ConfigExperiments.enableCrimsonBlocks;
        ModRecipes.modernWoodTypesEnabled[1] = ConfigExperiments.enableWarpedBlocks;
        ModRecipes.modernWoodTypesEnabled[2] = ConfigExperiments.enableMangroveBlocks;
        ModRecipes.modernWoodTypesEnabled[3] = ConfigBlocksItems.enableCherryBlocks;
        ModRecipes.modernWoodTypesEnabled[4] = ConfigBlocksItems.enableBambooBlocks;
        ModRecipes.registerOreDictionary();
        ModRecipes.registerRecipes();
        ModRecipes.tweakRecipes();
        ModRecipes.registerLoot();
    }

    private static void registerLoot() {
        if (ModItems.BEETROOT_SEEDS.isEnabled()) {
            ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.BEETROOT_SEEDS.newItemStack(), 1, 2, 5));
        }
    }

    private static void tweakRecipes() {
        if (ConfigBlocksItems.enableExtraVanillaSlabs && !ModsList.GTNH.isLoaded()) {
            ModRecipes.removeFirstRecipeFor((Block)Blocks.field_150333_U, 0);
        }
        if (ConfigBlocksItems.enableVanillaDoors) {
            Items.field_151135_aq.func_77625_d(64);
            Items.field_151139_aw.func_77625_d(64);
        }
        if (ConfigFunctions.enableDoorRecipeBuffs && !ModsList.GTNH.isLoaded()) {
            ModRecipes.removeFirstRecipeFor(Items.field_151135_aq);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151135_aq, 3), new Object[]{"xx", "xx", "xx", Character.valueOf('x'), "plankWood"}));
            ModRecipes.removeFirstRecipeFor(Items.field_151139_aw);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151139_aw, 3), new Object[]{"xx", "xx", "xx", Character.valueOf('x'), "ingotIron"}));
        }
        if (ConfigBlocksItems.enableVanillaFences && !ModsList.GTNH.isLoaded()) {
            ModRecipes.removeFirstRecipeFor(Blocks.field_150422_aJ);
            ModRecipes.removeFirstRecipeFor(Blocks.field_150386_bk);
        }
        if (ConfigBlocksItems.replaceOldBoats && ConfigBlocksItems.enableNewBoats) {
            if (!ModsList.GTNH.isLoaded()) {
                ModRecipes.removeFirstRecipeFor(Items.field_151124_az);
            }
            Items.field_151124_az.func_111206_d("oak_boat");
        }
        if (ConfigFunctions.enableExtraBurnableBlocks) {
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150396_be, 5, 20);
            Blocks.field_150480_ab.setFireInfo(Blocks.field_150422_aJ, 5, 20);
            Blocks.field_150480_ab.setFireInfo((Block)Blocks.field_150330_I, 60, 100);
        }
        if (ModItems.RABBIT_FOOT.isEnabled()) {
            PotionHelper.field_77927_l.put(Potion.field_76430_j.func_76396_c(), "0 & 1 & !2 & 3");
            PotionHelper.field_77928_m.put(Potion.field_76430_j.func_76396_c(), "5");
            Potion.field_76430_j.field_76414_N = 2293580;
        }
        if (ConfigFunctions.enableLangReplacements) {
            Blocks.field_150471_bO.func_149663_c(Utils.getUnlocalisedName("oak_button"));
            Blocks.field_150452_aw.func_149663_c(Utils.getUnlocalisedName("oak_pressure_plate"));
        }
        if (ConfigBlocksItems.replaceOldBoats) {
            Items.field_151124_az.func_77655_b(Utils.getUnlocalisedName("oak_boat"));
        }
        if (ConfigFunctions.fireworkRecipeFixes) {
            for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
                Object recipe = CraftingManager.func_77594_a().func_77592_b().get(i);
                if (recipe == null || recipe.getClass() != RecipeFireworks.class) continue;
                CraftingManager.func_77594_a().func_77592_b().remove(i);
                CraftingManager.func_77594_a().func_77592_b().add(i, new RecipeFixedFireworks());
                break;
            }
        }
    }

    private static void registerOreDictionary() {
        int i;
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)Blocks.field_150486_ae));
        OreDictionary.registerOre((String)"bookshelfWood", (ItemStack)new ItemStack(Blocks.field_150342_X));
        OreDictionary.registerOre((String)"doorWood", (ItemStack)new ItemStack(Items.field_151135_aq));
        OreDictionary.registerOre((String)"trapdoorWood", (Block)Blocks.field_150415_aT);
        OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack(Blocks.field_150422_aJ));
        OreDictionary.registerOre((String)"fenceGateWood", (ItemStack)new ItemStack(Blocks.field_150396_be));
        OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(Blocks.field_150471_bO));
        OreDictionary.registerOre((String)"pressurePlateWood", (ItemStack)new ItemStack(Blocks.field_150452_aw));
        OreDictionary.registerOre((String)"bedWood", (ItemStack)new ItemStack(Items.field_151104_aV));
        OreDictionary.registerOre((String)"doorIron", (ItemStack)new ItemStack(Items.field_151139_aw));
        OreDictionary.registerOre((String)"buttonStone", (ItemStack)new ItemStack(Blocks.field_150430_aB));
        OreDictionary.registerOre((String)"pressurePlateStone", (ItemStack)new ItemStack(Blocks.field_150456_au));
        OreDictionary.registerOre((String)"pressurePlateIron", (ItemStack)new ItemStack(Blocks.field_150443_bT));
        OreDictionary.registerOre((String)"pressurePlateGold", (ItemStack)new ItemStack(Blocks.field_150445_bS));
        OreDictionary.registerOre((String)"bowlWood", (ItemStack)new ItemStack(Items.field_151054_z));
        OreDictionary.registerOre((String)"soulSand", (Block)Blocks.field_150425_aM);
        for (ModBlocks bed : ModBlocks.BEDS) {
            ModRecipes.registerOre("bedWood", bed.get());
        }
        ModRecipes.registerOre("treeLeaves", ModBlocks.LEAVES.newItemStack(1, Short.MAX_VALUE));
        ModRecipes.registerOre("treeLeaves", ModBlocks.AZALEA_LEAVES.newItemStack(1, Short.MAX_VALUE));
        ModRecipes.registerOre("treeSapling", ModBlocks.AZALEA.newItemStack(1, Short.MAX_VALUE));
        ModRecipes.registerOre("soulSoil", ModBlocks.SOUL_SOIL.get());
        ModRecipes.registerOre("nuggetIron", ModItems.NUGGET_IRON.get());
        ModRecipes.registerOre("foodMuttonraw", ModItems.MUTTON_RAW.get());
        ModRecipes.registerOre("listAllmeatraw", ModItems.MUTTON_RAW.get());
        ModRecipes.registerOre("listAllmuttonraw", ModItems.MUTTON_RAW.get());
        ModRecipes.registerOre("foodMuttoncooked", ModItems.MUTTON_COOKED.get());
        ModRecipes.registerOre("listAllmeatcooked", ModItems.MUTTON_COOKED.get());
        ModRecipes.registerOre("listAllmuttoncooked", ModItems.MUTTON_COOKED.get());
        ModRecipes.registerOre("shardPrismarine", ModItems.PRISMARINE_SHARD.get());
        ModRecipes.registerOre("crystalPrismarine", ModItems.PRISMARINE_CRYSTALS.get());
        ModRecipes.registerOre("blockPrismarine", ModBlocks.PRISMARINE_BLOCK.newItemStack(1, Short.MAX_VALUE));
        for (ModBlocks door : ModBlocks.DOORS) {
            ModRecipes.registerOre("doorWood", door.get());
        }
        for (ModBlocks trapdoor : ModBlocks.TRAPDOORS) {
            ModRecipes.registerOre("trapdoorWood", trapdoor.get());
        }
        for (ModBlocks fence : ModBlocks.FENCES) {
            ModRecipes.registerOre("fenceWood", fence.get());
        }
        for (ModBlocks fenceGate : ModBlocks.FENCE_GATES) {
            ModRecipes.registerOre("fenceGateWood", fenceGate.get());
        }
        for (ModBlocks button : ModBlocks.BUTTONS) {
            ModRecipes.registerOre("buttonWood", button.get());
        }
        for (ModBlocks pressurePlate : ModBlocks.PRESSURE_PLATES) {
            ModRecipes.registerOre("pressurePlateWood", pressurePlate.get());
        }
        ModRecipes.registerOre("signWood", Items.field_151155_ap);
        ModRecipes.registerOre("signWood", ModItems.ITEM_SIGN_SPRUCE.get());
        ModRecipes.registerOre("signWood", ModItems.ITEM_SIGN_BIRCH.get());
        ModRecipes.registerOre("signWood", ModItems.ITEM_SIGN_JUNGLE.get());
        ModRecipes.registerOre("signWood", ModItems.ITEM_SIGN_ACACIA.get());
        ModRecipes.registerOre("signWood", ModItems.ITEM_SIGN_DARK_OAK.get());
        ModRecipes.registerOre("signWood", ModBlocks.CRIMSON_SIGN.get());
        ModRecipes.registerOre("signWood", ModBlocks.WARPED_SIGN.get());
        ModRecipes.registerOre("signWood", ModBlocks.MANGROVE_SIGN.get());
        ModRecipes.registerOre("signWood", ModBlocks.CHERRY_SIGN.get());
        ModRecipes.registerOre("signWood", ModBlocks.BAMBOO_SIGN.get());
        if (ConfigExperiments.enableMangroveBlocks) {
            ModRecipes.registerOre("treeSapling", ModBlocks.SAPLING.newItemStack(1, 0));
        }
        if (ConfigBlocksItems.enableCherryBlocks) {
            ModRecipes.registerOre("treeSapling", ModBlocks.SAPLING.newItemStack(1, 1));
        }
        for (i = 0; i < modernWoodTypesEnabled.length; ++i) {
            if (!modernWoodTypesEnabled[i]) continue;
            ModRecipes.registerOre("plankWood", ModBlocks.WOOD_PLANKS.newItemStack(1, i));
            ModRecipes.registerOre("slabWood", ModBlocks.WOOD_SLAB.newItemStack(1, i));
            ModRecipes.registerOre("fenceWood", ModBlocks.WOOD_FENCE.newItemStack(1, i));
        }
        ModRecipes.registerOre("stairWood", ModBlocks.CRIMSON_STAIRS.get());
        ModRecipes.registerOre("stairWood", ModBlocks.WARPED_STAIRS.get());
        ModRecipes.registerOre("stairWood", ModBlocks.MANGROVE_STAIRS.get());
        ModRecipes.registerOre("stairWood", ModBlocks.CHERRY_STAIRS.get());
        ModRecipes.registerOre("stairWood", ModBlocks.BAMBOO_STAIRS.get());
        for (i = 0; i < 4; ++i) {
            ModRecipes.registerOre("logWood", ModBlocks.LOG_STRIPPED.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.LOG2_STRIPPED.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.WOOD_STRIPPED.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.WOOD2_STRIPPED.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.BARK.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.BARK2.newItemStack(1, i));
            if (!(i == 0 || i == 1 && ConfigBlocksItems.enableStrippedLogs || i == 2 && ConfigBlocksItems.enableBarkLogs) && (i != 3 || !ConfigBlocksItems.enableStrippedLogs || !ConfigBlocksItems.enableBarkLogs)) continue;
            ModRecipes.registerOre("logWood", ModBlocks.CRIMSON_STEM.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.WARPED_STEM.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.MANGROVE_LOG.newItemStack(1, i));
            ModRecipes.registerOre("logWood", ModBlocks.CHERRY_LOG.newItemStack(1, i));
        }
        ModRecipes.registerOre("stoneGranite", ModBlocks.STONE.newItemStack(1, 1));
        ModRecipes.registerOre("stoneDiorite", ModBlocks.STONE.newItemStack(1, 3));
        ModRecipes.registerOre("stoneAndesite", ModBlocks.STONE.newItemStack(1, 5));
        ModRecipes.registerOre("stoneGranitePolished", ModBlocks.STONE.newItemStack(1, 2));
        ModRecipes.registerOre("stoneDioritePolished", ModBlocks.STONE.newItemStack(1, 4));
        ModRecipes.registerOre("stoneAndesitePolished", ModBlocks.STONE.newItemStack(1, 6));
        ModRecipes.registerOre("blockSlime", ModBlocks.SLIME.newItemStack());
        ModRecipes.registerOre("trapdoorIron", ModBlocks.IRON_TRAPDOOR.get());
        ModRecipes.registerOre("cropBeetroot", ModItems.BEETROOT.get());
        ModRecipes.registerOre("listAllseed", ModItems.BEETROOT_SEEDS.get());
        ModRecipes.registerOre("seedBeetroot", ModItems.BEETROOT_SEEDS.get());
        ModRecipes.registerOre("foodRabbitraw", ModItems.RABBIT_RAW.newItemStack());
        ModRecipes.registerOre("listAllmeatraw", ModItems.RABBIT_RAW.newItemStack());
        ModRecipes.registerOre("listAllrabbitraw", ModItems.RABBIT_RAW.newItemStack());
        ModRecipes.registerOre("foodRabbitcooked", ModItems.RABBIT_COOKED.newItemStack());
        ModRecipes.registerOre("listAllmeatcooked", ModItems.RABBIT_COOKED.newItemStack());
        ModRecipes.registerOre("listAllrabbitcooked", ModItems.RABBIT_COOKED.newItemStack());
        ModRecipes.registerOre("brickEndStone", ModBlocks.END_BRICKS.get());
        ModRecipes.registerOre("ingotNetherite", ModItems.NETHERITE_INGOT.get());
        ModRecipes.registerOre("scrapDebris", ModItems.NETHERITE_SCRAP.get());
        ModRecipes.registerOre("oreDebris", ModBlocks.ANCIENT_DEBRIS.get());
        ModRecipes.registerOre("blockNetherite", ModBlocks.NETHERITE_BLOCK.get());
        ModRecipes.registerOre("dye", ModItems.DYE.newItemStack(1, Short.MAX_VALUE));
        ModRecipes.registerOre("dyeWhite", ModItems.DYE.newItemStack());
        ModRecipes.registerOre("dyeBlue", ModItems.DYE.newItemStack(1, 1));
        ModRecipes.registerOre("dyeBrown", ModItems.DYE.newItemStack(1, 2));
        ModRecipes.registerOre("dyeBlack", ModItems.DYE.newItemStack(1, 3));
        ModRecipes.registerOre("oreCopper", ModBlocks.COPPER_ORE.newItemStack());
        ModRecipes.registerOre("ingotCopper", ModItems.COPPER_INGOT.newItemStack());
        ModRecipes.registerOre("blockCopper", ModBlocks.COPPER_BLOCK.newItemStack());
        ModRecipes.registerOre("blockCopperCut", ModBlocks.COPPER_BLOCK.newItemStack(1, 4));
        ModRecipes.registerOre("cobblestone", ModBlocks.COBBLED_DEEPSLATE.newItemStack());
        ModRecipes.registerOre("record", ModItems.PIGSTEP_RECORD.get());
        ModRecipes.registerOre("record", ModItems.OTHERSIDE_RECORD.get());
        ModRecipes.registerOre("gemAmethyst", ModItems.AMETHYST_SHARD.get());
        ModRecipes.registerOre("blockGlassTinted", ModBlocks.TINTED_GLASS.newItemStack());
        ModRecipes.registerOre("cobblestone", ModBlocks.BLACKSTONE.get());
        ModRecipes.registerOre("buttonStone", ModBlocks.POLISHED_BLACKSTONE_BUTTON.get());
        ModRecipes.registerOre("pressurePlateStone", ModBlocks.POLISHED_BLACKSTONE_PRESSURE_PLATE.get());
        for (Map.Entry<String, ItemNewBoat.BoatInfo> entry : ItemNewBoat.BOAT_INFO.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            if (key.endsWith("_chest")) {
                ModRecipes.registerOre("boatChestWood", entry.getValue().getBoatItem());
                continue;
            }
            ModRecipes.registerOre("boatWood", entry.getValue().getBoatItem());
        }
        for (String waxString : IDegradable.waxStrings) {
            ModRecipes.registerOre(waxString, ModItems.HONEYCOMB.get());
        }
        if (ConfigBlocksItems.enableColourfulBeacons && ModsList.TINKERS_CONSTRUCT.isLoaded()) {
            Block glassBlock = GameRegistry.findBlock((String)"TConstruct", (String)"GlassBlock.StainedClear");
            Block glassPane = GameRegistry.findBlock((String)"TConstruct", (String)"GlassPaneClearStained");
            OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(glassBlock, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"paneGlass", (ItemStack)new ItemStack(glassPane, 1, Short.MAX_VALUE));
            for (int i2 = 0; i2 < ore_dyes.length; ++i2) {
                String capitalizedColor = ore_dyes[15 - i2].substring(3);
                OreDictionary.registerOre((String)("blockGlass" + capitalizedColor), (ItemStack)new ItemStack(glassBlock, 1, i2));
                OreDictionary.registerOre((String)("paneGlass" + capitalizedColor), (ItemStack)new ItemStack(glassPane, 1, i2));
            }
        }
        ModRecipes.registerOre("rawCopper", ModItems.RAW_ORE.newItemStack());
        ModRecipes.registerOre("blockRawCopper", ModBlocks.RAW_ORE_BLOCK.newItemStack());
        ModRecipes.registerOre("rawIron", ModItems.RAW_ORE.newItemStack(1, 1));
        ModRecipes.registerOre("blockRawIron", ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 1));
        ModRecipes.registerOre("rawGold", ModItems.RAW_ORE.newItemStack(1, 2));
        ModRecipes.registerOre("blockRawGold", ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 2));
        if (ConfigFunctions.registerRawItemAsOre) {
            ModRecipes.registerOre("oreCopper", ModItems.RAW_ORE.newItemStack());
            ModRecipes.registerOre("oreIron", ModItems.RAW_ORE.newItemStack(1, 1));
            ModRecipes.registerOre("oreGold", ModItems.RAW_ORE.newItemStack(1, 2));
        }
    }

    private static void registerRecipes() {
        int i;
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.OLD_GRAVEL.newItemStack(4), "xy", "yx", Character.valueOf('x'), ModBlocks.COARSE_DIRT.get(), Character.valueOf('y'), Blocks.field_150351_n);
        }
        if (ConfigFunctions.enableStoneBrickRecipes && !ModsList.GTNH.isLoaded()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150341_Y), (Object[])new Object[]{new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150395_bd)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 1), (Object[])new Object[]{new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150395_bd)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 3), (Object[])new Object[]{"x", "x", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150333_U, 1, 5)});
            GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150417_aV), (ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 2), (float)0.0f);
        }
        if (!ModsList.GTNH.isLoaded()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150341_Y), (Object[])new Object[]{new ItemStack(Blocks.field_150347_e), ModBlocks.MOSS_BLOCK.newItemStack()});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150417_aV, 1, 1), (Object[])new Object[]{new ItemStack(Blocks.field_150417_aV), ModBlocks.MOSS_BLOCK.newItemStack()});
        }
        if (ConfigFunctions.enableRecipeForTotem) {
            ModRecipes.addShapedRecipe(ModItems.TOTEM_OF_UNDYING.newItemStack(), "EBE", "GBG", " G ", Character.valueOf('E'), "gemEmerald", Character.valueOf('G'), "ingotGold", Character.valueOf('B'), "blockGold");
        }
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.SLIME.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151123_aH));
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151123_aH, 9), ModBlocks.SLIME.get());
            ModRecipes.addShapedRecipe(ModBlocks.COARSE_DIRT.newItemStack(4), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150346_d), Character.valueOf('y'), new ItemStack(Blocks.field_150351_n));
        }
        ModRecipes.addSmelting(ModItems.MUTTON_RAW.get(), ModItems.MUTTON_COOKED.newItemStack(), 0.35f);
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(new ItemStack(Items.field_151042_j), "xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron");
            ModRecipes.addShapelessRecipe(ModItems.NUGGET_IRON.newItemStack(9), "ingotIron");
        }
        ModRecipes.addShapelessRecipe(ModBlocks.STONE.newItemStack(2, 1), "gemQuartz", "stoneDiorite");
        ModRecipes.addShapedRecipe(ModBlocks.STONE.newItemStack(4, 2), "xx", "xx", Character.valueOf('x'), "stoneGranite");
        ModRecipes.addShapedRecipe(ModBlocks.STONE.newItemStack(2, 3), "xy", "yx", Character.valueOf('x'), new ItemStack(Blocks.field_150347_e), Character.valueOf('y'), "gemQuartz");
        ModRecipes.addShapedRecipe(ModBlocks.STONE.newItemStack(4, 4), "xx", "xx", Character.valueOf('x'), "stoneDiorite");
        ModRecipes.addShapelessRecipe(ModBlocks.STONE.newItemStack(2, 5), new ItemStack(Blocks.field_150347_e), "stoneDiorite");
        ModRecipes.addShapedRecipe(ModBlocks.STONE.newItemStack(4, 6), "xx", "xx", Character.valueOf('x'), "stoneAndesite");
        Block[] stone_stairs = new Block[]{ModBlocks.GRANITE_STAIRS.get(), ModBlocks.POLISHED_GRANITE_STAIRS.get(), ModBlocks.DIORITE_STAIRS.get(), ModBlocks.POLISHED_DIORITE_STAIRS.get(), ModBlocks.ANDESITE_STAIRS.get(), ModBlocks.POLISHED_ANDESITE_STAIRS.get()};
        for (i = 0; i < stone_stairs.length; ++i) {
            String dictName = "stone" + StringUtils.capitalize((String)((BaseSlab)ModBlocks.STONE_SLAB_2.get()).types[i / 2 * 2]) + (i % 2 == 1 ? "Polished" : "");
            if (!ModsList.GTNH.isLoaded()) {
                ModRecipes.addShapedRecipe(ModBlocks.STONE_SLAB_2.newItemStack(6, i), "xxx", Character.valueOf('x'), dictName);
            }
            ModRecipes.addShapedRecipe(new ItemStack(stone_stairs[i], 4), "x  ", "xx ", "xxx", Character.valueOf('x'), dictName);
            if (i % 2 != 1) continue;
            ModRecipes.addShapedRecipe(ModBlocks.STONE_WALL_2.newItemStack(6, i == 5 ? 2 : (i == 3 ? 1 : 0)), "xxx", "xxx", Character.valueOf('x'), ModBlocks.STONE.newItemStack(1, i));
        }
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_BLOCK.newItemStack(), "xx", "xx", Character.valueOf('x'), "shardPrismarine");
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_BLOCK.newItemStack(1, 1), "xxx", "xxx", "xxx", Character.valueOf('x'), "shardPrismarine");
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_BLOCK.newItemStack(1, 2), "xxx", "xyx", "xxx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "dyeBlack");
        ModRecipes.addShapedRecipe(ModBlocks.SEA_LANTERN.newItemStack(), "xyx", "yyy", "xyx", Character.valueOf('x'), "shardPrismarine", Character.valueOf('y'), "crystalPrismarine");
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.PRISMARINE_BLOCK.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_STAIRS_BRICK.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.PRISMARINE_BLOCK.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_STAIRS_DARK.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.PRISMARINE_BLOCK.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.PRISMARINE_BLOCK.newItemStack());
        for (i = 0; i < 3; ++i) {
            ModRecipes.addShapedRecipe(ModBlocks.PRISMARINE_SLAB.newItemStack(6, i), "xxx", Character.valueOf('x'), ModBlocks.PRISMARINE_BLOCK.newItemStack(1, i));
        }
        if (!ModsList.BOTANIA.isLoaded()) {
            ModRecipes.addShapedRecipe(ModItems.PRISMARINE_SHARD.newItemStack(4), "xy", "zx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dyeBlue", Character.valueOf('z'), "dyeGreen");
            ModRecipes.addShapedRecipe(ModItems.PRISMARINE_CRYSTALS.newItemStack(4), "xy", "yx", Character.valueOf('x'), "gemQuartz", Character.valueOf('y'), "dustGlowstone");
        }
        if (!ModsList.GTNH.isLoaded()) {
            Block[] metaBlocks = new Block[]{Blocks.field_150348_b, Blocks.field_150341_Y, Blocks.field_150417_aV, Blocks.field_150322_A};
            for (int i2 = 0; i2 < metaBlocks.length; ++i2) {
                ModRecipes.addShapedRecipe(ModBlocks.STONE_SLAB.newItemStack(6, i2), "xxx", Character.valueOf('x'), new ItemStack(metaBlocks[i2], 1, i2 != 0 ? i2 - 1 : i2));
            }
            ModRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150333_U, 6, 0), "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_STONE.newItemStack());
        }
        ModRecipes.addShapedRecipe(ModBlocks.STONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150348_b, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.MOSSY_COBBLESTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150341_Y, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.MOSSY_STONE_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150417_aV, 1, 1));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4), "x", Character.valueOf('x'), ModBlocks.BARK.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 1), "x", Character.valueOf('x'), ModBlocks.BARK.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 2), "x", Character.valueOf('x'), ModBlocks.BARK.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 3), "x", Character.valueOf('x'), ModBlocks.BARK.newItemStack(1, 3));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 4), "x", Character.valueOf('x'), ModBlocks.BARK2.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 5), "x", Character.valueOf('x'), ModBlocks.BARK2.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4), "x", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 1), "x", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 2), "x", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 3), "x", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 3));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 4), "x", Character.valueOf('x'), ModBlocks.LOG2_STRIPPED.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 5), "x", Character.valueOf('x'), ModBlocks.LOG2_STRIPPED.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4), "x", Character.valueOf('x'), ModBlocks.WOOD_STRIPPED.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 1), "x", Character.valueOf('x'), ModBlocks.WOOD_STRIPPED.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 2), "x", Character.valueOf('x'), ModBlocks.WOOD_STRIPPED.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 3), "x", Character.valueOf('x'), ModBlocks.WOOD_STRIPPED.newItemStack(1, 3));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 4), "x", Character.valueOf('x'), ModBlocks.WOOD2_STRIPPED.newItemStack(1));
            ModRecipes.addShapedRecipe(new ItemStack(Blocks.field_150344_f, 4, 5), "x", Character.valueOf('x'), ModBlocks.WOOD2_STRIPPED.newItemStack(1, 1));
            for (int i3 = 0; i3 < 4; ++i3) {
                ModRecipes.addSmelting(ModBlocks.LOG_STRIPPED.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.LOG2_STRIPPED.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.WOOD_STRIPPED.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.WOOD2_STRIPPED.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.BARK.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.BARK2.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.MANGROVE_LOG.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
                ModRecipes.addSmelting(ModBlocks.CHERRY_LOG.newItemStack(1, i3), new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
            }
        }
        ModRecipes.addShapedRecipe(ModBlocks.BARK.newItemStack(3), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150364_r, 1));
        ModRecipes.addShapedRecipe(ModBlocks.BARK.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150364_r, 1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.BARK.newItemStack(3, 2), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150364_r, 1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.BARK.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150364_r, 1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.BARK2.newItemStack(3), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150363_s, 1));
        ModRecipes.addShapedRecipe(ModBlocks.BARK2.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150363_s, 1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD_STRIPPED.newItemStack(3), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD_STRIPPED.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD_STRIPPED.newItemStack(3, 2), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD_STRIPPED.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG_STRIPPED.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD2_STRIPPED.newItemStack(3), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG2_STRIPPED.newItemStack(1));
        ModRecipes.addShapedRecipe(ModBlocks.WOOD2_STRIPPED.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.LOG2_STRIPPED.newItemStack(1, 1));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.WOOD_PLANKS.newItemStack(4), "x", Character.valueOf('x'), ModBlocks.CRIMSON_STEM.newItemStack(1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(ModBlocks.WOOD_PLANKS.newItemStack(4, 1), "x", Character.valueOf('x'), ModBlocks.WARPED_STEM.newItemStack(1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(ModBlocks.WOOD_PLANKS.newItemStack(4, 2), "x", Character.valueOf('x'), ModBlocks.MANGROVE_LOG.newItemStack(1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(ModBlocks.WOOD_PLANKS.newItemStack(4, 3), "x", Character.valueOf('x'), ModBlocks.CHERRY_LOG.newItemStack(1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(ModBlocks.WOOD_PLANKS.newItemStack(2, 4), "x", Character.valueOf('x'), ModBlocks.BAMBOO_BLOCK.newItemStack(1, Short.MAX_VALUE));
        }
        if (ConfigBlocksItems.enableStrippedLogs && ConfigBlocksItems.enableBarkLogs) {
            ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_STEM.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), ModBlocks.CRIMSON_STEM.newItemStack(2, 2));
            ModRecipes.addShapedRecipe(ModBlocks.WARPED_STEM.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), ModBlocks.WARPED_STEM.newItemStack(2, 2));
            ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_LOG.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), ModBlocks.MANGROVE_LOG.newItemStack(2, 2));
            ModRecipes.addShapedRecipe(ModBlocks.CHERRY_LOG.newItemStack(3, 3), "xx", "xx", Character.valueOf('x'), ModBlocks.CHERRY_LOG.newItemStack(2, 2));
        }
        if (ConfigBlocksItems.enableBarkLogs) {
            ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_STEM.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.CRIMSON_STEM.newItemStack(1));
            ModRecipes.addShapedRecipe(ModBlocks.WARPED_STEM.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.WARPED_STEM.newItemStack(1));
            ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_LOG.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.MANGROVE_LOG.newItemStack(1));
            ModRecipes.addShapedRecipe(ModBlocks.CHERRY_LOG.newItemStack(3, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.CHERRY_LOG.newItemStack(1));
        }
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.FENCE_SPRUCE.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.FENCE_BIRCH.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.FENCE_JUNGLE.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.FENCE_ACACIA.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.FENCE_DARK_OAK.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('y'), "stickWood");
            if (ConfigExperiments.enableCrimsonBlocks) {
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_FENCE.newItemStack(3), "xyx", "xyx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1), Character.valueOf('y'), "stickWood");
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_SLAB.newItemStack(6, 0), "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 0));
            }
            if (ConfigExperiments.enableWarpedBlocks) {
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_FENCE.newItemStack(3, 1), "xyx", "xyx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1), Character.valueOf('y'), "stickWood");
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
            }
            if (ConfigExperiments.enableMangroveBlocks) {
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_FENCE.newItemStack(3, 2), "xyx", "xyx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2), Character.valueOf('y'), "stickWood");
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_SLAB.newItemStack(6, 2), "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
            }
            if (ConfigBlocksItems.enableCherryBlocks) {
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_FENCE.newItemStack(3, 3), "xyx", "xyx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3), Character.valueOf('y'), "stickWood");
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_SLAB.newItemStack(6, 3), "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
            }
            if (ConfigBlocksItems.enableBambooBlocks) {
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_FENCE.newItemStack(3, 4), "xyx", "xyx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4), Character.valueOf('y'), "stickWood");
                ModRecipes.addShapedRecipe(ModBlocks.WOOD_SLAB.newItemStack(6, 4), "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
            }
        }
        ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.WARPED_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.CHERRY_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_BLOCK.newItemStack(), "bbb", "bbb", "bbb", Character.valueOf('b'), ModItems.BAMBOO.newItemStack());
        ModRecipes.addShapedRecipe(new ItemStack(Items.field_151055_y), "b", "b", Character.valueOf('b'), ModItems.BAMBOO.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_MOSAIC.newItemStack(1, 0), "x", "x", Character.valueOf('x'), ModBlocks.WOOD_SLAB.newItemStack(1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_MOSAIC_SLAB.newItemStack(6, 5), "xxx", Character.valueOf('x'), ModBlocks.BAMBOO_MOSAIC.newItemStack(1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_MOSAIC_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.BAMBOO_MOSAIC.newItemStack(1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.FENCE_GATE_SPRUCE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.FENCE_GATE_BIRCH.newItemStack(), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.FENCE_GATE_JUNGLE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.FENCE_GATE_ACACIA.newItemStack(), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.FENCE_GATE_DARK_OAK.newItemStack(), "yxy", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_FENCE_GATE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.WARPED_FENCE_GATE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_FENCE_GATE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.CHERRY_FENCE_GATE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3), Character.valueOf('y'), "stickWood");
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_FENCE_GATE.newItemStack(), "yxy", "yxy", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4), Character.valueOf('y'), "stickWood");
        int output = ConfigFunctions.enableDoorRecipeBuffs ? 3 : 1;
        ModRecipes.addShapedRecipe(ModBlocks.DOOR_SPRUCE.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.DOOR_BIRCH.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.DOOR_JUNGLE.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.DOOR_ACACIA.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.DOOR_DARK_OAK.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5));
        ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_DOOR.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1));
        ModRecipes.addShapedRecipe(ModBlocks.WARPED_DOOR.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_DOOR.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.CHERRY_DOOR.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_DOOR.newItemStack(output), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.TRAPDOOR_SPRUCE.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.TRAPDOOR_BIRCH.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.TRAPDOOR_JUNGLE.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.TRAPDOOR_ACACIA.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.TRAPDOOR_DARK_OAK.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5));
        ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_TRAPDOOR.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1));
        ModRecipes.addShapedRecipe(ModBlocks.WARPED_TRAPDOOR.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_TRAPDOOR.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.CHERRY_TRAPDOOR.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_TRAPDOOR.newItemStack(2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.IRON_TRAPDOOR.newItemStack(), "xx", "xx", Character.valueOf('x'), "ingotIron");
            ModRecipes.addShapedRecipe(ModBlocks.BUTTON_SPRUCE.newItemStack(), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.BUTTON_BIRCH.newItemStack(), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2));
            ModRecipes.addShapedRecipe(ModBlocks.BUTTON_JUNGLE.newItemStack(), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3));
            ModRecipes.addShapedRecipe(ModBlocks.BUTTON_ACACIA.newItemStack(), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4));
            ModRecipes.addShapedRecipe(ModBlocks.BUTTON_DARK_OAK.newItemStack(), "x", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5));
            ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_BUTTON.newItemStack(), "x", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1));
            ModRecipes.addShapedRecipe(ModBlocks.WARPED_BUTTON.newItemStack(), "x", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_BUTTON.newItemStack(), "x", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(ModBlocks.CHERRY_BUTTON.newItemStack(), "x", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
            ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_BUTTON.newItemStack(), "x", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
            ModRecipes.addShapedRecipe(ModBlocks.PRESSURE_PLATE_SPRUCE.newItemStack(), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.PRESSURE_PLATE_BIRCH.newItemStack(), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2));
            ModRecipes.addShapedRecipe(ModBlocks.PRESSURE_PLATE_JUNGLE.newItemStack(), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3));
            ModRecipes.addShapedRecipe(ModBlocks.PRESSURE_PLATE_ACACIA.newItemStack(), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4));
            ModRecipes.addShapedRecipe(ModBlocks.PRESSURE_PLATE_DARK_OAK.newItemStack(), "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5));
            ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_PRESSURE_PLATE.newItemStack(), "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1));
            ModRecipes.addShapedRecipe(ModBlocks.WARPED_PRESSURE_PLATE.newItemStack(), "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_PRESSURE_PLATE.newItemStack(), "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(ModBlocks.CHERRY_PRESSURE_PLATE.newItemStack(), "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3));
            ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_PRESSURE_PLATE.newItemStack(), "xx", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4));
            ModRecipes.addShapedRecipe(ModItems.ITEM_SIGN_SPRUCE.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModItems.ITEM_SIGN_BIRCH.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModItems.ITEM_SIGN_JUNGLE.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModItems.ITEM_SIGN_ACACIA.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModItems.ITEM_SIGN_DARK_OAK.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.CRIMSON_SIGN.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.WARPED_SIGN.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 1), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.MANGROVE_SIGN.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 2), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.CHERRY_SIGN.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 3), Character.valueOf('y'), "stickWood");
            ModRecipes.addShapedRecipe(ModBlocks.BAMBOO_SIGN.newItemStack(3), "xxx", "xxx", " y ", Character.valueOf('x'), ModBlocks.WOOD_PLANKS.newItemStack(1, 4), Character.valueOf('y'), "stickWood");
        }
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE.newItemStack(), "xx", "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150354_m, 1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.RED_SANDSTONE.newItemStack(1, 2));
            ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.RED_SANDSTONE.newItemStack(1, Short.MAX_VALUE));
        }
        ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE.newItemStack(1, 1), "x", "x", Character.valueOf('x'), ModBlocks.RED_SANDSTONE_SLAB.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE.newItemStack(4, 2), "xx", "xx", Character.valueOf('x'), ModBlocks.RED_SANDSTONE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.RED_SANDSTONE.get());
        ModRecipes.addShapedRecipe(ModBlocks.RED_SANDSTONE_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.RED_SANDSTONE.newItemStack());
        if (ConfigBlocksItems.enableVanillaFences && !ModsList.GTNH.isLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150422_aJ, 3), new Object[]{"xyx", "xyx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150386_bk, 6), new Object[]{"xyx", "xyx", Character.valueOf('x'), Blocks.field_150385_bj, Character.valueOf('y'), "ingotBrickNether"}));
        }
        for (EnumColor colour : EnumColor.VALUES) {
            ModRecipes.addShapedRecipe(ModBlocks.BANNER.newItemStack(1, colour.getDamage()), "xxx", "xxx", " y ", Character.valueOf('x'), new ItemStack(Blocks.field_150325_L, 1, colour.getDamage()), Character.valueOf('y'), "stickWood");
        }
        GameRegistry.addRecipe((IRecipe)new RecipeDuplicatePattern());
        GameRegistry.addRecipe((IRecipe)new RecipeAddPattern());
        ModRecipes.addShapedRecipe(ModItems.WOODEN_ARMORSTAND.newItemStack(), "xxx", " x ", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack((Block)Blocks.field_150333_U));
        ModRecipes.addShapedRecipe(ModItems.RABBIT_STEW.newItemStack(), " R ", "CPM", " B ", Character.valueOf('R'), ModItems.RABBIT_COOKED.newItemStack(), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('M'), Blocks.field_150338_P, Character.valueOf('B'), "bowlWood");
        ModRecipes.addShapedRecipe(ModItems.RABBIT_STEW.newItemStack(), " R ", "CPD", " B ", Character.valueOf('R'), ModItems.RABBIT_COOKED.newItemStack(), Character.valueOf('C'), Items.field_151172_bF, Character.valueOf('P'), Items.field_151168_bH, Character.valueOf('D'), Blocks.field_150337_Q, Character.valueOf('B'), "bowlWood");
        ModRecipes.addSmelting(ModItems.RABBIT_RAW.get(), ModItems.RABBIT_COOKED.newItemStack(), 0.35f);
        ModRecipes.addShapedRecipe(new ItemStack(Items.field_151116_aA), "xx", "xx", Character.valueOf('x'), ModItems.RABBIT_HIDE.get());
        ModRecipes.addSmelting(ModBlocks.SPONGE.newItemStack(1, 1), ConfigWorld.tileReplacementMode == -1 ? ModBlocks.SPONGE.newItemStack() : new ItemStack(Blocks.field_150360_v), 0.15f);
        ModRecipes.addShapedRecipe(ModItems.BEETROOT_SOUP.newItemStack(), "xxx", "xxx", " y ", Character.valueOf('x'), "cropBeetroot", Character.valueOf('y'), "bowlWood");
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 1, 1), new Object[]{"cropBeetroot"}));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.END_BRICK_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.END_BRICKS.get());
        }
        ModRecipes.addShapedRecipe(ModBlocks.END_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.END_BRICKS.get());
        ModRecipes.addShapedRecipe(ModBlocks.END_BRICK_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.END_BRICKS.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.PURPUR_BLOCK.newItemStack(4), "xx", "xx", Character.valueOf('x'), ModItems.CHORUS_FRUIT_POPPED.get());
        ModRecipes.addShapedRecipe(ModBlocks.PURPUR_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.PURPUR_BLOCK.get());
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.PURPUR_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.PURPUR_BLOCK.get());
        }
        ModRecipes.addShapedRecipe(ModBlocks.PURPUR_PILLAR.newItemStack(), "x", "x", Character.valueOf('x'), ModBlocks.PURPUR_SLAB.get());
        ModRecipes.addShapedRecipe(ModBlocks.END_BRICKS.newItemStack(4), "xx", "xx", Character.valueOf('x'), Blocks.field_150377_bs);
        ModRecipes.addSmelting(ModItems.CHORUS_FRUIT.newItemStack(), ModItems.CHORUS_FRUIT_POPPED.newItemStack(), 0.0f);
        ModRecipes.addShapedRecipe(ModBlocks.END_ROD.newItemStack(), "x", "y", Character.valueOf('x'), Items.field_151072_bj, Character.valueOf('y'), ModItems.CHORUS_FRUIT_POPPED.get());
        ModRecipes.addShapelessRecipe(ModItems.DRAGON_BREATH.newItemStack(), new ItemStack((Item)Items.field_151068_bn, 1, 8195), ModItems.CHORUS_FRUIT.get(), ModItems.CHORUS_FRUIT.get());
        ModRecipes.addShapedRecipe(ModItems.END_CRYSTAL.newItemStack(), "xxx", "xyx", "xzx", Character.valueOf('x'), "blockGlassColorless", Character.valueOf('y'), Items.field_151061_bv, Character.valueOf('z'), Items.field_151073_bk);
        ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 1), ModBlocks.ROSE.get());
        ModRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), "xx", "xx", "xx", Character.valueOf('x'), ModBlocks.ROSE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.ROSE.newItemStack(12), "xx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        if (ModItems.TIPPED_ARROW.isEnabled() && ModItems.LINGERING_POTION.isEnabled()) {
            RecipeSorter.register((String)"etfuturum.RecipeTippedArrow", RecipeTippedArrow.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
            GameRegistry.addRecipe((IRecipe)new RecipeTippedArrow(ModItems.TIPPED_ARROW.newItemStack(), "xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151032_g, Character.valueOf('y'), ModItems.LINGERING_POTION.newItemStack(1, Short.MAX_VALUE)));
        }
        if (!ModsList.GTNH.isLoaded()) {
            for (int i4 = 0; i4 < ModBlocks.BEDS.length; ++i4) {
                int j = i4 == 14 ? 15 : i4;
                ModRecipes.addShapedRecipe(ModBlocks.BEDS[i4].newItemStack(1), "###", "XXX", Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, j), Character.valueOf('X'), "plankWood");
                if (i4 <= 0) continue;
                ModRecipes.addShapelessRecipe(ModBlocks.BEDS[i4].newItemStack(1), ModBlocks.BEDS[0].get(), ore_dyes[~j & 0xF]);
            }
            ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151104_aV, 1), ModBlocks.BEDS[0].newItemStack(), ore_dyes[1]);
            ModRecipes.addShapedRecipe(ModBlocks.MAGMA.newItemStack(), "xx", "xx", Character.valueOf('x'), new ItemStack(Items.field_151064_bs));
        }
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.RED_NETHERBRICK.newItemStack(), "xi", "ix", Character.valueOf('x'), Items.field_151075_bm, Character.valueOf('i'), "ingotBrickNether");
            ModRecipes.addShapedRecipe(ModBlocks.RED_NETHERBRICK.newItemStack(1, 2), "x", "x", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150333_U, 1, 6));
            ModRecipes.addSmelting(new ItemStack(Blocks.field_150385_bj, 1, 1), ModBlocks.RED_NETHERBRICK.newItemStack(), 0.1f);
            ModRecipes.addShapedRecipe(ModBlocks.RED_NETHERBRICK_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.RED_NETHERBRICK.newItemStack());
        }
        ModRecipes.addShapedRecipe(ModBlocks.RED_NETHERBRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.RED_NETHERBRICK.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.RED_NETHER_BRICK_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.RED_NETHERBRICK.newItemStack());
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.NETHER_WART.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), Items.field_151075_bm);
            ModRecipes.addShapedRecipe(ModBlocks.BONE.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151100_aR, 1, 15));
        }
        ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 9, 15), ModBlocks.BONE.newItemStack());
        if (!ModsList.GTNH.isLoaded()) {
            for (int i5 = 0; i5 < ore_dyes.length; ++i5) {
                int dye = ~i5 & 0xF;
                ModRecipes.addShapelessRecipe(ModBlocks.CONCRETE_POWDER.newItemStack(8, i5), ore_dyes[dye], new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n);
                ModRecipes.addSmelting(new ItemStack(Blocks.field_150406_ce, 1, i5), ModBlocks.TERRACOTTA[i5].newItemStack(), 0.1f);
            }
        }
        if (!ModsList.GTNH.isLoaded()) {
            if (!OreDictionary.getOres((String)"nuggetIron").isEmpty()) {
                ModRecipes.addShapedRecipe(ModBlocks.LANTERN.newItemStack(), "xxx", "xix", "xxx", Character.valueOf('x'), "nuggetIron", Character.valueOf('i'), Blocks.field_150478_aa);
                ModRecipes.addShapedRecipe(ModBlocks.SOUL_LANTERN.newItemStack(), "xxx", "xix", "xxx", Character.valueOf('x'), "nuggetIron", Character.valueOf('i'), ModBlocks.SOUL_TORCH.get());
            } else {
                ModRecipes.addShapedRecipe(ModBlocks.LANTERN.newItemStack(), "i", "x", Character.valueOf('x'), "ingotIron", Character.valueOf('i'), Blocks.field_150478_aa);
                ModRecipes.addShapedRecipe(ModBlocks.SOUL_LANTERN.newItemStack(), "i", "x", Character.valueOf('x'), "ingotIron", Character.valueOf('i'), ModBlocks.SOUL_TORCH.get());
            }
        }
        ModRecipes.addShapedRecipe(ModBlocks.SOUL_TORCH.newItemStack(4), "i", "x", "s", Character.valueOf('x'), "stickWood", Character.valueOf('i'), "coal", Character.valueOf('s'), "soulSand");
        ModRecipes.addShapedRecipe(ModBlocks.SOUL_TORCH.newItemStack(4), "i", "x", "s", Character.valueOf('x'), "stickWood", Character.valueOf('i'), "coal", Character.valueOf('s'), "soulSoil");
        ModRecipes.addShapedRecipe(ModBlocks.SOUL_TORCH.newItemStack(4), "i", "x", "s", Character.valueOf('x'), "stickWood", Character.valueOf('i'), "charcoal", Character.valueOf('s'), "soulSand");
        ModRecipes.addShapedRecipe(ModBlocks.SOUL_TORCH.newItemStack(4), "i", "x", "s", Character.valueOf('x'), "stickWood", Character.valueOf('i'), "charcoal", Character.valueOf('s'), "soulSoil");
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.BARREL.newItemStack(), "xsx", "x x", "xsx", Character.valueOf('x'), "plankWood", Character.valueOf('s'), "slabWood");
            ModRecipes.addShapedRecipe(ModBlocks.BLUE_ICE.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), Blocks.field_150403_cj);
        }
        ModRecipes.addShapedRecipe(ModBlocks.SMOKER.newItemStack(), " l ", "lxl", " l ", Character.valueOf('x'), Blocks.field_150460_al, Character.valueOf('l'), "logWood");
        ModRecipes.addShapedRecipe(ModBlocks.BLAST_FURNACE.newItemStack(), "iii", "ixi", "sss", Character.valueOf('x'), Blocks.field_150460_al, Character.valueOf('i'), "ingotIron", Character.valueOf('s'), ConfigBlocksItems.enableSmoothStone ? ModBlocks.SMOOTH_STONE.get() : Blocks.field_150348_b);
        ModRecipes.addSmelting(ModBlocks.ANCIENT_DEBRIS.get(), ModItems.NETHERITE_SCRAP.newItemStack(), 2.0f);
        ModRecipes.addShapelessRecipe(ModItems.NETHERITE_INGOT.newItemStack(), ModItems.NETHERITE_SCRAP.newItemStack(), ModItems.NETHERITE_SCRAP.newItemStack(), ModItems.NETHERITE_SCRAP.newItemStack(), ModItems.NETHERITE_SCRAP.newItemStack(), "ingotGold", "ingotGold", "ingotGold", "ingotGold");
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.NETHERITE_BLOCK.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.NETHERITE_INGOT.get());
        }
        ModRecipes.addShapedRecipe(ModItems.NETHERITE_INGOT.newItemStack(9), "x", Character.valueOf('x'), ModBlocks.NETHERITE_BLOCK.get());
        ModRecipes.addSmelting(ModBlocks.NETHER_GOLD_ORE.newItemStack(), new ItemStack(Items.field_151043_k), 0.1f);
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addSmelting(new ItemStack(Blocks.field_150348_b), ModBlocks.SMOOTH_STONE.newItemStack(), 0.1f);
            if (ModBlocks.SMOOTH_STONE.isEnabled()) {
                ItemStack stoneTile;
                Object object = ExternalContent.Items.BLUEPOWER_CIRCUIT_PLATE.isEnabled() ? ExternalContent.Items.BLUEPOWER_CIRCUIT_PLATE.newItemStack(2) : (stoneTile = ExternalContent.Items.PROJECTRED_CIRCUIT_PLATE.isEnabled() ? ExternalContent.Items.PROJECTRED_CIRCUIT_PLATE.newItemStack(2) : null);
                if (stoneTile != null) {
                    ModRecipes.removeFurnaceRecipeFor(new ItemStack(Blocks.field_150348_b), stoneTile);
                    ModRecipes.addShapedRecipe(stoneTile, "x", Character.valueOf('x'), ModBlocks.SMOOTH_STONE.newItemStack());
                }
            }
            ModRecipes.addSmelting(new ItemStack(Blocks.field_150322_A, 1, 0), ModBlocks.SMOOTH_SANDSTONE.newItemStack(), 0.1f);
            ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_SANDSTONE_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_SANDSTONE.newItemStack());
            ModRecipes.addSmelting(ModBlocks.RED_SANDSTONE.newItemStack(), ModBlocks.SMOOTH_RED_SANDSTONE.newItemStack(), 0.1f);
            ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_RED_SANDSTONE_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_RED_SANDSTONE.newItemStack());
        }
        ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_SANDSTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_SANDSTONE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_RED_SANDSTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_RED_SANDSTONE.newItemStack());
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addSmelting(new ItemStack(Blocks.field_150371_ca, 1, 0), ModBlocks.SMOOTH_QUARTZ.newItemStack(), 0.1f);
            ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_QUARTZ_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_QUARTZ.newItemStack());
        }
        ModRecipes.addShapedRecipe(ModBlocks.SMOOTH_QUARTZ_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.SMOOTH_QUARTZ.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.QUARTZ_BRICKS.newItemStack(4), "xx", "xx", Character.valueOf('x'), new ItemStack(Blocks.field_150371_ca, 1, 0));
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(), ModBlocks.LILY_OF_THE_VALLEY.newItemStack());
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(1, 1), ModBlocks.CORNFLOWER.newItemStack());
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(1, 3), ModBlocks.WITHER_ROSE.newItemStack());
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(), new ItemStack(Items.field_151100_aR, 1, 15));
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(1, 1), new ItemStack(Items.field_151100_aR, 1, 4));
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(1, 2), new ItemStack(Items.field_151100_aR, 1, 3));
        ModRecipes.addShapelessRecipe(ModItems.DYE.newItemStack(1, 3), new ItemStack(Items.field_151100_aR, 1, 0));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.COPPER_INGOT.newItemStack());
            ModRecipes.addShapedRecipe(ModItems.COPPER_INGOT.newItemStack(9), "x", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack());
            ModRecipes.addShapedRecipe(ModItems.COPPER_INGOT.newItemStack(9), "x", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 8));
        }
        ModRecipes.addSmelting(ModBlocks.COPPER_ORE.newItemStack(), ModItems.COPPER_INGOT.newItemStack(), 0.7f);
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 4), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 5), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 6), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 7), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 12), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 8));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 13), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 9));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 14), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 10));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BLOCK.newItemStack(4, 15), "xx", "xx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 11));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 1), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 2), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 3), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 4), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 8));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 5), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 9));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 6), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 10));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_GRATE.newItemStack(4, 7), " x ", "x x", " x ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 11));
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 1), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 1), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 2), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 2), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 3), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 3), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 8), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 8), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 9), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 9), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 10), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 10), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.COPPER_BULB.newItemStack(4, 11), " x ", "xbx", " r ", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 11), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('r'), "dustRedstone");
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 1), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 2), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 3), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 3));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 4), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 5), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 5));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 6), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 6));
        ModRecipes.addShapedRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 7), "x", "x", Character.valueOf('x'), ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 7));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 4));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 5));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 2), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 6));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 3), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 7));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 4), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 12));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 5), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 13));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 6), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 14));
            ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(6, 7), "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 15));
        }
        ModRecipes.addShapedRecipe(ModBlocks.CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 4));
        ModRecipes.addShapedRecipe(ModBlocks.EXPOSED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 5));
        ModRecipes.addShapedRecipe(ModBlocks.WEATHERED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 6));
        ModRecipes.addShapedRecipe(ModBlocks.OXIDIZED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 7));
        ModRecipes.addShapedRecipe(ModBlocks.WAXED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 12));
        ModRecipes.addShapedRecipe(ModBlocks.WAXED_EXPOSED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 13));
        ModRecipes.addShapedRecipe(ModBlocks.WAXED_WEATHERED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 14));
        ModRecipes.addShapedRecipe(ModBlocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COPPER_BLOCK.newItemStack(1, 15));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.COPPER_DOOR.newItemStack(3), "xx", "xx", "xx", Character.valueOf('x'), ModItems.COPPER_INGOT.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.COPPER_TRAPDOOR.newItemStack(2), "xxX", "xxX", Character.valueOf('x'), ModItems.COPPER_INGOT.newItemStack());
        }
        boolean slimeball = true;
        for (int k = 0; k <= IDegradable.waxStrings.length; ++k) {
            String waxString;
            if (k == IDegradable.waxStrings.length) {
                if (!slimeball) break;
                waxString = "slimeball";
            } else {
                waxString = IDegradable.waxStrings[k];
            }
            if (!OreDictionary.doesOreNameExist((String)waxString)) continue;
            slimeball = false;
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 8), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 9), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 1));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 10), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 2));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 11), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 3));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 12), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 4));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 13), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 5));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 14), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 6));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BLOCK.newItemStack(1, 15), waxString, ModBlocks.COPPER_BLOCK.newItemStack(1, 7));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_GRATE.newItemStack(1, 4), waxString, ModBlocks.COPPER_GRATE.newItemStack(1));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_GRATE.newItemStack(1, 5), waxString, ModBlocks.COPPER_GRATE.newItemStack(1, 1));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_GRATE.newItemStack(1, 6), waxString, ModBlocks.COPPER_GRATE.newItemStack(1, 2));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_GRATE.newItemStack(1, 7), waxString, ModBlocks.COPPER_GRATE.newItemStack(1, 3));
            ModRecipes.addShapelessRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 4), waxString, ModBlocks.CHISELED_COPPER.newItemStack(1));
            ModRecipes.addShapelessRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 5), waxString, ModBlocks.CHISELED_COPPER.newItemStack(1, 1));
            ModRecipes.addShapelessRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 6), waxString, ModBlocks.CHISELED_COPPER.newItemStack(1, 2));
            ModRecipes.addShapelessRecipe(ModBlocks.CHISELED_COPPER.newItemStack(1, 7), waxString, ModBlocks.CHISELED_COPPER.newItemStack(1, 3));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BULB.newItemStack(1, 12), waxString, ModBlocks.COPPER_BULB.newItemStack(1, 4));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BULB.newItemStack(1, 13), waxString, ModBlocks.COPPER_BULB.newItemStack(1, 5));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BULB.newItemStack(1, 14), waxString, ModBlocks.COPPER_BULB.newItemStack(1, 6));
            ModRecipes.addShapelessRecipe(ModBlocks.COPPER_BULB.newItemStack(1, 15), waxString, ModBlocks.COPPER_BULB.newItemStack(1, 7));
            ModRecipes.addShapelessRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 4), waxString, ModBlocks.CUT_COPPER_SLAB.newItemStack(1));
            ModRecipes.addShapelessRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 5), waxString, ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 1));
            ModRecipes.addShapelessRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 6), waxString, ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 2));
            ModRecipes.addShapelessRecipe(ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 7), waxString, ModBlocks.CUT_COPPER_SLAB.newItemStack(1, 3));
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_CUT_COPPER_STAIRS.newItemStack(), waxString, ModBlocks.CUT_COPPER_STAIRS.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_EXPOSED_CUT_COPPER_STAIRS.newItemStack(), waxString, ModBlocks.EXPOSED_CUT_COPPER_STAIRS.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_WEATHERED_CUT_COPPER_STAIRS.newItemStack(), waxString, ModBlocks.WEATHERED_CUT_COPPER_STAIRS.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS.newItemStack(), waxString, ModBlocks.OXIDIZED_CUT_COPPER_STAIRS.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_COPPER_DOOR.newItemStack(), waxString, ModBlocks.COPPER_DOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_EXPOSED_COPPER_DOOR.newItemStack(), waxString, ModBlocks.EXPOSED_COPPER_DOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_WEATHERED_COPPER_DOOR.newItemStack(), waxString, ModBlocks.WEATHERED_COPPER_DOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_OXIDIZED_COPPER_DOOR.newItemStack(), waxString, ModBlocks.OXIDIZED_COPPER_DOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_COPPER_TRAPDOOR.newItemStack(), waxString, ModBlocks.COPPER_TRAPDOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_EXPOSED_COPPER_TRAPDOOR.newItemStack(), waxString, ModBlocks.EXPOSED_COPPER_TRAPDOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_WEATHERED_COPPER_TRAPDOOR.newItemStack(), waxString, ModBlocks.WEATHERED_COPPER_TRAPDOOR.newItemStack());
            ModRecipes.addShapelessRecipe(ModBlocks.WAXED_OXIDIZED_COPPER_TRAPDOOR.newItemStack(), waxString, ModBlocks.OXIDIZED_COPPER_TRAPDOOR.newItemStack());
        }
        ModRecipes.addSmelting(ModBlocks.COBBLED_DEEPSLATE.get(), ModBlocks.DEEPSLATE.newItemStack(), 0.1f);
        ModRecipes.addSmelting(ModBlocks.DEEPSLATE_BRICKS.newItemStack(), ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 1), 0.1f);
        ModRecipes.addSmelting(ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 2), ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 3), 0.1f);
        ModRecipes.addShapedRecipe(ModBlocks.POLISHED_DEEPSLATE.newItemStack(4), "xx", "xx", Character.valueOf('x'), ModBlocks.COBBLED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICKS.newItemStack(4), "xx", "xx", Character.valueOf('x'), ModBlocks.POLISHED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICKS.newItemStack(4, 2), "xx", "xx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 4), "x", "x", Character.valueOf('x'), ModBlocks.DEEPSLATE_SLAB.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.TUFF.newItemStack(4, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.TUFF.newItemStack(4, 2), "xx", "xx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.TUFF.newItemStack(1, 3), "x", "x", Character.valueOf('x'), ModBlocks.TUFF_SLAB.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.TUFF.newItemStack(1, 4), "x", "x", Character.valueOf('x'), ModBlocks.TUFF_SLAB.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.COBBLED_DEEPSLATE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.COBBLED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.POLISHED_DEEPSLATE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.POLISHED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_TILE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 2));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.COBBLED_DEEPSLATE.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.POLISHED_DEEPSLATE.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICK_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICK_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 2));
        }
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.COBBLED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_WALL.newItemStack(6, 1), "xxx", "xxx", Character.valueOf('x'), ModBlocks.POLISHED_DEEPSLATE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICK_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.DEEPSLATE_BRICK_WALL.newItemStack(6, 1), "xxx", "xxx", Character.valueOf('x'), ModBlocks.DEEPSLATE_BRICKS.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.TUFF_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.POLISHED_TUFF_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.TUFF_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 2));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.TUFF_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.TUFF_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.TUFF_SLAB.newItemStack(6, 2), "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 2));
        }
        ModRecipes.addShapedRecipe(ModBlocks.TUFF_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.TUFF_WALL.newItemStack(6, 1), "xxx", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.TUFF_WALL.newItemStack(6, 2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.TUFF.newItemStack(1, 2));
        ModRecipes.addShapelessRecipe(ModBlocks.MUDDY_MANGROVE_ROOTS.newItemStack(1), ModBlocks.MUD.newItemStack(), ModBlocks.MANGROVE_ROOTS.newItemStack());
        ModRecipes.addShapelessRecipe(ModBlocks.PACKED_MUD.newItemStack(1, 0), ModBlocks.MUD.newItemStack(1), new ItemStack(Items.field_151015_O, 1));
        ModRecipes.addShapedRecipe(ModBlocks.PACKED_MUD.newItemStack(4, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.PACKED_MUD.newItemStack(1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.MUD_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.PACKED_MUD.newItemStack(1, 1));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.MUD_BRICK_SLAB.newItemStack(6, 0), "xxx", Character.valueOf('x'), ModBlocks.PACKED_MUD.newItemStack(1, 1));
        }
        ModRecipes.addShapedRecipe(ModBlocks.MUD_BRICK_WALL.newItemStack(6, 0), "xxx", "xxx", Character.valueOf('x'), ModBlocks.PACKED_MUD.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.MOSS_BLOCK.newItemStack(1, 0), "xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150395_bd, 1), Character.valueOf('y'), new ItemStack(Blocks.field_150346_d, 1));
        for (int i6 = 0; i6 < ModRecipes.getStewFlowers().size(); ++i6) {
            ItemStack stew = ModItems.SUSPICIOUS_STEW.newItemStack();
            PotionEffect effect = EtFuturum.getSuspiciousStewEffect(ModRecipes.getStewFlowers().get(i6));
            stew.field_77990_d = new NBTTagCompound();
            NBTTagList effectsList = new NBTTagList();
            stew.field_77990_d.func_74782_a("Effects", (NBTBase)effectsList);
            NBTTagCompound potionEffect = new NBTTagCompound();
            potionEffect.func_74774_a("EffectId", (byte)effect.func_76456_a());
            potionEffect.func_74768_a("EffectDuration", effect.func_76459_b());
            effectsList.func_74742_a((NBTBase)potionEffect);
            ModRecipes.addShapelessRecipe(stew, Blocks.field_150337_Q, Blocks.field_150338_P, Items.field_151054_z, ModRecipes.getStewFlowers().get(i6));
        }
        if (!ModsList.GTNH.isLoaded()) {
            for (Map.Entry<String, ItemNewBoat.BoatInfo> entry : ItemNewBoat.BOAT_INFO.entrySet()) {
                ItemStack boat;
                String key = entry.getKey();
                if (key == null) continue;
                boolean isOak = entry.getKey().equals("minecraft:oak");
                ItemStack itemStack = boat = isOak && ConfigBlocksItems.replaceOldBoats ? new ItemStack(Items.field_151124_az) : entry.getValue().getBoatItem();
                if (key.endsWith("_chest")) {
                    ItemStack inputBoat = ItemNewBoat.BOAT_INFO.get(key.substring(0, key.indexOf("_chest"))).getBoatItem();
                    ModRecipes.addShapelessRecipe(boat, "chestWood", inputBoat);
                    continue;
                }
                if (isOak) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(boat, new Object[]{ConfigBlocksItems.replaceOldBoats ? "x x" : "xyx", "xxx", Character.valueOf('x'), "plankWood", Character.valueOf('y'), new ItemStack(Items.field_151038_n, 1)}));
                    continue;
                }
                ModRecipes.addShapedRecipe(boat, ConfigBlocksItems.replaceOldBoats ? "x x" : "xyx", "xxx", Character.valueOf('x'), entry.getValue().getPlank(), Character.valueOf('y'), new ItemStack(Items.field_151038_n, 1));
            }
            if (!ConfigBlocksItems.replaceOldBoats) {
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151124_az), "boatWood");
                ModRecipes.addShapelessRecipe(ModItems.BOATS[0].newItemStack(), Items.field_151038_n, Items.field_151124_az);
            }
            ModRecipes.addShapedRecipe(ModBlocks.SHULKER_BOX.newItemStack(), "x", "c", "x", Character.valueOf('x'), ModItems.SHULKER_SHELL.newItemStack(), Character.valueOf('c'), new ItemStack((Block)Blocks.field_150486_ae));
        }
        if (ModBlocks.SHULKER_BOX.isEnabled()) {
            for (int i7 = ore_dyes.length - 1; i7 >= 0; --i7) {
                ItemStack shulker = ModBlocks.SHULKER_BOX.newItemStack();
                shulker.func_77982_d(new NBTTagCompound());
                shulker.func_77978_p().func_74774_a("Color", (byte)(16 - i7));
                GameRegistry.addRecipe((IRecipe)new RecipeDyedShulkerBox(shulker, new Object[]{ModBlocks.SHULKER_BOX.get(), ore_dyes[i7]}));
            }
        }
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(), "XXX", "XYX", "XXX", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), ModItems.SHULKER_SHELL.get());
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 1), "XXX", "XYX", "XXX", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), ModItems.SHULKER_SHELL.get());
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 2), "XYX", "XXX", "XXX", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), "ingotIron");
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 3), "GXG", "GYG", "GXG", Character.valueOf('X'), "gemDiamond", Character.valueOf('Y'), "ingotGold", Character.valueOf('G'), "blockGlassColorless");
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 4), "XYX", "XXX", "XXX", Character.valueOf('X'), Blocks.field_150343_Z, Character.valueOf('Y'), "blockGlassColorless");
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 5), "XYX", "XXX", "XXX", Character.valueOf('X'), "blockGlassColorless", Character.valueOf('Y'), Blocks.field_150343_Z);
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 6), "GGG", "XYX", "XGX", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), "ingotCopper", Character.valueOf('G'), "blockGlassColorless");
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 7), "XYX", "XXX", "XXX", Character.valueOf('X'), "ingotSilver", Character.valueOf('Y'), "ingotCopper");
        ModRecipes.addShapedRecipe(ModItems.SHULKER_BOX_UPGRADE.newItemStack(1, 8), "XYX", "GGG", "XGX", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), "ingotSilver", Character.valueOf('G'), "blockGlassColorless");
        if (ConfigWorld.tileReplacementMode == -1) {
            if (ModBlocks.ANVIL.isEnabled()) {
                GameRegistry.addShapedRecipe((ItemStack)ModBlocks.ANVIL.newItemStack(), (Object[])new Object[]{"BBB", " I ", "III", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('B'), new ItemStack(Blocks.field_150339_S)});
                ModRecipes.removeFirstRecipeFor(Blocks.field_150467_bQ);
            }
            if (ModBlocks.BREWING_STAND.isEnabled()) {
                GameRegistry.addShapedRecipe((ItemStack)ModBlocks.BREWING_STAND.newItemStack(), (Object[])new Object[]{" B ", "CCC", Character.valueOf('C'), new ItemStack(Blocks.field_150347_e), Character.valueOf('B'), new ItemStack(Items.field_151072_bj)});
                ModRecipes.removeFirstRecipeFor(Blocks.field_150382_bo);
            }
            if (ModBlocks.BEACON.isEnabled()) {
                GameRegistry.addShapedRecipe((ItemStack)ModBlocks.BEACON.newItemStack(), (Object[])new Object[]{"GGG", "GNG", "OOO", Character.valueOf('G'), new ItemStack(Blocks.field_150359_w), Character.valueOf('N'), new ItemStack(Items.field_151156_bN), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z)});
                ModRecipes.removeFirstRecipeFor((Block)Blocks.field_150461_bJ);
            }
            if (ModBlocks.ENCHANTMENT_TABLE.isEnabled()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.ENCHANTMENT_TABLE.newItemStack(), new Object[]{" B ", "D#D", "###", Character.valueOf('#'), Blocks.field_150343_Z, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('D'), "gemDiamond"}));
                ModRecipes.removeFirstRecipeFor(Blocks.field_150381_bn);
            }
            if (ModBlocks.SPONGE.isEnabled()) {
                ModRecipes.addShapelessRecipe(ModBlocks.SPONGE.newItemStack(), Blocks.field_150360_v);
                ModRecipes.addShapelessRecipe(new ItemStack(Blocks.field_150360_v), ModBlocks.SPONGE.get());
            }
        }
        ModRecipes.addShapedRecipe(ModBlocks.STONE_WALL.newItemStack(6), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150417_aV, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.STONE_WALL.newItemStack(6, 1), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150417_aV, 1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.STONE_WALL.newItemStack(6, 2), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150322_A, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.STONE_WALL.newItemStack(6, 3), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150336_V, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.NETHER_BRICK_WALL.newItemStack(6), "BBB", "BBB", Character.valueOf('B'), new ItemStack(Blocks.field_150385_bj));
        ModRecipes.addShapedRecipe(ModBlocks.SMITHING_TABLE.newItemStack(), "II", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('I'), "ingotIron");
        ModRecipes.addShapedRecipe(ModBlocks.FLETCHING_TABLE.newItemStack(), "FF", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.STONECUTTER.newItemStack(), " I ", "SSS", Character.valueOf('S'), "stone", Character.valueOf('I'), "ingotIron");
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.COMPOSTER.newItemStack(), "S S", "S S", "SSS", Character.valueOf('S'), "slabWood");
        }
        ModRecipes.addShapedRecipe(ModBlocks.CARTOGRAPHY_TABLE.newItemStack(), "pp", "PP", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('p'), new ItemStack(Items.field_151121_aF, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.LOOM.newItemStack(), "SS", "PP", Character.valueOf('P'), "plankWood", Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1, 0));
        ModRecipes.addShapedRecipe(ModBlocks.AMETHYST_BLOCK.newItemStack(), "AA", "AA", Character.valueOf('A'), "gemAmethyst");
        ModRecipes.addShapedRecipe(ModBlocks.TINTED_GLASS.newItemStack(2, 0), " A ", "AGA", " A ", Character.valueOf('A'), "gemAmethyst", Character.valueOf('G'), "blockGlassColorless");
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.TARGET.newItemStack(), " R ", "RHR", " R ", Character.valueOf('R'), "dustRedstone", Character.valueOf('H'), Blocks.field_150407_cf);
            ModRecipes.addShapedRecipe(ModBlocks.OBSERVER.newItemStack(), "CCC", "RRQ", "CCC", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), "cobblestone", Character.valueOf('Q'), "gemQuartz");
        }
        ModRecipes.addShapedRecipe(ModBlocks.HONEY_BLOCK.newItemStack(), "HH", "HH", Character.valueOf('H'), ModItems.HONEY_BOTTLE.get());
        ModRecipes.addShapedRecipe(ModBlocks.HONEYCOMB_BLOCK.newItemStack(), "HH", "HH", Character.valueOf('H'), "materialHoneycomb");
        ModRecipes.addShapedRecipe(ModBlocks.BEEHIVE.newItemStack(), "WWW", "HHH", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('H'), "materialHoneycomb");
        ModRecipes.addShapedRecipe(ModBlocks.CHAIN.newItemStack(), "N", "G", "N", Character.valueOf('N'), "nuggetIron", Character.valueOf('G'), "ingotIron");
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE.newItemStack(4, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE.newItemStack(4, 2), "xx", "xx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE.newItemStack(1, 4), "x", "x", Character.valueOf('x'), ModBlocks.BLACKSTONE_SLAB.newItemStack(1, 1));
        ModRecipes.addSmelting(ModBlocks.BLACKSTONE.newItemStack(1, 2), ModBlocks.BLACKSTONE.newItemStack(1, 3), 0.1f);
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_SLAB.newItemStack(6), "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_SLAB.newItemStack(6, 1), "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_SLAB.newItemStack(6, 2), "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 2));
        }
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.POLISHED_BLACKSTONE_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.POLISHED_BLACKSTONE_BRICK_STAIRS.newItemStack(4), "x  ", "xx ", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_WALL.newItemStack(6), "xxx", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack());
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_WALL.newItemStack(6, 1), "xxx", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModBlocks.BLACKSTONE_WALL.newItemStack(6, 2), "xxx", "xxx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 2));
        if (!ModsList.GTNH.isLoaded()) {
            ModRecipes.addShapedRecipe(ModBlocks.POLISHED_BLACKSTONE_BUTTON.newItemStack(1), "x", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
            ModRecipes.addShapedRecipe(ModBlocks.POLISHED_BLACKSTONE_PRESSURE_PLATE.newItemStack(1), "xx", Character.valueOf('x'), ModBlocks.BLACKSTONE.newItemStack(1, 1));
        }
        ModRecipes.addShapedRecipe(ModBlocks.BASALT.newItemStack(4, 1), "xx", "xx", Character.valueOf('x'), ModBlocks.BASALT.newItemStack());
        ModRecipes.addSmelting(ModBlocks.BASALT.newItemStack(), ModBlocks.SMOOTH_BASALT.newItemStack(), 0.1f);
        if (ModsList.LOTR.isLoaded() && ConfigModCompat.moddedRawOres) {
            ModRecipes.registerOre("oreCopper", GameRegistry.findBlock((String)"lotr", (String)"tile.oreCopper"));
            ModRecipes.registerOre("ingotCopper", GameRegistry.findItem((String)"lotr", (String)"item.copper"));
            ModRecipes.registerOre("oreTin", GameRegistry.findBlock((String)"lotr", (String)"tile.oreTin"));
            ModRecipes.registerOre("ingotTin", GameRegistry.findItem((String)"lotr", (String)"item.tin"));
            ModRecipes.registerOre("oreSilver", GameRegistry.findBlock((String)"lotr", (String)"tile.oreSilver"));
            ModRecipes.registerOre("ingotSilver", GameRegistry.findItem((String)"lotr", (String)"item.silver"));
            ModRecipes.registerOre("oreMithril", GameRegistry.findBlock((String)"lotr", (String)"tile.oreMithril"));
            ModRecipes.registerOre("ingotMithril", GameRegistry.findItem((String)"lotr", (String)"item.mithril"));
        }
        if (ModsList.BIG_REACTORS.isLoaded() && ConfigModCompat.moddedRawOres) {
            ModRecipes.registerOre("oreUranium", ExternalContent.Blocks.BR_YELLORITE_ORE.get());
        }
        ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151100_aR, 1, 9), ModBlocks.PINK_PETALS.get());
        if (!ConfigExperiments.netherDimensionProvider) {
            ModRecipes.addShapelessRecipe(ModBlocks.SOUL_SOIL.newItemStack(5), Blocks.field_150346_d, Blocks.field_150425_aM, Blocks.field_150425_aM, Blocks.field_150425_aM, Blocks.field_150425_aM);
        }
        if (ConfigModCompat.moddedDeepslateOres) {
            DeepslateOreRegistry.addOreByOreDict("oreCoal", ModBlocks.DEEPSLATE_COAL_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreLapis", ModBlocks.DEEPSLATE_LAPIS_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreDiamond", ModBlocks.DEEPSLATE_DIAMOND_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreEmerald", ModBlocks.DEEPSLATE_EMERALD_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreCopper", ModBlocks.DEEPSLATE_COPPER_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreIron", ModBlocks.DEEPSLATE_IRON_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreGold", ModBlocks.DEEPSLATE_GOLD_ORE.get());
            DeepslateOreRegistry.addOreByOreDict("oreRedstone", ModBlocks.DEEPSLATE_REDSTONE_ORE.get());
        }
        ModRecipes.addTagsAndDeepslate("Coal", ModBlocks.DEEPSLATE_COAL_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Lapis", ModBlocks.DEEPSLATE_LAPIS_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Diamond", ModBlocks.DEEPSLATE_DIAMOND_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Emerald", ModBlocks.DEEPSLATE_EMERALD_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Copper", ModBlocks.DEEPSLATE_COPPER_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Iron", ModBlocks.DEEPSLATE_IRON_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Gold", ModBlocks.DEEPSLATE_GOLD_ORE.newItemStack());
        ModRecipes.addTagsAndDeepslate("Redstone", ModBlocks.DEEPSLATE_REDSTONE_ORE.newItemStack());
        ModRecipes.registerGeneralDeepslateOres();
        ModRecipes.registerModSupportDeepslateOres();
        ItemStack result = ModItems.COPPER_INGOT.isEnabled() ? ModItems.COPPER_INGOT.newItemStack() : Utils.getFirstStackFromTag("ingotCopper");
        ModRecipes.addShapedRecipe(ModBlocks.RAW_ORE_BLOCK.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.RAW_ORE.newItemStack());
        ModRecipes.addShapedRecipe(ModItems.RAW_ORE.newItemStack(9), "x", Character.valueOf('x'), ModBlocks.RAW_ORE_BLOCK.newItemStack());
        if (result != null) {
            ModRecipes.addSmelting(ModItems.RAW_ORE.newItemStack(), result, 0.7f);
        }
        ModRecipes.addShapedRecipe(ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 1), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.RAW_ORE.newItemStack(1, 1));
        ModRecipes.addShapedRecipe(ModItems.RAW_ORE.newItemStack(9, 1), "x", Character.valueOf('x'), ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 1));
        ModRecipes.addSmelting(ModItems.RAW_ORE.newItemStack(1, 1), new ItemStack(Items.field_151042_j, 1, 0), 0.7f);
        ModRecipes.addShapedRecipe(ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 2), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.RAW_ORE.newItemStack(1, 2));
        ModRecipes.addShapedRecipe(ModItems.RAW_ORE.newItemStack(9, 2), "x", Character.valueOf('x'), ModBlocks.RAW_ORE_BLOCK.newItemStack(1, 2));
        ModRecipes.addSmelting(ModItems.RAW_ORE.newItemStack(1, 2), new ItemStack(Items.field_151043_k, 1, 0), 0.7f);
        ModRecipes.registerGeneralRawOres();
        ModRecipes.registerModSupportRawOres();
    }

    public static void registerGeneralDeepslateOres() {
        for (BlockGeneralModdedDeepslateOre block : BlockGeneralModdedDeepslateOre.loaded) {
            for (int i = 0; i < block.ores.length; ++i) {
                String type = block.ores[i];
                for (int j = 0; j < 1; ++j) {
                    if (Utils.listGeneralModdedDeepslateOre(type)) {
                        DeepslateOreRegistry.addOreByOreDict(type, ModBlocks.MODDED_DEEPSLATE_ORE.get(), i);
                        ModRecipes.registerOre(type, ModBlocks.MODDED_DEEPSLATE_ORE.newItemStack(1, i));
                        ModRecipes.registerOre(type.replace("ore", "oreDeepslate"), ModBlocks.MODDED_DEEPSLATE_ORE.newItemStack(1, i));
                    }
                    if (!type.endsWith("Mythril")) continue;
                    type = type.replace("Mythril", "Mithril");
                    j = -1;
                }
            }
        }
    }

    public static void unregisterGeneralRawOres() {
        Pair pair = Pair.of(ItemGeneralModdedRawOre.loaded, BlockGeneralModdedRawOre.loaded);
        if (((List)pair.getLeft()).isEmpty()) {
            return;
        }
        for (int j = 0; j < ((List)pair.getLeft()).size(); ++j) {
            ItemGeneralModdedRawOre oreItem = (ItemGeneralModdedRawOre)((List)pair.getLeft()).get(j);
            BlockGeneralModdedRawOre oreBlock = (BlockGeneralModdedRawOre)((List)pair.getRight()).get(j);
            for (int i = 0; i < oreItem.ores.length; ++i) {
                ModRecipes.removeAllEFRRecipesFor(oreItem, i);
                ModRecipes.removeAllEFRRecipesFor(oreBlock, i);
                ItemStack stack = new ItemStack((Item)oreItem, 1, i);
                Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().keySet().iterator();
                while (iterator.hasNext()) {
                    ItemStack smeltingInput = (ItemStack)iterator.next();
                    if (stack.func_77973_b() != smeltingInput.func_77973_b() || stack.func_77960_j() != smeltingInput.func_77960_j()) continue;
                    iterator.remove();
                }
            }
        }
    }

    public static void registerGeneralRawOres() {
        Pair pair = Pair.of(ItemGeneralModdedRawOre.loaded, BlockGeneralModdedRawOre.loaded);
        if (((List)pair.getLeft()).size() != ((List)pair.getRight()).size()) {
            throw new RuntimeException("Modded raw ore block count does not match modded raw ore item count!");
        }
        if (((List)pair.getLeft()).isEmpty()) {
            return;
        }
        for (int k = 0; k < ((List)pair.getLeft()).size(); ++k) {
            ItemGeneralModdedRawOre oreItem = (ItemGeneralModdedRawOre)((List)pair.getLeft()).get(k);
            BlockGeneralModdedRawOre oreBlock = (BlockGeneralModdedRawOre)((List)pair.getRight()).get(k);
            for (int i = 0; i < oreItem.ores.length; ++i) {
                String type = oreItem.ores[i];
                boolean registeredRecipe = false;
                for (int j = 0; j < 1; ++j) {
                    if (Utils.listGeneralModdedRawOre(type)) {
                        ModRecipes.registerOre(type.replace("ingot", "raw"), new ItemStack((Item)oreItem, 1, i));
                        ModRecipes.registerOre(type.replace("ingot", "blockRaw"), new ItemStack((Block)oreBlock, 1, i));
                        if (ConfigFunctions.registerRawItemAsOre) {
                            ModRecipes.registerOre(type.replace("ingot", "ore"), new ItemStack((Item)oreItem, 1, i));
                        }
                        if (!registeredRecipe) {
                            ModRecipes.addShapedRecipe(new ItemStack((Block)oreBlock, 1, i), "xxx", "xxx", "xxx", Character.valueOf('x'), new ItemStack((Item)oreItem, 1, i));
                            ModRecipes.addShapedRecipe(new ItemStack((Item)oreItem, 9, i), "x", Character.valueOf('x'), new ItemStack((Block)oreBlock, 1, i));
                            registeredRecipe = true;
                        }
                        ModRecipes.addSmelting(new ItemStack((Item)oreItem, 1, i), Utils.getFirstStackFromTag(type), 0.7f);
                    }
                    if (!type.endsWith("Mythril")) continue;
                    type = type.replace("Mythril", "Mithril");
                    j = -1;
                }
            }
        }
    }

    private static void registerModSupportDeepslateOres() {
        if (Utils.enableModdedDeepslateOres()) {
            for (BaseDeepslateOre baseDeepslateOre : BaseDeepslateOre.loaded) {
                ItemStack baseStack = new ItemStack(baseDeepslateOre.getBase(), 1, baseDeepslateOre.getBaseMeta());
                ItemStack stack = new ItemStack((Block)baseDeepslateOre);
                for (String tag : EtFuturum.getOreStrings(baseStack)) {
                    if (tag.startsWith("ore")) {
                        ModRecipes.addTagsAndDeepslate(tag.replace("ore", ""), stack);
                        continue;
                    }
                    ModRecipes.registerOre(tag, stack);
                }
                if (!ModRecipes.validateItems(baseDeepslateOre)) continue;
                DeepslateOreRegistry.addOre(baseDeepslateOre.getBase(), baseDeepslateOre.getBaseMeta(), baseDeepslateOre, 0);
            }
            for (BaseSubtypesDeepslateOre baseSubtypesDeepslateOre : BaseSubtypesDeepslateOre.loaded) {
                for (int i = 0; i < baseSubtypesDeepslateOre.getTypes().length; ++i) {
                    ItemStack baseStack = new ItemStack(baseSubtypesDeepslateOre.getBase(i), 1, baseSubtypesDeepslateOre.getBaseMeta(i));
                    ItemStack stack = new ItemStack((Block)baseSubtypesDeepslateOre, 1, i);
                    for (String tag : EtFuturum.getOreStrings(baseStack)) {
                        if (tag.startsWith("ore")) {
                            ModRecipes.addTagsAndDeepslate(tag.replace("ore", ""), stack);
                            continue;
                        }
                        ModRecipes.registerOre(tag, stack);
                    }
                    if (!ModRecipes.validateItems(baseSubtypesDeepslateOre)) continue;
                    DeepslateOreRegistry.addOre(baseSubtypesDeepslateOre.getBase(i), baseSubtypesDeepslateOre.getBaseMeta(i), baseSubtypesDeepslateOre, i);
                }
            }
        }
    }

    private static void registerModSupportRawOres() {
        if (ModItems.RAW_ADAMANTIUM.isEnabled() && ModBlocks.RAW_ADAMANTIUM_BLOCK.isEnabled()) {
            ModRecipes.addTagsAndRawOre("Adamantium", ModItems.RAW_ADAMANTIUM.newItemStack());
            ModRecipes.addTagsAndRawOre("Adamantite", ModItems.RAW_ADAMANTIUM.newItemStack());
            ModRecipes.addTagsAndRawOre("Adamantine", ModItems.RAW_ADAMANTIUM.newItemStack());
            ModRecipes.registerOre("blockRawAdamantium", ModBlocks.RAW_ADAMANTIUM_BLOCK.newItemStack());
            ModRecipes.registerOre("blockRawAdamantite", ModBlocks.RAW_ADAMANTIUM_BLOCK.newItemStack());
            ModRecipes.registerOre("blockRawAdamantine", ModBlocks.RAW_ADAMANTIUM_BLOCK.newItemStack());
            ModRecipes.addShapedRecipe(ModBlocks.RAW_ADAMANTIUM_BLOCK.newItemStack(), "xxx", "xxx", "xxx", Character.valueOf('x'), ModItems.RAW_ADAMANTIUM.newItemStack());
            ModRecipes.addShapedRecipe(ModItems.RAW_ADAMANTIUM.newItemStack(9), "x", Character.valueOf('x'), ModBlocks.RAW_ADAMANTIUM_BLOCK.newItemStack());
            ModRecipes.addSmelting(ModItems.RAW_ADAMANTIUM.newItemStack(), ExternalContent.Items.SIMPLEORES_ADAMANTIUM_INGOT.newItemStack(), ExternalContent.Items.SIMPLEORES_ADAMANTIUM_INGOT.get().getSmeltingExperience(ExternalContent.Items.SIMPLEORES_ADAMANTIUM_INGOT.newItemStack()));
            RawOreRegistry.addOre("oreAdamantium", ModItems.RAW_ADAMANTIUM.get(), 0);
        }
    }

    private static void addTagsAndDeepslate(String tagNoPrefix, ItemStack stack) {
        ModRecipes.registerOre("ore" + StringUtils.capitalize((String)tagNoPrefix), stack);
        ModRecipes.registerOre("oreDeepslate" + StringUtils.capitalize((String)tagNoPrefix), stack);
    }

    private static void addTagsAndRawOre(String tagNoPrefix, ItemStack stack) {
        if (ConfigFunctions.registerRawItemAsOre) {
            ModRecipes.registerOre("ore" + StringUtils.capitalize((String)tagNoPrefix), stack);
        }
        ModRecipes.registerOre("raw" + StringUtils.capitalize((String)tagNoPrefix), stack);
    }

    private static List<ItemStack> getStewFlowers() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 2));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 3));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 1));
        list.add(new ItemStack((Block)Blocks.field_150327_N, 1));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 8));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 0));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 4));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 5));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 6));
        list.add(new ItemStack((Block)Blocks.field_150328_O, 1, 7));
        list.add(ModBlocks.LILY_OF_THE_VALLEY.newItemStack());
        list.add(ModBlocks.CORNFLOWER.newItemStack());
        list.add(ModBlocks.WITHER_ROSE.newItemStack());
        return list;
    }

    private static void removeFurnaceRecipeFor(ItemStack input, ItemStack output) {
        for (Map.Entry set : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            ItemStack setInput = (ItemStack)set.getKey();
            ItemStack setOutput = (ItemStack)set.getValue();
            int wildcard = Short.MAX_VALUE;
            if (input.func_77973_b() != setInput.func_77973_b() || input.func_77960_j() != wildcard && setInput.func_77960_j() != wildcard && input.func_77960_j() != setInput.func_77960_j() || output.func_77973_b() != setOutput.func_77973_b() || output.func_77960_j() != wildcard && setOutput.func_77960_j() != wildcard && output.func_77960_j() != setOutput.func_77960_j()) continue;
            FurnaceRecipes.func_77602_a().func_77599_b().remove(setInput, setOutput);
            return;
        }
    }

    private static void registerOre(String oreName, ItemStack ore) {
        if (ModRecipes.validateItems(ore)) {
            OreDictionary.registerOre((String)oreName, (ItemStack)ore);
        }
    }

    private static void registerOre(String oreName, Item ore) {
        if (ModRecipes.validateItems(ore)) {
            OreDictionary.registerOre((String)oreName, (Item)ore);
        }
    }

    private static void registerOre(String oreName, Block ore) {
        if (ModRecipes.validateItems(ore)) {
            OreDictionary.registerOre((String)oreName, (Block)ore);
        }
    }

    private static void addSmelting(Item input, ItemStack output, float exp) {
        if (ModRecipes.validateItems(input) && ModRecipes.validateItems(output)) {
            GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)exp);
        }
    }

    private static void addSmelting(Block input, ItemStack output, float exp) {
        if (ModRecipes.validateItems(input) && ModRecipes.validateItems(output)) {
            GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)exp);
        }
    }

    private static void addSmelting(ItemStack input, ItemStack output, float exp) {
        if (ModRecipes.validateItems(input) && ModRecipes.validateItems(output)) {
            GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)exp);
        }
    }

    private static void addShapedRecipe(ItemStack output, Object ... objects) {
        if (ModRecipes.validateItems(output) && ModRecipes.validateItems(objects)) {
            GameRegistry.addRecipe((IRecipe)new ShapedEtFuturumRecipe(output, objects));
        }
    }

    private static void addShapelessRecipe(ItemStack output, Object ... objects) {
        if (ModRecipes.validateItems(output) && ModRecipes.validateItems(objects)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessEtFuturumRecipe(output, objects));
        }
    }

    public static boolean validateItems(Object ... objects) {
        for (Object object : objects) {
            if (object == null || object == Blocks.field_150350_a) {
                return false;
            }
            if (object instanceof String) continue;
            if (object instanceof ItemStack && (((ItemStack)object).func_77973_b() == null || Item.field_150901_e.func_148750_c((Object)((ItemStack)object).func_77973_b()) == null)) {
                return false;
            }
            if (object instanceof Item && Item.field_150901_e.func_148750_c(object) == null) {
                return false;
            }
            if (!(object instanceof Block) || Block.field_149771_c.func_148750_c(object) != null) continue;
            return false;
        }
        return true;
    }

    private static void removeFirstRecipeFor(Block block) {
        ModRecipes.removeFirstRecipeFor(Item.func_150898_a((Block)block));
    }

    private static void removeFirstRecipeFor(Block block, int meta) {
        ModRecipes.removeFirstRecipeFor(Item.func_150898_a((Block)block), meta);
    }

    private static void removeFirstRecipeFor(Item item) {
        ModRecipes.removeFirstRecipeFor(item, Short.MAX_VALUE);
    }

    private static void removeFirstRecipeFor(Item item, int meta) {
        Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            IRecipe recipe = (IRecipe)iterator.next();
            if (recipe == null || (stack = recipe.func_77571_b()) == null || stack.func_77973_b() == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && meta != stack.func_77960_j()) continue;
            iterator.remove();
            return;
        }
    }

    private static void removeAllEFRRecipesFor(Block block) {
        ModRecipes.removeAllEFRRecipesFor(Item.func_150898_a((Block)block));
    }

    private static void removeAllEFRRecipesFor(Block block, int meta) {
        ModRecipes.removeAllEFRRecipesFor(Item.func_150898_a((Block)block), meta);
    }

    private static void removeAllEFRRecipesFor(Item item) {
        ModRecipes.removeAllEFRRecipesFor(item, Short.MAX_VALUE);
    }

    private static void removeAllEFRRecipesFor(Item item, int meta) {
        Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            IRecipe recipe = (IRecipe)iterator.next();
            if (!(recipe instanceof ShapedEtFuturumRecipe) && !(recipe instanceof ShapelessEtFuturumRecipe) || (stack = recipe.func_77571_b()) == null || stack.func_77973_b() == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && meta != stack.func_77960_j()) continue;
            iterator.remove();
        }
    }
}

