/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.block;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import ganymedes01.etfuturum.blocks.BlockBamboo;
import ganymedes01.etfuturum.client.renderer.block.BlockModelBase;
import ganymedes01.etfuturum.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

@ThreadSafeISBRH(perThread=false)
public class BlockBambooRenderer
extends BlockModelBase {
    public BlockBambooRenderer(int modelID) {
        super(modelID);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockBamboo bamboo = (BlockBamboo)block;
        int meta = world.func_72805_g(x, y, z);
        Vec3 offsets = BlockBamboo.getOffset(x, z);
        int age = BlockBamboo.getStalkSize(meta);
        float stemSize = age == 0 ? 0.125f : 0.1875f;
        float sizeOffset = age == 0 ? 0.0625f : 0.09375f;
        float offsetX = (float)(offsets.field_72450_a - (double)sizeOffset);
        float offsetZ = (float)(offsets.field_72449_c - (double)sizeOffset);
        renderer.func_147782_a((double)(1.0f - stemSize), 1.0, 0.0, 1.0, 1.0, (double)stemSize);
        this.renderFaceYPos(renderer, block, x, y, z, stemSize - (1.0f - offsetX), 0.0, offsetZ);
        int textureIndex = (int)Math.abs(Utils.hashPos(x, (int)((long)y * 2654435761L), z) % 4L);
        float textureOffset = 0.0625f * (float)(textureIndex * 3);
        float textureOffsetX = offsetX - textureOffset;
        float textureOffsetZ = offsetZ - textureOffset;
        renderer.func_147782_a((double)textureOffset, 0.0, (double)textureOffset, (double)(stemSize + textureOffset), 1.0, (double)(stemSize + textureOffset));
        this.renderFaceXPos(renderer, block, x, y, z, textureOffsetX, 0.0, textureOffsetZ);
        this.renderFaceZPos(renderer, block, x, y, z, textureOffsetX, 0.0, textureOffsetZ);
        this.renderFaceXNeg(renderer, block, x, y, z, textureOffsetX, 0.0, textureOffsetZ);
        this.renderFaceZNeg(renderer, block, x, y, z, textureOffsetX, 0.0, textureOffsetZ);
        int leavesSize = BlockBamboo.getLeavesSize(meta);
        if (leavesSize > 0 && leavesSize < 3) {
            if (!renderer.func_147744_b()) {
                renderer.func_147757_a(bamboo.leaves[leavesSize]);
            }
            this.drawStraightCrossedSquares(renderer, block, x, y, z, offsetX - 0.5f + sizeOffset, 0.0, offsetZ - 0.5f + sizeOffset);
            renderer.func_147757_a(null);
        }
        return true;
    }
}

