/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget.textfield;

import com.google.common.base.Joiner;
import com.gtnewhorizons.modularui.common.widget.ScrollBar;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldRenderer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class TextFieldHandler {
    private static final Joiner JOINER = Joiner.on((char)'\n');
    private final List<String> text = new ArrayList<String>();
    private final Point cursor = new Point();
    private final Point cursorEnd = new Point();
    private TextFieldRenderer renderer;
    @Nullable
    private ScrollBar scrollBar;
    private boolean mainCursorStart = true;
    private int maxLines = 1;
    @Nullable
    private Pattern pattern;
    private int maxCharacters = -1;

    public void setPattern(@Nullable Pattern pattern) {
        this.pattern = pattern;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setScrollBar(@Nullable ScrollBar scrollBar) {
        this.scrollBar = scrollBar;
    }

    public void setRenderer(TextFieldRenderer renderer) {
        this.renderer = renderer;
    }

    public void switchCursors() {
        this.mainCursorStart = !this.mainCursorStart;
    }

    public Point getMainCursor() {
        return this.mainCursorStart ? this.cursor : this.cursorEnd;
    }

    public Point getOffsetCursor() {
        return this.mainCursorStart ? this.cursorEnd : this.cursor;
    }

    public Point getStartCursor() {
        if (!this.hasTextMarked()) {
            return this.cursor;
        }
        return this.cursor.y > this.cursorEnd.y || this.cursor.y == this.cursorEnd.y && this.cursor.x > this.cursorEnd.x ? this.cursorEnd : this.cursor;
    }

    public Point getEndCursor() {
        if (!this.hasTextMarked()) {
            return this.cursor;
        }
        return this.cursor.y > this.cursorEnd.y || this.cursor.y == this.cursorEnd.y && this.cursor.x > this.cursorEnd.x ? this.cursor : this.cursorEnd;
    }

    public boolean hasTextMarked() {
        return this.cursor.y != this.cursorEnd.y || this.cursor.x != this.cursorEnd.x;
    }

    public void setOffsetCursor(int linePos, int charPos) {
        this.getOffsetCursor().setLocation(charPos, linePos);
    }

    public void setMainCursor(int linePos, int charPos) {
        Point main = this.getMainCursor();
        if (main.x != charPos || main.y != linePos) {
            main.setLocation(charPos, linePos);
            if (!this.text.isEmpty() && this.renderer != null && this.scrollBar != null && this.scrollBar.isActive()) {
                this.renderer.setSimulate(true);
                this.renderer.draw(this.text);
                this.renderer.setSimulate(false);
                String line = this.text.get(main.y);
                this.scrollBar.setScrollOffsetOfCursor(this.renderer.getPosOf(this.renderer.measureLines(Collections.singletonList(line)), (Point)main).x);
            }
        }
    }

    public void setCursor(int linePos, int charPos) {
        this.setCursor(linePos, charPos, true);
    }

    public void setCursor(int linePos, int charPos, boolean applyToOffset) {
        this.setMainCursor(linePos, charPos);
        if (applyToOffset) {
            this.setOffsetCursor(linePos, charPos);
        }
    }

    public void setOffsetCursor(Point cursor) {
        this.setOffsetCursor(cursor.y, cursor.x);
    }

    public void setMainCursor(Point cursor) {
        this.setMainCursor(cursor.y, cursor.x);
    }

    public void setCursor(Point cursor) {
        this.setMainCursor(cursor);
        this.setOffsetCursor(cursor);
    }

    public void putMainCursorAtStart() {
        if (this.hasTextMarked() && this.getMainCursor() != this.getStartCursor()) {
            this.switchCursors();
        }
    }

    public void putMainCursorAtEnd() {
        if (this.hasTextMarked() && this.getMainCursor() != this.getEndCursor()) {
            this.switchCursors();
        }
    }

    public void moveCursorLeft(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.x == 0) {
            if (main.y == 0) {
                this.setCursor(main.y, 0, !shift);
            } else {
                this.setCursor(main.y - 1, this.text.get(main.y - 1).length(), !shift);
            }
        } else {
            int newPos = main.x - 1;
            if (ctrl) {
                String line = this.text.get(main.y);
                boolean found = false;
                for (int i = main.x - 1; i >= 0; --i) {
                    char c = line.charAt(i);
                    if (Character.isLetter(c) || Character.isDigit(c)) continue;
                    newPos = i + 1;
                    found = true;
                    break;
                }
                if (!found) {
                    newPos = 0;
                }
            }
            this.setCursor(main.y, newPos, !shift);
        }
    }

    public void moveCursorRight(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        String line = this.text.get(main.y);
        if (main.x == line.length()) {
            if (main.y == this.text.size() - 1) {
                this.setCursor(main.y, main.x, !shift);
            } else {
                this.setCursor(main.y + 1, 0, !shift);
            }
        } else {
            int newPos = main.x + 1;
            if (ctrl) {
                boolean found = false;
                for (int i = main.x + 1; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (Character.isLetter(c) || Character.isDigit(c)) continue;
                    newPos = i;
                    found = true;
                    break;
                }
                if (!found) {
                    newPos = line.length();
                }
            }
            this.setCursor(main.y, newPos, !shift);
        }
    }

    public void moveCursorUp(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.y > 0) {
            this.setCursor(main.y - 1, main.x, !shift);
        } else {
            this.setCursor(main.y, 0, !shift);
        }
    }

    public void moveCursorDown(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.y < this.text.size() - 1) {
            this.setCursor(main.y + 1, main.x, !shift);
        } else {
            this.setCursor(main.y, this.text.get(main.y).length(), !shift);
        }
    }

    public void markAll() {
        this.setOffsetCursor(0, 0);
        this.setMainCursorLast();
    }

    public void setMainCursorLast() {
        if (this.text.size() == 0) {
            this.setMainCursor(0, 0);
        } else {
            this.setMainCursor(this.text.size() - 1, this.text.get(this.text.size() - 1).length());
        }
    }

    public String getTextAsString() {
        return JOINER.join(this.text);
    }

    public List<String> getText() {
        return this.text;
    }

    public void onChanged() {
    }

    public String getSelectedText() {
        if (!this.hasTextMarked()) {
            return "";
        }
        Point min = this.getStartCursor();
        Point max = this.getEndCursor();
        if (min.y == max.y) {
            return this.text.get(min.y).substring(min.x, max.x);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.text.get(min.y).substring(min.x));
        if (max.y > min.y + 2) {
            for (int i = min.y + 1; i < max.y - 1; ++i) {
                builder.append(this.text.get(i));
            }
        }
        builder.append(this.text.get(max.y), 0, max.x);
        return builder.toString();
    }

    public boolean test(String text) {
        return this.maxLines > 1 || (this.pattern == null || this.pattern.matcher(text).matches()) && (this.maxCharacters < 0 || this.maxCharacters >= text.length());
    }

    public void insert(String text) {
        this.insert(Arrays.asList(text.split("\n")));
    }

    public void insert(List<String> text) {
        ArrayList<String> copy = new ArrayList<String>(this.text);
        Point point = this.insert(copy, text);
        if (point == null || copy.size() > this.maxLines || !this.renderer.wouldFit(copy)) {
            return;
        }
        this.text.clear();
        this.text.addAll(copy);
        this.setCursor(point);
        this.onChanged();
    }

    private Point insert(List<String> text, List<String> insertion) {
        if (insertion.isEmpty() || insertion.size() > 1 && text.size() + insertion.size() - 1 > this.maxLines) {
            return null;
        }
        int x = this.cursor.x;
        int y = this.cursor.y;
        if (this.hasTextMarked()) {
            this.delete(false);
        }
        if (text.isEmpty()) {
            if (insertion.size() == 1 && !this.test(insertion.get(0))) {
                return null;
            }
            text.addAll(insertion);
            return new Point(text.get(text.size() - 1).length(), text.size() - 1);
        }
        String lineStart = text.get(this.cursor.y).substring(0, this.cursor.x);
        String lineEnd = text.get(this.cursor.y).substring(this.cursor.x);
        if (insertion.size() == 1 && text.size() == 1 && !this.test(lineStart + insertion.get(0) + lineEnd)) {
            return null;
        }
        text.set(this.cursor.y, lineStart + insertion.get(0));
        if (insertion.size() == 1) {
            if (!this.test(insertion.get(0))) {
                return null;
            }
            text.set(this.cursor.y, text.get(this.cursor.y) + lineEnd);
            return new Point(this.cursor.x + insertion.get(0).length(), this.cursor.y);
        }
        if (insertion.size() > 1) {
            text.add(this.cursor.y + 1, insertion.get(insertion.size() - 1) + lineEnd);
            x = insertion.get(insertion.size() - 1).length();
            ++y;
        }
        if (insertion.size() > 2) {
            text.addAll(this.cursor.y + 1, text.subList(1, insertion.size() - 1));
            x = insertion.get(insertion.size() - 1).length();
            y += insertion.size() - 1;
        }
        return new Point(x, y);
    }

    public void newLine() {
        if (this.hasTextMarked()) {
            this.delete(false);
        }
        String line = this.text.get(this.cursor.y);
        this.text.set(this.cursor.y, line.substring(0, this.cursor.x));
        this.text.add(this.cursor.y + 1, line.substring(this.cursor.x));
        this.setCursor(this.cursor.y + 1, 0);
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean inFront) {
        if (this.hasTextMarked()) {
            Point min = this.getStartCursor();
            Point max = this.getEndCursor();
            String minLine = this.text.get(min.y);
            if (min.y == max.y) {
                this.text.set(min.y, minLine.substring(0, min.x) + minLine.substring(max.x));
            } else {
                String maxLine = this.text.get(Math.min(this.text.size() - 1, max.y));
                this.text.set(min.y, minLine.substring(0, min.x) + maxLine.substring(max.x));
                if (max.y > min.y + 1) {
                    this.text.subList(min.y + 1, max.y + 1).clear();
                }
            }
            this.setCursor(min.y, min.x);
        } else {
            String line = this.text.get(this.cursor.y);
            if (inFront) {
                if (this.cursor.x == line.length()) {
                    if (this.text.size() > this.cursor.y + 1) {
                        this.text.set(this.cursor.y, line + this.text.get(this.cursor.y + 1));
                        this.text.remove(this.cursor.y + 1);
                    }
                } else {
                    line = line.substring(0, this.cursor.x) + line.substring(this.cursor.x + 1);
                    this.text.set(this.cursor.y, line);
                }
            } else if (this.cursor.x == 0) {
                if (this.cursor.y > 0) {
                    String lineAbove = this.text.get(this.cursor.y - 1);
                    this.text.set(this.cursor.y - 1, lineAbove + line);
                    this.text.remove(this.cursor.y);
                    this.setCursor(this.cursor.y - 1, lineAbove.length());
                }
            } else {
                line = line.substring(0, this.cursor.x - 1) + line.substring(this.cursor.x);
                this.text.set(this.cursor.y, line);
                this.setCursor(this.cursor.y, this.cursor.x - 1);
            }
        }
        if (this.scrollBar != null) {
            this.scrollBar.clampScrollOffset();
        }
        this.onChanged();
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
    }

    public int getMaxLines() {
        return this.maxLines;
    }
}

