/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.DimensionalCoord;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.api.registries.LevelItemInfo;
import com.glodblock.github.client.gui.container.base.FCBaseContainer;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.coremod.registries.LevelTerminalRegistry;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketLevelTerminalUpdate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;

public class ContainerLevelTerminal
extends FCBaseContainer {
    private int nextId = 0;
    private final Map<IGridHost, InvTracker> tracked = new HashMap<IGridHost, InvTracker>();
    private final Map<Long, InvTracker> trackedById = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private SPacketLevelTerminalUpdate updatePacket;
    private boolean isPacketDirty;
    private boolean wasOff;
    private int ticks = 0;

    public ContainerLevelTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        if (Platform.isServer()) {
            if (monitorable instanceof PartLevelTerminal) {
                PartLevelTerminal terminal = (PartLevelTerminal)monitorable;
                this.grid = terminal.getActionableNode().getGrid();
            } else if (monitorable instanceof IWirelessTerminal) {
                IWirelessTerminal wirelessTerminal = (IWirelessTerminal)monitorable;
                this.grid = wirelessTerminal.getActionableNode().getGrid();
            }
            this.updatePacket = this.updateList();
            if (this.updatePacket != null) {
                this.isPacketDirty = true;
            } else {
                this.updatePacket = new SPacketLevelTerminalUpdate();
                this.isPacketDirty = false;
            }
        }
        this.bindPlayerInventory(ip, 14, 0);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        IActionHost host = this.getActionHost();
        if (!host.getActionableNode().isActive()) {
            if (!this.wasOff) {
                SPacketLevelTerminalUpdate update = new SPacketLevelTerminalUpdate();
                update.addDisconnectEntry();
                this.wasOff = true;
                FluidCraft.proxy.netHandler.sendTo(update, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            return;
        }
        this.wasOff = false;
        if (this.isPacketDirty) {
            FluidCraft.proxy.netHandler.sendTo(this.updatePacket, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            this.updatePacket = new SPacketLevelTerminalUpdate();
            this.isPacketDirty = false;
        } else if (++this.ticks % 20 == 0) {
            this.ticks = 0;
            SPacketLevelTerminalUpdate updateNew = this.updateList();
            if (updateNew != null) {
                FluidCraft.proxy.netHandler.sendTo(updateNew, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
        }
    }

    @Nullable
    private SPacketLevelTerminalUpdate updateList() {
        SPacketLevelTerminalUpdate update = null;
        Set<Class<? extends ILevelViewable>> supported = LevelTerminalRegistry.instance().getSupportedClasses();
        HashSet<IGridHost> visited = new HashSet<IGridHost>();
        for (Class<? extends ILevelViewable> clz : supported) {
            boolean isAdopted = LevelTerminalRegistry.instance().isAdopted(clz);
            Class<? extends ILevelViewable> machineClass = isAdopted ? LevelTerminalRegistry.instance().getAdopted(clz) : clz;
            for (IGridNode gridNode : this.grid.getMachines(machineClass)) {
                IGridHost gridHost = gridNode.getMachine();
                ILevelViewable machine = isAdopted ? LevelTerminalRegistry.instance().getAdapter(clz).adapt(gridHost) : (ILevelViewable)gridHost;
                visited.add(gridHost);
                if (this.tracked.containsKey(gridHost)) {
                    LevelItemInfo[] curr;
                    LevelItemInfo[] prev;
                    InvTracker knownTracker = this.tracked.get(gridHost);
                    String name = machine.getCustomName();
                    if (!Objects.equals(knownTracker.name, name)) {
                        knownTracker.name = name;
                        if (update == null) {
                            update = new SPacketLevelTerminalUpdate();
                        }
                        update.addRenameEntry(knownTracker.id, name);
                    }
                    if ((prev = knownTracker.infoList).length == (curr = machine.getLevelItemInfoList()).length) {
                        for (int i = 0; i < prev.length; ++i) {
                            if (prev[i] == null && curr[i] == null) continue;
                            if (prev[i] == null) {
                                ((InvTracker)knownTracker).infoList[i] = curr[i];
                                if (update == null) {
                                    update = new SPacketLevelTerminalUpdate();
                                }
                                update.addOverwriteSlotEntry(knownTracker.id, i, curr[i]);
                                continue;
                            }
                            if (curr[i] == null) {
                                ((InvTracker)knownTracker).infoList[i] = null;
                                if (update == null) {
                                    update = new SPacketLevelTerminalUpdate();
                                }
                                update.addOverwriteSlotEntry(knownTracker.id, i, null);
                                continue;
                            }
                            if (ItemStack.func_77989_b((ItemStack)prev[i].stack, (ItemStack)curr[i].stack) && prev[i].quantity != curr[i].quantity && prev[i].batchSize != curr[i].batchSize && prev[i].state != curr[i].state) continue;
                            ((InvTracker)knownTracker).infoList[i] = curr[i];
                            if (update == null) {
                                update = new SPacketLevelTerminalUpdate();
                            }
                            update.addOverwriteSlotEntry(knownTracker.id, i, curr[i]);
                        }
                        continue;
                    }
                    InvTracker.access$202(knownTracker, curr);
                    if (update == null) {
                        update = new SPacketLevelTerminalUpdate();
                    }
                    update.addOverwriteAllSlotEntry(knownTracker.id, curr);
                    continue;
                }
                if (update == null) {
                    update = new SPacketLevelTerminalUpdate();
                }
                InvTracker entry = new InvTracker(this.nextId++, machine);
                update.addNewEntry(entry.id, entry.x, entry.y, entry.z, entry.dim, entry.side.ordinal(), entry.rows, entry.rowSize, entry.name, entry.infoList);
                this.tracked.put(gridHost, entry);
                this.trackedById.put(entry.id, entry);
            }
        }
        Iterator<Map.Entry<IGridHost, InvTracker>> it = this.tracked.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IGridHost, InvTracker> entry = it.next();
            if (visited.contains(entry.getKey())) continue;
            if (update == null) {
                update = new SPacketLevelTerminalUpdate();
            }
            update.addRemoveEntry(entry.getValue().id);
            this.trackedById.remove(entry.getValue().id);
            it.remove();
        }
        return update;
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }

    private static class InvTracker {
        private final long id;
        private String name;
        private final int rowSize;
        private final int rows;
        private final int x;
        private final int y;
        private final int z;
        private final int dim;
        private final ForgeDirection side;
        private LevelItemInfo[] infoList;

        public InvTracker(long id, ILevelViewable machine) {
            DimensionalCoord location = machine.getLocation();
            this.id = id;
            this.name = machine.getCustomName();
            this.rowSize = machine.rowSize();
            this.rows = machine.rows();
            this.x = location.x;
            this.y = location.y;
            this.z = location.z;
            this.dim = location.getDimension();
            this.side = machine.getSide();
            this.infoList = machine.getLevelItemInfoList();
        }

        static /* synthetic */ LevelItemInfo[] access$202(InvTracker x0, LevelItemInfo[] x1) {
            x0.infoList = x1;
            return x1;
        }
    }
}

