/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util.structurelib;

import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import java.util.Collections;
import java.util.HashMap;
import net.fuzzycraft.botanichorizons.util.multiblock.BasicBlockCheck;
import net.fuzzycraft.botanichorizons.util.multiblock.MetaBlockCheck;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockCheck;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockStructure;
import net.fuzzycraft.botanichorizons.util.structurelib.OrientedHoloContainer;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class HoloProjectorSupport {
    public static final String HOLO_DEFAULT_CHANNEL = "main";

    public static <T extends TileEntity> void registerOrientedWithStructureLib(MultiblockHelper definition, Block controllerBlock, Class<T> controllerTileClass) {
        String controllerReplaced;
        HashMap<MultiblockCheck, Character> keys = new HashMap<MultiblockCheck, Character>();
        int xMin = definition.blocks[0].dx;
        int xMax = definition.blocks[0].dx;
        int yMin = definition.blocks[0].dy;
        int yMax = definition.blocks[0].dy;
        int zMin = definition.blocks[0].dz;
        int zMax = definition.blocks[0].dz;
        char counter = 'a';
        for (MultiblockStructure piece : definition.blocks) {
            xMin = Math.min(xMin, piece.dx);
            xMax = Math.max(xMax, piece.dx);
            yMin = Math.min(yMin, piece.dy);
            yMax = Math.max(yMax, piece.dy);
            zMin = Math.min(zMin, piece.dz);
            zMax = Math.max(zMax, piece.dz);
            if (keys.containsKey(piece.check)) continue;
            keys.put(piece.check, Character.valueOf(counter));
            counter = (char)(counter + '\u0001');
        }
        String controllerChar = Character.valueOf(counter).toString();
        int xSize = xMax - xMin + 1;
        int ySize = yMax - yMin + 1;
        int zSize = zMax - zMin + 1;
        String[][] structureString = new String[zSize][ySize];
        for (int y = 0; y < ySize; ++y) {
            for (int z = 0; z < zSize; ++z) {
                structureString[z][y] = String.join((CharSequence)"", Collections.nCopies(xSize, " "));
            }
        }
        for (MultiblockStructure piece : definition.blocks) {
            String replaced;
            String key = ((Character)keys.get(piece.check)).toString();
            int xPos = piece.dx - xMin;
            int yPos = piece.dy - yMin;
            int zPos = piece.dz - zMin;
            String old = structureString[zPos][yPos];
            structureString[zPos][yPos] = replaced = old.substring(0, xPos) + key + old.substring(xPos + 1);
        }
        String controllerRowOld = structureString[-zMin][-yMin];
        structureString[-zMin][-yMin] = controllerReplaced = controllerRowOld.substring(0, -xMin) + controllerChar + controllerRowOld.substring(-xMin + 1);
        StructureDefinition.Builder builder = IStructureDefinition.builder();
        builder.addShape(HOLO_DEFAULT_CHANNEL, structureString);
        for (MultiblockCheck check : keys.keySet()) {
            char key = ((Character)keys.get(check)).charValue();
            IStructureElement<T> element = HoloProjectorSupport.genStructureElement(check);
            builder.addElement(key, element);
        }
        builder.addElement(counter, StructureUtility.ofBlockAnyMeta((Block)controllerBlock));
        IStructureDefinition structure = builder.build();
        OrientedHoloContainer container = new OrientedHoloContainer(structure, -xMin, -yMin, -zMin);
        IMultiblockInfoContainer.registerTileClass(controllerTileClass, container);
    }

    private static <T> IStructureElement<T> genStructureElement(MultiblockCheck check) {
        if (check instanceof BasicBlockCheck) {
            return StructureUtility.ofBlockAnyMeta((Block)((BasicBlockCheck)check).referenceBlock);
        }
        if (check instanceof MetaBlockCheck) {
            MetaBlockCheck parsed = (MetaBlockCheck)check;
            return StructureUtility.ofBlock((Block)parsed.referenceBlock, (int)parsed.referenceMeta);
        }
        return null;
    }
}

