/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.gson.JsonObject;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.ConditionHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.apache.commons.lang3.tuple.Pair;

public class FallConditionHandler
extends ConditionHandler {
    public static final String ID = "fall";
    public static final String PROPERTY_DISTANCE = "distance";
    private final List<Pair<Float, String>> conditions = new ArrayList<Pair<Float, String>>();

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void parse(String id, JsonObject json) {
        this.conditions.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(ConfigHandler.getFloatProperty(json, PROPERTY_DISTANCE, 0.0f)), (Object)id));
    }

    @Override
    protected boolean isForgeEventHandler() {
        return !this.conditions.isEmpty();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFall(LivingFallEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        float distance = event.distance;
        for (Pair<Float, String> condition : this.conditions) {
            if (!(distance >= ((Float)condition.getLeft()).floatValue())) continue;
            this.getListener().accept((String)condition.getRight(), player);
        }
    }
}

