/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EnergyPylon
extends BlockDE
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon icon_active_face;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon_input;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon_output;

    public EnergyPylon() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149663_c("energyPylon");
        ModBlocks.register(this);
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 1 || metadata == 2;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return metadata == 1 || metadata == 2 ? new TileEnergyPylon() : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icon_input = iconRegister.func_94245_a(References.RESOURCESPREFIX + "energy_pylon_input");
        this.icon_output = iconRegister.func_94245_a(References.RESOURCESPREFIX + "energy_pylon_output");
        this.icon_active_face = iconRegister.func_94245_a(References.RESOURCESPREFIX + "energy_pylon_active_face");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 1 && side == 1 || metadata == 2 && side == 0 ? this.icon_active_face : this.icon_input;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 1 && side == 1 || metadata == 2 && side == 0) {
            return this.icon_active_face;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyPylon) {
            TileEnergyPylon pylon = (TileEnergyPylon)tile;
            return pylon.isReceivingEnergy ? this.icon_input : this.icon_output;
        }
        return this.icon_input;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.updateBlockState(world, x, y, z);
    }

    private void updateBlockState(World world, int x, int y, int z) {
        TileEntity tile;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            if (world.func_147439_a(x, y + 1, z) == Blocks.field_150359_w) {
                metadata = 1;
                world.func_72921_c(x, y, z, metadata, 2);
                world.func_147465_d(x, y + 1, z, (Block)ModBlocks.invisibleMultiblock, 2, 2);
            } else if (world.func_147439_a(x, y - 1, z) == Blocks.field_150359_w) {
                metadata = 2;
                world.func_72921_c(x, y, z, metadata, 2);
                world.func_147465_d(x, y - 1, z, (Block)ModBlocks.invisibleMultiblock, 2, 2);
            }
        } else {
            tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileEnergyPylon) || metadata == 1 && this.isGlassMissing(world, x, y + 1, z) || metadata == 2 && this.isGlassMissing(world, x, y - 1, z)) {
                metadata = 0;
                world.func_72921_c(x, y, z, metadata, 2);
            }
        }
        tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyPylon) {
            ((TileEnergyPylon)tile).onActivated();
            if (metadata == 0) {
                world.func_147475_p(x, y, z);
            }
        }
    }

    private boolean isGlassMissing(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) != ModBlocks.invisibleMultiblock || world.func_72805_g(x, y, z) != 2;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyPylon) {
            TileEnergyPylon pylon = (TileEnergyPylon)tile;
            if (player.func_70093_af()) {
                pylon.nextCore();
            } else {
                pylon.onActivated();
            }
            return true;
        }
        return false;
    }

    public void func_149714_e(World world, int x, int y, int z, int metadata) {
        this.updateBlockState(world, x, y, z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEnergyPylon) {
            TileEnergyPylon pylon = (TileEnergyPylon)tile;
            return (int)(pylon.getEnergyStored() / pylon.getMaxEnergyStored() * 15.0);
        }
        return 0;
    }
}

