/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;

public class EntityCartGift
extends EntityCartTNTWood {
    private static final byte SPAWN_DIST = 2;
    private static final List<Gift> gifts = new ArrayList<Gift>();
    private static final List<Integer> potions = new ArrayList<Integer>();

    public static void addGift(ItemStack gift, int chance) {
        if (gift != null) {
            gifts.add(new Gift(gift, chance));
        }
    }

    public EntityCartGift(World world) {
        super(world);
    }

    public EntityCartGift(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.setBlastRadius(1.5f);
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(new ItemStack(Blocks.field_150423_aK));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public Block func_145820_n() {
        return null;
    }

    public int func_94085_r() {
        return 8;
    }

    @Override
    protected float getMinBlastRadius() {
        return 0.5f;
    }

    @Override
    protected float getMaxBlastRadius() {
        return 1.0f;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBlastRadius(), true);
            this.func_70106_y();
            if (this.field_70146_Z.nextInt(100) >= 50) {
                this.spawnGift();
                this.spawnGift();
            } else {
                this.spawnCoal();
            }
        }
    }

    private Gift getGift() {
        int weight;
        Gift gift;
        do {
            int index = this.field_70146_Z.nextInt(gifts.size());
            gift = gifts.get(index);
        } while (gift.chance < (weight = this.field_70146_Z.nextInt(100)));
        return gift;
    }

    private void spawnGift() {
        Gift gift = this.getGift();
        if (gift.stack == null) {
            this.spawnPotion();
            return;
        }
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        double y = this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextInt(3) - 1.0;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        InvTools.dropItem(gift.stack.func_77946_l(), this.field_70170_p, x, y, z);
    }

    private void spawnCoal() {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        double y = this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextInt(3) - 1.0;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        InvTools.dropItem(new ItemStack(Items.field_151044_h), this.field_70170_p, x, y, z);
    }

    private void spawnPotion() {
        int meta = potions.get(this.field_70146_Z.nextInt(potions.size()));
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, meta);
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        double y = this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextInt(3) - 1.0;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.field_70170_p, x, y, z);
    }

    static {
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(new ItemStack(Items.field_151126_ay, 16), 50));
        gifts.add(new Gift(new ItemStack(Blocks.field_150414_aQ), 25));
        gifts.add(new Gift(new ItemStack(Items.field_151054_z), 25));
        gifts.add(new Gift(new ItemStack(Items.field_151106_aX, 15), 75));
        gifts.add(new Gift(new ItemStack(Items.field_151106_aX, 10), 75));
        gifts.add(new Gift(new ItemStack(Items.field_151106_aX, 5), 75));
        gifts.add(new Gift(new ItemStack(Items.field_151158_bO), 20));
        gifts.add(new Gift(new ItemStack(Blocks.field_150421_aI), 5));
        gifts.add(new Gift(new ItemStack(Items.field_151159_an), 10));
        gifts.add(new Gift(new ItemStack(Items.field_151162_bE), 25));
        gifts.add(new Gift(new ItemStack(Items.field_151111_aL), 25));
        gifts.add(new Gift(new ItemStack(Items.field_151113_aN), 25));
        EntityCartGift.addGift(ItemCrowbar.getItem(), 20);
        gifts.add(new Gift(new ItemStack(Items.field_151062_by, 32), 5));
        gifts.add(new Gift(new ItemStack(Items.field_151062_by, 16), 10));
        gifts.add(new Gift(new ItemStack(Items.field_151062_by, 8), 20));
        gifts.add(new Gift(new ItemStack(Items.field_151062_by, 4), 40));
        gifts.add(new Gift(new ItemStack(Items.field_151062_by, 2), 80));
        gifts.add(new Gift(new ItemStack(Blocks.field_150484_ah), 1));
        gifts.add(new Gift(new ItemStack(Blocks.field_150475_bE), 2));
        gifts.add(new Gift(new ItemStack(Items.field_151166_bC), 30));
        gifts.add(new Gift(new ItemStack(Items.field_151045_i), 20));
        gifts.add(new Gift(new ItemStack(Items.field_151043_k), 30));
        gifts.add(new Gift(new ItemStack(Items.field_151043_k, 2), 30));
        gifts.add(new Gift(new ItemStack(Items.field_151074_bl, 8), 80));
        gifts.add(new Gift(new ItemStack(Items.field_151074_bl, 16), 40));
        gifts.add(new Gift(new ItemStack(Items.field_151074_bl, 32), 20));
        gifts.add(new Gift(new ItemStack(Items.field_151079_bi), 30));
        gifts.add(new Gift(new ItemStack(Items.field_151156_bN), 2));
        int recordChance = 1;
        gifts.add(new Gift(new ItemStack(Items.field_151086_cn), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151096_cd), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151094_cf), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151093_ce), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151091_cg), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151092_ch), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151089_ci), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151090_cj), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151087_ck), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151088_cl), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151085_cm), recordChance));
        gifts.add(new Gift(new ItemStack(Items.field_151084_co), recordChance));
        int toolChance = 10;
        gifts.add(new Gift(new ItemStack((Item)Items.field_151112_aM), toolChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151031_f), toolChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151097_aZ), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151056_x), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151046_w), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151047_v), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151048_u), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151012_L), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151006_E), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151005_D), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151011_C), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151010_B), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151013_M), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151036_c), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151035_b), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151037_a), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151040_l), toolChance));
        gifts.add(new Gift(new ItemStack(Items.field_151019_K), toolChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelAxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelPickaxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelSword(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelShovel(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelHoe(), toolChance);
        int armorChance = 5;
        gifts.add(new Gift(new ItemStack((Item)Items.field_151161_ac), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151163_ad), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151173_ae), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151175_af), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151169_ag), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151171_ah), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151149_ai), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151151_aj), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151028_Y), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151030_Z), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151165_aa), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151167_ab), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151024_Q), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151027_R), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151026_S), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.field_151021_T), armorChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelHelm(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelArmor(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelLegs(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelBoots(), armorChance);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = PotionHelper.func_77917_b((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }

    private static class Gift {
        public final int chance;
        public final ItemStack stack;

        public Gift(ItemStack stack, int chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }
}

