/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryCopy;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDispenserCart
extends TileMachineItem {
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean powered;
    protected int timeSinceLastSpawn;

    public TileDispenserCart() {
        super(3);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_CART;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.CART_DISPENSER, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideFacingTrack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.direction == ForgeDirection.UNKNOWN) {
            this.direction = MiscTools.getSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.timeSinceLastSpawn < Integer.MAX_VALUE) {
            ++this.timeSinceLastSpawn;
        }
    }

    public void onPulse() {
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.0f, this.direction);
        if (cart == null) {
            if (this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
                for (int ii = 0; ii < this.func_70302_i_(); ++ii) {
                    ItemStack cartStack = this.func_70301_a(ii);
                    if (cartStack == null) continue;
                    int x = MiscTools.getXOnSide(this.field_145851_c, this.direction);
                    int y = MiscTools.getYOnSide(this.field_145848_d, this.direction);
                    int z = MiscTools.getZOnSide(this.field_145849_e, this.direction);
                    boolean minecartItem = cartStack.func_77973_b() instanceof IMinecartItem;
                    if (cartStack.func_77973_b() instanceof ItemMinecart || minecartItem) {
                        boolean canPlace = true;
                        if (minecartItem) {
                            canPlace = ((IMinecartItem)cartStack.func_77973_b()).canBePlacedByNonPlayer(cartStack);
                        }
                        if (!canPlace) continue;
                        ItemStack placedStack = cartStack.func_77946_l();
                        EntityMinecart placedCart = CartUtils.placeCart(this.getOwner(), placedStack, (WorldServer)this.field_145850_b, x, y, z);
                        if (placedCart == null) continue;
                        this.func_70298_a(ii, 1);
                        this.timeSinceLastSpawn = 0;
                        break;
                    }
                    float rx = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                    float ry = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                    float rz = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                    EntityItem item = new EntityItem(this.field_145850_b, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), cartStack);
                    float factor = 0.05f;
                    item.field_70159_w = (float)MiscTools.getRand().nextGaussian() * factor;
                    item.field_70181_x = (float)MiscTools.getRand().nextGaussian() * factor + 0.2f;
                    item.field_70179_y = (float)MiscTools.getRand().nextGaussian() * factor;
                    this.field_145850_b.func_72838_d((Entity)item);
                    this.func_70299_a(ii, null);
                }
            }
        } else if (!cart.field_70128_L && cart.getCartItem() != null) {
            ItemStack remainder;
            InventoryCopy testInv = new InventoryCopy(this);
            ItemStack cartStack = cart.getCartItem();
            if (cart.func_145818_k_()) {
                cartStack.func_151001_c(cart.func_70005_c_());
            }
            if ((remainder = InvTools.moveItemStack(cartStack.func_77946_l(), testInv)) == null) {
                InvTools.moveItemStack(cartStack, this);
                if (cart.field_70153_n != null) {
                    cart.field_70153_n.func_70078_a(null);
                }
                cart.func_70106_y();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean newPower = PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.powered && newPower) {
            this.powered = newPower;
            this.onPulse();
        } else {
            this.powered = newPower;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74768_a("time", this.timeSinceLastSpawn);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("powered");
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.timeSinceLastSpawn = data.func_74762_e("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public boolean getPowered() {
        return this.powered;
    }

    public void setPowered(boolean power) {
        this.powered = power;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }
}

