/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.api.common.util.ITankAccess;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.ItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketGuiSettings;
import crazypants.enderio.machine.invpanel.PacketSetExtractionDisabled;
import crazypants.enderio.machine.invpanel.PacketStoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.PacketUpdateExtractionDisabled;
import crazypants.enderio.machine.invpanel.StoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.client.ClientDatabaseManager;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileInventoryPanel
extends AbstractMachineEntity
implements IFluidHandler,
ITankAccess,
IHasNutrientTank {
    public static final int SLOT_CRAFTING_START = 0;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final int SLOT_VIEW_FILTER = 10;
    public static final int SLOT_RETURN_START = 11;
    public static final int MAX_STORED_CRAFTING_RECIPES = 6;
    protected final SmartTank fuelTank = new SmartTank(EnderIO.fluidNutrientDistillation, Config.inventoryPanelFree ? 0 : 2000);
    protected boolean tanksDirty;
    private InventoryDatabaseServer dbServer;
    private InventoryDatabaseClient dbClient;
    private boolean active;
    private boolean extractionDisabled;
    public InventoryPanelContainer eventHandler;
    private IItemFilter itemFilter;
    private int guiSortMode;
    private String guiFilterString = "";
    private boolean guiSync;
    private final ArrayList<StoredCraftingRecipe> storedCraftingRecipes = new ArrayList();

    public TileInventoryPanel() {
        super(new SlotDefinition(0, 8, 11, 20, 21, 20));
    }

    public InventoryDatabaseServer getDatabaseServer() {
        return this.dbServer;
    }

    public InventoryDatabaseClient getDatabaseClient(int generation) {
        if (this.dbClient != null && this.dbClient.getGeneration() != generation) {
            ClientDatabaseManager.INSTANCE.destroyDatabase(this.dbClient.getGeneration());
            this.dbClient = null;
        }
        if (this.dbClient == null) {
            this.dbClient = ClientDatabaseManager.INSTANCE.getOrCreateDatabase(generation);
        }
        return this.dbClient;
    }

    public InventoryDatabaseClient getDatabaseClient() {
        return this.dbClient;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack var2, int side) {
        return false;
    }

    @Override
    protected boolean canExtractItem(int slot, ItemStack itemstack) {
        return !this.extractionDisabled && super.canExtractItem(slot, itemstack);
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 10 && stack != null) {
            return FilterRegister.isItemFilter(stack) && FilterRegister.isFilterSet(stack);
        }
        return true;
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (res != null && fromSlot < 9 && this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
        if (res != null && fromSlot == 10) {
            this.updateItemFilter();
        }
        return res;
    }

    @Override
    public void func_70299_a(int slot, ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (slot < 9 && this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
        if (slot == 10) {
            this.updateItemFilter();
        }
    }

    private void updateItemFilter() {
        this.itemFilter = FilterRegister.getFilterForUpgrade(this.inventory[10]);
    }

    public IItemFilter getItemFilter() {
        return this.itemFilter;
    }

    @Override
    public boolean isActive() {
        return Config.inventoryPanelFree || this.active;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.shouldDoWorkThisTick(20)) {
            this.scanNetwork();
        }
        if (this.forceClientUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        if (this.tanksDirty) {
            this.tanksDirty = false;
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
        }
    }

    private void scanNetwork() {
        TileConduitBundle teCB;
        ItemConduit conduit;
        ForgeDirection facingDir = this.getFacingDir();
        ForgeDirection backside = facingDir.getOpposite();
        ItemConduitNetwork icn = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + backside.offsetX, this.field_145848_d + backside.offsetY, this.field_145849_e + backside.offsetZ);
        if (te instanceof TileConduitBundle && (conduit = (teCB = (TileConduitBundle)te).getConduit(ItemConduit.class)) != null) {
            icn = (ItemConduitNetwork)conduit.getNetwork();
        }
        if (icn != null) {
            this.dbServer = icn.getDatabase();
            this.dbServer.sendChangeLogs();
            this.refuelPower(this.dbServer);
            if (this.active != this.dbServer.isOperational()) {
                this.active = this.dbServer.isOperational();
                this.forceClientUpdate = true;
            }
        } else {
            if (this.active) {
                this.forceClientUpdate = true;
            }
            this.dbServer = null;
            this.active = false;
        }
    }

    public float getAvailablePower() {
        return (float)this.getPower() * Config.inventoryPanelPowerPerMB;
    }

    public void refuelPower(InventoryDatabaseServer db) {
        float missingPower = Config.inventoryPanelPowerPerMB * 0.5f - db.getPower();
        if (missingPower > 0.0f) {
            int amount = (int)Math.ceil(missingPower / Config.inventoryPanelPowerPerMB);
            if ((amount = Math.min(amount, this.getPower())) > 0) {
                this.useNutrient(amount);
                this.dbServer.addPower((float)amount * Config.inventoryPanelPowerPerMB);
            }
        }
    }

    public void useNutrient(int amount) {
        this.fuelTank.drain(amount, true);
        this.tanksDirty = true;
    }

    private int getPower() {
        return Config.inventoryPanelFree ? 100 : this.fuelTank.getFluidAmount();
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        return false;
    }

    public int getGuiSortMode() {
        return this.guiSortMode;
    }

    public String getGuiFilterString() {
        return this.guiFilterString;
    }

    public boolean getGuiSync() {
        return this.guiSync;
    }

    public void setGuiParameter(int sortMode, String filterString, boolean sync) {
        this.guiSortMode = sortMode;
        this.guiFilterString = filterString;
        this.guiSync = sync;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGuiSettings(this, sortMode, filterString, sync));
        } else {
            this.func_70296_d();
        }
    }

    public int getStoredCraftingRecipes() {
        return this.storedCraftingRecipes.size();
    }

    public StoredCraftingRecipe getStoredCraftingRecipe(int index) {
        if (index < 0 || index >= this.storedCraftingRecipes.size()) {
            return null;
        }
        return this.storedCraftingRecipes.get(index);
    }

    public void addStoredCraftingRecipe(StoredCraftingRecipe recipe) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(0, 0, recipe));
        } else {
            this.storedCraftingRecipes.add(recipe);
            this.func_70296_d();
            this.updateBlock();
        }
    }

    public void removeStoredCraftingRecipe(int index) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(1, index, null));
        } else if (index >= 0 && index < this.storedCraftingRecipes.size()) {
            this.storedCraftingRecipes.remove(index);
            this.func_70296_d();
            this.updateBlock();
        }
    }

    public boolean isExtractionDisabled() {
        return this.extractionDisabled;
    }

    public void setExtractionDisabled(boolean extractionDisabled) {
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetExtractionDisabled(this, extractionDisabled));
            } else if (this.extractionDisabled != extractionDisabled) {
                this.extractionDisabled = extractionDisabled;
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpdateExtractionDisabled(this, extractionDisabled), this.field_145850_b.field_73011_w.field_76574_g);
            }
        }
    }

    void updateExtractionDisabled(boolean extractionDisabled) {
        this.extractionDisabled = extractionDisabled;
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.fuelTank.writeCommon("fuelTank", nbtRoot);
        nbtRoot.func_74768_a("guiSortMode", this.guiSortMode);
        nbtRoot.func_74778_a("guiFilterString", this.guiFilterString);
        nbtRoot.func_74757_a("guiSync", this.guiSync);
        nbtRoot.func_74757_a("extractionDisabled", this.extractionDisabled);
        if (!this.storedCraftingRecipes.isEmpty()) {
            NBTTagList recipesNBT = new NBTTagList();
            for (StoredCraftingRecipe recipe : this.storedCraftingRecipes) {
                NBTTagCompound recipeNBT = new NBTTagCompound();
                recipe.writeToNBT(recipeNBT);
                recipesNBT.func_74742_a((NBTBase)recipeNBT);
            }
            nbtRoot.func_74782_a("craftingRecipes", (NBTBase)recipesNBT);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.fuelTank.readCommon("fuelTank", nbtRoot);
        this.guiSortMode = nbtRoot.func_74762_e("guiSortMode");
        this.guiFilterString = nbtRoot.func_74779_i("guiFilterString");
        this.guiSync = nbtRoot.func_74767_n("guiSync");
        this.extractionDisabled = nbtRoot.func_74767_n("extractionDisabled");
        this.faceModes = null;
        this.storedCraftingRecipes.clear();
        NBTTagList recipesNBT = (NBTTagList)nbtRoot.func_74781_a("craftingRecipes");
        if (recipesNBT != null) {
            for (int idx = 0; idx < recipesNBT.func_74745_c() && this.storedCraftingRecipes.size() < 6; ++idx) {
                StoredCraftingRecipe recipe = new StoredCraftingRecipe();
                NBTTagCompound recipeNBT = recipesNBT.func_150305_b(idx);
                if (!recipe.readFromNBT(recipeNBT)) continue;
                this.storedCraftingRecipes.add(recipe);
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.checkCraftingRecipes();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.active = nbtRoot.func_74767_n("active");
        this.updateItemFilter();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.func_74757_a("active", this.active);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockInventoryPanel.unlocalisedName;
    }

    @Override
    public IoMode getIoMode(ForgeDirection face) {
        return face == this.getIODirection() ? IoMode.NONE : IoMode.DISABLED;
    }

    @Override
    public void setIoMode(ForgeDirection faceHit, IoMode mode) {
    }

    @Override
    public IoMode toggleIoModeForFace(ForgeDirection faceHit) {
        return this.getIoMode(faceHit);
    }

    private ForgeDirection getIODirection() {
        return this.getFacingDir().getOpposite();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != this.getIODirection()) {
            return 0;
        }
        int res = this.fuelTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == this.getIODirection() && this.fuelTank.canFill(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == this.getIODirection()) {
            return new FluidTankInfo[]{this.fuelTank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && this.fuelTank.canFill(forFluidType.getFluid())) {
            return this.fuelTank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.fuelTank;
    }
}

