/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import java.util.Collection;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.ServerUtilities;
import serverutils.data.ClaimedChunks;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.text_components.Notification;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageClaimedChunksModify
extends MessageToServer {
    public static final int CLAIM = 0;
    public static final int UNCLAIM = 1;
    public static final int LOAD = 2;
    public static final int UNLOAD = 3;
    private int startX;
    private int startZ;
    private int action;
    private Collection<ChunkCoordIntPair> chunks;

    public MessageClaimedChunksModify() {
    }

    public MessageClaimedChunksModify(int sx, int sz, int a, Collection<ChunkCoordIntPair> c) {
        this.startX = sx;
        this.startZ = sz;
        this.action = a;
        this.chunks = c;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.startX);
        data.writeVarInt(this.startZ);
        data.writeVarInt(this.action);
        data.writeCollection(this.chunks, DataOut.CHUNK_POS);
    }

    @Override
    public void readData(DataIn data) {
        this.startX = data.readVarInt();
        this.startZ = data.readVarInt();
        this.action = data.readVarInt();
        this.chunks = data.readCollection(null, DataIn.CHUNK_POS);
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ForgePlayer p = ClaimedChunks.instance.universe.getPlayer((ICommandSender)player);
        if (!p.hasTeam()) {
            Notification.of("no_team", ServerUtilities.lang("serverutilities.lang.team.error.no_team", new Object[0])).setError().send((EntityPlayer)player);
            return;
        }
        boolean jump = true;
        switch (this.action) {
            case 2: {
                jump = false;
            }
            case 0: {
                ChunkDimPos pos;
                for (ChunkCoordIntPair pair : this.chunks) {
                    pos = new ChunkDimPos(pair, player.field_71093_bK);
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "serverutilities.other_player.claims.claim")) continue;
                    ClaimedChunks.instance.claimChunk(p, pos);
                }
                if (jump) break;
                ClaimedChunks.instance.processQueue();
                for (ChunkCoordIntPair pair : this.chunks) {
                    pos = new ChunkDimPos(pair, player.field_71093_bK);
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "serverutilities.other_player.claims.load")) continue;
                    ClaimedChunks.instance.loadChunk(p, p.team, pos);
                }
                break;
            }
            case 1: {
                for (ChunkCoordIntPair pair : this.chunks) {
                    ChunkDimPos pos = new ChunkDimPos(pair, player.field_71093_bK);
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "serverutilities.other_player.claims.unclaim")) continue;
                    ClaimedChunks.instance.unclaimChunk(p, pos);
                }
                break;
            }
            case 3: {
                for (ChunkCoordIntPair pair : this.chunks) {
                    ChunkDimPos pos = new ChunkDimPos(pair, player.field_71093_bK);
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "serverutilities.other_player.claims.unload")) continue;
                    ClaimedChunks.instance.unloadChunk(p, pos);
                }
                break;
            }
        }
    }
}

