/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.IJsonSerializable;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Icon
implements IIcon,
IJsonSerializable {
    private final IDrawable drawable;
    private int width = 0;
    private int height = 0;
    private Alignment alignment = Alignment.Center;
    private final Box margin = new Box();
    private int color = 0;

    public Icon(IDrawable drawable) {
        this.drawable = drawable;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Box getMargin() {
        return this.margin;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        x += this.margin.left;
        y += this.margin.top;
        width -= this.margin.horizontal();
        height -= this.margin.vertical();
        if (this.width > 0) {
            x += (int)((float)width * this.alignment.x - (float)this.width * this.alignment.x);
            width = this.width;
        }
        if (this.height > 0) {
            y += (int)((float)height * this.alignment.y - (float)this.height * this.alignment.y);
            height = this.height;
        }
        if (this.color != 0 && this.color != widgetTheme.getColor()) {
            widgetTheme = widgetTheme.withColor(this.color);
        }
        this.drawable.draw(context, x, y, width, height, widgetTheme);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Icon width(int width) {
        this.width = Math.max(0, width);
        return this;
    }

    public Icon height(int height) {
        this.height = Math.max(0, height);
        return this;
    }

    public Icon size(int width, int height) {
        return this.width(width).height(height);
    }

    public Icon size(int size) {
        return this.width(size).height(size);
    }

    public Icon alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Icon center() {
        return this.alignment(Alignment.Center);
    }

    public Icon color(int color) {
        this.color = color;
        return this;
    }

    public Icon margin(int left, int right, int top, int bottom) {
        this.margin.all(left, right, top, bottom);
        return this;
    }

    public Icon margin(int horizontal, int vertical) {
        this.margin.all(horizontal, vertical);
        return this;
    }

    public Icon margin(int all) {
        this.margin.all(all);
        return this;
    }

    public Icon marginLeft(int val) {
        this.margin.left(val);
        return this;
    }

    public Icon marginRight(int val) {
        this.margin.right(val);
        return this;
    }

    public Icon marginTop(int val) {
        this.margin.top(val);
        return this;
    }

    public Icon marginBottom(int val) {
        this.margin.bottom(val);
        return this;
    }

    @Override
    public void loadFromJson(JsonObject json) {
        this.width = (json.has("autoWidth") || json.has("autoSize")) && JsonHelper.getBoolean(json, true, "autoWidth", "autoSize") ? 0 : JsonHelper.getInt(json, 0, "width", "w", "size");
        this.height = (json.has("autoHeight") || json.has("autoSize")) && JsonHelper.getBoolean(json, true, "autoHeight", "autoSize") ? 0 : JsonHelper.getInt(json, 0, "height", "h", "size");
        this.alignment = JsonHelper.deserialize(json, Alignment.class, Alignment.Center, "alignment", "align");
        this.margin.all(JsonHelper.getInt(json, 0, "margin"));
        if (json.has("marginHorizontal")) {
            this.margin.right = this.margin.left = json.get("marginHorizontal").getAsInt();
        }
        if (json.has("marginVertical")) {
            this.margin.bottom = this.margin.top = json.get("marginVertical").getAsInt();
        }
        this.margin.top = JsonHelper.getInt(json, this.margin.top, "marginTop");
        this.margin.bottom = JsonHelper.getInt(json, this.margin.bottom, "marginBottom");
        this.margin.left = JsonHelper.getInt(json, this.margin.left, "marginLeft");
        this.margin.right = JsonHelper.getInt(json, this.margin.right, "marginRight");
    }

    public static Icon ofJson(JsonObject json) {
        return JsonHelper.deserialize(json, IDrawable.class, IDrawable.EMPTY, "drawable", "icon").asIcon();
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        json.add("drawable", JsonHelper.serialize(this.drawable));
        json.addProperty("width", (Number)this.width);
        json.addProperty("height", (Number)this.height);
        json.add("alignment", JsonHelper.serialize(this.alignment));
        json.addProperty("marginTop", (Number)this.margin.top);
        json.addProperty("marginBottom", (Number)this.margin.bottom);
        json.addProperty("marginLeft", (Number)this.margin.left);
        json.addProperty("marginRight", (Number)this.margin.right);
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.drawable.getClass().getSimpleName() + ")";
    }
}

