/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.particleEngine;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.particle.EntityFX;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.reflect.FieldUtils;
import thaumcraft.client.fx.ParticleEngine;

public enum ParticleEngineFix {
    INSTANCE;

    private static final Field particlesField;

    public HashMap<Integer, ArrayList<EntityFX>>[] getParticles() {
        return this.getParticles(ParticleEngine.instance);
    }

    private HashMap<Integer, ArrayList<EntityFX>>[] getParticles(ParticleEngine instance) {
        try {
            return (HashMap[])particlesField.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onServerConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        for (HashMap<Integer, ArrayList<EntityFX>> map : this.getParticles()) {
            map.clear();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            return;
        }
        for (HashMap<Integer, ArrayList<EntityFX>> map : this.getParticles()) {
            ArrayList<EntityFX> list = map.get(event.world.field_73011_w.field_76574_g);
            if (list == null) continue;
            for (EntityFX e : list) {
                e.func_70029_a(event.world);
            }
        }
    }

    public static void init() {
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    static {
        particlesField = FieldUtils.getDeclaredField(ParticleEngine.class, (String)"particles", (boolean)true);
    }
}

