/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Items.ItemCarts;

public abstract class CartVersion {
    private static ArrayList<CartVersion> versions = new ArrayList();

    public CartVersion() {
        versions.add(this);
    }

    public abstract void update(ArrayList<Byte> var1);

    public static byte[] updateCart(MinecartModular cart, byte[] data) {
        if (cart.cartVersion != CartVersion.getCurrentVersion()) {
            data = CartVersion.updateArray(data, cart.cartVersion);
            cart.cartVersion = (byte)CartVersion.getCurrentVersion();
        }
        return data;
    }

    private static byte[] updateArray(byte[] data, int version) {
        ArrayList<Byte> modules = new ArrayList<Byte>();
        for (byte b : data) {
            modules.add(b);
        }
        while (version < CartVersion.getCurrentVersion()) {
            versions.get(version++).update(modules);
        }
        data = new byte[modules.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = modules.get(i);
        }
        return data;
    }

    public static void updateItemStack(ItemStack item) {
        byte version;
        NBTTagCompound info;
        if (item != null && item.func_77973_b() instanceof ItemCarts && (info = item.func_77978_p()) != null && (version = info.func_74771_c("CartVersion")) != CartVersion.getCurrentVersion()) {
            info.func_74773_a("Modules", CartVersion.updateArray(info.func_74770_j("Modules"), version));
            CartVersion.addVersion(info);
        }
    }

    public static void addVersion(ItemStack item) {
        NBTTagCompound info;
        if (item != null && item.func_77973_b() instanceof ItemCarts && (info = item.func_77978_p()) != null) {
            CartVersion.addVersion(info);
        }
    }

    private static void addVersion(NBTTagCompound info) {
        info.func_74774_a("CartVersion", (byte)CartVersion.getCurrentVersion());
    }

    private static int getCurrentVersion() {
        return versions.size();
    }

    static {
        new CartVersion(){

            @Override
            public void update(ArrayList<Byte> modules) {
                int index = modules.indexOf((byte)17);
                if (index != -1) {
                    modules.set(index, (byte)16);
                }
                if (modules.contains((byte)16)) {
                    modules.add((byte)64);
                }
            }
        };
        new CartVersion(){

            @Override
            public void update(ArrayList<Byte> modules) {
            }
        };
    }
}

