/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.render.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.common.items.ItemGolemWirelessBackpack;

@SideOnly(value=Side.CLIENT)
public class ModelGolemWifiBackpack
extends ModelBase {
    private final ModelRenderer Antenna;
    private final ModelRenderer PackBack;
    private final ModelRenderer PackFront;
    private final float pearl_MinU;
    private final float pearl_MaxU;
    private final float pearl_MinV;
    private final float pearl_MaxV;
    private final float pearlScale = 0.2f;
    private final float antennaWidth = 0.32f;
    private final float pearl_FaceDistance;
    private final float pearl_2FD;
    private boolean isPearlCompiled = false;
    private int pearlDispListID = -1;

    public ModelGolemWifiBackpack() {
        this.field_78090_t = 16;
        this.field_78089_u = 16;
        this.Antenna = new ModelRenderer((ModelBase)this, 10, 0);
        this.Antenna.func_78789_a(-0.5f, -6.0f, -0.5f, 1, 3, 1);
        this.Antenna.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Antenna.func_78787_b(this.field_78090_t, this.field_78089_u);
        this.Antenna.field_78809_i = true;
        this.setSubmodelRotation(this.Antenna, 3.14f, 0.0f, 0.0f);
        this.PackBack = new ModelRenderer((ModelBase)this, 0, 0);
        this.PackBack.func_78789_a(-1.0f, -3.0f, -3.0f, 2, 6, 6);
        this.PackBack.func_78793_a(0.0f, 0.0f, 0.0f);
        this.PackBack.func_78787_b(this.field_78090_t, this.field_78089_u);
        this.PackBack.field_78809_i = true;
        this.setSubmodelRotation(this.PackBack, 3.14f, 0.0f, 0.0f);
        this.PackFront = new ModelRenderer((ModelBase)this, 2, 0);
        this.PackFront.func_78789_a(-1.5f, -1.0f, -2.0f, 1, 2, 4);
        this.PackFront.func_78793_a(0.0f, 0.0f, 0.0f);
        this.PackFront.func_78787_b(this.field_78090_t, this.field_78089_u);
        this.PackFront.field_78809_i = true;
        this.setSubmodelRotation(this.PackFront, 3.14f, 0.0f, 0.0f);
        this.pearl_MinU = 8.0f / (float)this.field_78090_t;
        this.pearl_MaxU = 13.5f / (float)this.field_78090_t;
        this.pearl_MinV = 6.0f / (float)this.field_78089_u;
        this.pearl_MaxV = 11.5f / (float)this.field_78089_u;
        this.pearl_FaceDistance = -0.013f / this.pearlScale;
        this.pearl_2FD = this.pearl_FaceDistance + this.pearl_FaceDistance;
    }

    private void compilePearl() {
        this.pearlDispListID = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.pearlDispListID, (int)4864);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.0955f, (float)0.275f, (float)-0.045f);
        GL11.glScalef((float)this.pearlScale, (float)this.pearlScale, (float)this.pearlScale);
        this.drawPearlFaces(tess, this.pearl_MinU, this.pearl_MaxU);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.antennaWidth - this.pearl_2FD));
        this.drawPearlFaces(tess, this.pearl_MaxU, this.pearl_MinU);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-this.antennaWidth - this.pearl_FaceDistance), (float)0.0f, (float)(this.antennaWidth + this.pearl_FaceDistance));
        this.drawPearlFaces(tess, this.pearl_MaxU, this.pearl_MinU);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.antennaWidth - this.pearl_2FD));
        this.drawPearlFaces(tess, this.pearl_MinU, this.pearl_MaxU);
        GL11.glEndList();
        this.isPearlCompiled = true;
    }

    private void drawPearlFaces(Tessellator tess, float minU, float maxU) {
        tess.func_78382_b();
        tess.func_78374_a(0.0, 0.0, 0.0, (double)maxU, (double)this.pearl_MaxV);
        tess.func_78374_a(1.0, 0.0, 0.0, (double)minU, (double)this.pearl_MaxV);
        tess.func_78374_a(1.0, 1.0, 0.0, (double)minU, (double)this.pearl_MinV);
        tess.func_78374_a(0.0, 1.0, 0.0, (double)maxU, (double)this.pearl_MinV);
        tess.func_78374_a(0.0, 1.0, 0.0, (double)maxU, (double)this.pearl_MinV);
        tess.func_78374_a(1.0, 1.0, 0.0, (double)minU, (double)this.pearl_MinV);
        tess.func_78374_a(1.0, 0.0, 0.0, (double)minU, (double)this.pearl_MaxV);
        tess.func_78374_a(0.0, 0.0, 0.0, (double)maxU, (double)this.pearl_MaxV);
        tess.func_78381_a();
    }

    private void renderPearl(float pearlRotation, boolean inRange) {
        if (!inRange) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)pearlRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        if (!this.isPearlCompiled) {
            this.compilePearl();
        }
        GL11.glCallList((int)this.pearlDispListID);
    }

    private void setSubmodelRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.render(0.03f, f5, true, ItemGolemWirelessBackpack.BackpackSkins.Thaumium);
    }

    public void render(float pearlRotation, float f5, boolean inRange, ItemGolemWirelessBackpack.BackpackSkins skin) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(skin.getTextureLocation());
        this.PackBack.func_78785_a(f5);
        this.PackFront.func_78785_a(f5);
        this.Antenna.func_78785_a(f5);
        this.renderPearl(pearlRotation, inRange);
    }
}

