/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.items.equipment;

import baubles.api.BaubleType;
import baubles.api.expanded.BaubleItemHelper;
import baubles.api.expanded.IBaubleExpanded;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.compat.CompatBaublesExpanded;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.BaseItem;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemArmorElytra
extends BaseItem
implements IBaubleExpanded {
    private IIcon broken;

    public ItemArmorElytra() {
        super("elytra");
        this.func_77625_d(1);
        this.func_77656_e(432);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151030_Z));
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.func_77960_j() >= stack.func_77958_k();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151116_aA;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        ItemStack itemStack;
        if (ItemArmorElytra.getElytra((EntityLivingBase)playerIn) != null) {
            return itemStackIn;
        }
        if (ModsList.BAUBLES_EXPANDED.isLoaded() && ConfigModCompat.elytraBaublesExpandedCompat != 0) {
            itemStackIn = BaubleItemHelper.onBaubleRightClick((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn);
        }
        if (!(ModsList.BAUBLES_EXPANDED.isLoaded() && ConfigModCompat.elytraBaublesExpandedCompat == 2 || itemStackIn.field_77994_a <= 0 || ItemArmorElytra.getElytra((EntityLivingBase)playerIn) != null || (itemStack = playerIn.func_71124_b(3)) != null)) {
            playerIn.func_70062_b(3, itemStackIn.func_77946_l());
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemStackIn.field_77994_a = 0;
            }
            return itemStackIn;
        }
        return itemStackIn;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return (!ModsList.BAUBLES_EXPANDED.isLoaded() || ConfigModCompat.elytraBaublesExpandedCompat != 2) && armorType == 1 && entity instanceof EntityLivingBase && ItemArmorElytra.getElytra((EntityLivingBase)entity) == null;
    }

    public IIcon func_77617_a(int meta) {
        return meta >= this.func_77612_l() ? this.broken : super.func_77617_a(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.broken = reg.func_94245_a("broken_elytra");
    }

    public static ItemStack getElytra(EntityLivingBase entity) {
        ItemStack armorSlot;
        if ((!ModsList.BAUBLES_EXPANDED.isLoaded() || ConfigModCompat.elytraBaublesExpandedCompat != 2) && (armorSlot = entity.func_71124_b(3)) != null && armorSlot.func_77973_b() instanceof ItemArmorElytra) {
            return armorSlot;
        }
        if (ModsList.BAUBLES_EXPANDED.isLoaded() && ConfigModCompat.elytraBaublesExpandedCompat != 0) {
            return CompatBaublesExpanded.getElytraFromBaubles(entity);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean debug) {
        if (Utils.badBetterFPSAlgorithm()) {
            tooltip.add(I18n.func_135052_a((String)"efr.elytra.betterfps.warn1", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"efr.elytra.betterfps.warn2", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"efr.elytra.betterfps.warn3", (Object[])new Object[0]));
        } else if (ModsList.BAUBLES_EXPANDED.isLoaded()) {
            String[] slots;
            switch (ConfigModCompat.elytraBaublesExpandedCompat) {
                case 1: {
                    slots = new String[]{"chestplate", "wings"};
                    break;
                }
                case 2: {
                    slots = new String[]{"wings"};
                    break;
                }
                default: {
                    slots = new String[]{"chestplate"};
                }
            }
            BaubleItemHelper.addSlotInformation(tooltip, (String[])slots);
        }
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return null;
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    @Override
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        if (ConfigSounds.armorEquip) {
            player.field_70170_p.func_72956_a((Entity)player, "minecraft_1.21:item.armor.equip_elytra", 1.0f, 1.0f);
        }
    }

    @Override
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Override
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return ItemArmorElytra.getElytra(player) == null;
    }

    @Override
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public String[] getBaubleTypes(ItemStack itemstack) {
        if (ConfigModCompat.elytraBaublesExpandedCompat == 0) {
            return null;
        }
        return new String[]{"wings"};
    }
}

