/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.search.AbstractSearchExpressionVisitor;
import codechicken.nei.search.SearchExpressionParser;
import codechicken.nei.shadow.org.antlr.v4.runtime.ParserRuleContext;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.ParseTree;
import codechicken.nei.shadow.org.antlr.v4.runtime.tree.RuleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ItemFilterVisitor
extends AbstractSearchExpressionVisitor<ItemFilter> {
    private static final Pattern REGEX_ESCAPED_SPACE_PATTERN = Pattern.compile("([^\\\\](?:\\\\\\\\)+)?\\\\ ");
    private static final Pattern PLAIN_TEXT_ESCAPED_PATTERN = Pattern.compile("\\\\(.)");
    private static final Pattern ESCAPED_QUOTE_PATTERN = Pattern.compile("\\\\\"");
    private static final Pattern ESCAPED_SPACE_PATTERN = Pattern.compile("\\\\ ");

    public ItemFilterVisitor(SearchTokenParser searchParser) {
        super(searchParser);
    }

    @Override
    public ItemFilter visitChildren(RuleNode node) {
        if (node instanceof ParserRuleContext) {
            return this.visitChildren((ParserRuleContext)node, null);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitRecipeSearchExpression(SearchExpressionParser.RecipeSearchExpressionContext ctx) {
        if (ctx.recipeClauseExpression() != null) {
            ArrayList<ItemFilter> anyFilters = new ArrayList<ItemFilter>();
            ArrayList<ItemFilter> allFilters = new ArrayList<ItemFilter>();
            for (SearchExpressionParser.RecipeClauseExpressionContext clauseCtx : ctx.recipeClauseExpression()) {
                this.addIngredientPermutationItemFilter(clauseCtx.searchExpression(), anyFilters, allFilters);
            }
            return this.constructFilter(anyFilters, allFilters);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitOrExpression(SearchExpressionParser.OrExpressionContext ctx) {
        return this.visitChildren(ctx, ItemList.AnyMultiItemFilter::new);
    }

    @Override
    public ItemFilter visitSequenceExpression(SearchExpressionParser.SequenceExpressionContext ctx) {
        return this.visitChildren(ctx, ItemList.AllMultiItemFilter::new);
    }

    @Override
    public ItemFilter visitNegateExpression(SearchExpressionParser.NegateExpressionContext ctx) {
        return new ItemList.NegatedItemFilter(this.visitChildren(ctx));
    }

    @Override
    public ItemFilter visitPrefixedExpression(SearchExpressionParser.PrefixedExpressionContext ctx) {
        if (ctx.token() != null) {
            String cleanText = this.getTokenCleanText(ctx.token());
            SearchTokenParser.ISearchParserProvider provider = this.searchParser.getProvider(ctx.token().prefix.charValue());
            if (cleanText == null || provider == null) {
                return this.defaultResult();
            }
            return provider.getFilter(cleanText);
        }
        return this.defaultResult();
    }

    @Override
    public ItemFilter visitToken(SearchExpressionParser.TokenContext ctx) {
        String cleanText = this.getTokenCleanText(ctx);
        if (cleanText != null) {
            return this.getAlwaysProvidersFilter(cleanText);
        }
        return this.defaultResult();
    }

    @Override
    protected ItemFilter defaultResult() {
        return new ItemList.NothingItemFilter();
    }

    private void addIngredientPermutationItemFilter(SearchExpressionParser.SearchExpressionContext ctx, List<ItemFilter> anyFilters, List<ItemFilter> allFilters) {
        if (ctx.type == 0 || ctx.type == 3) {
            if (ctx.allRecipe) {
                allFilters.add((ItemFilter)this.visit(ctx));
            } else {
                anyFilters.add((ItemFilter)this.visit(ctx));
            }
        }
    }

    private ItemFilter constructFilter(List<ItemFilter> anyFilters, List<ItemFilter> allFilters) {
        if (anyFilters.isEmpty()) {
            return this.constructFilter(allFilters, ItemList.AllMultiItemFilter::new);
        }
        if (allFilters.isEmpty()) {
            return this.constructFilter(anyFilters, ItemList.AnyMultiItemFilter::new);
        }
        ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
        filters.add(this.constructFilter(allFilters, ItemList.AllMultiItemFilter::new));
        filters.add(this.constructFilter(anyFilters, ItemList.AnyMultiItemFilter::new));
        return this.constructFilter(filters, ItemList.AllMultiItemFilter::new);
    }

    private String getTokenCleanText(SearchExpressionParser.TokenContext ctx) {
        String cleanText = null;
        if (ctx.PLAIN_TEXT() != null) {
            cleanText = Pattern.quote(PLAIN_TEXT_ESCAPED_PATTERN.matcher(ctx.PLAIN_TEXT().getSymbol().getText()).replaceAll("$1"));
        } else if (ctx.regex() != null) {
            if (ctx.regex().REGEX_CONTENT() != null) {
                cleanText = ctx.regex().REGEX_CONTENT().getSymbol().getText();
                int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
                if (spaceModeEnabled == 1) {
                    cleanText = REGEX_ESCAPED_SPACE_PATTERN.matcher(cleanText).replaceAll("$1 ");
                }
            }
        } else if (ctx.quoted() != null && ctx.quoted().QUOTED_CONTENT() != null) {
            cleanText = ctx.quoted().QUOTED_CONTENT().getSymbol().getText();
            cleanText = ESCAPED_QUOTE_PATTERN.matcher(cleanText).replaceAll("\"");
            cleanText = Pattern.quote(cleanText);
            int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
            if (spaceModeEnabled == 1) {
                cleanText = ESCAPED_SPACE_PATTERN.matcher(cleanText).replaceAll(" ");
            }
        }
        return cleanText;
    }

    private ItemFilter visitChildren(ParserRuleContext node, Function<List<ItemFilter>, ItemFilter> filterConstructor) {
        if (node.children != null && !node.children.isEmpty()) {
            if (filterConstructor == null) {
                for (ParseTree child : node.children) {
                    if (!(child instanceof RuleNode)) continue;
                    return (ItemFilter)this.visit(child);
                }
                return this.defaultResult();
            }
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (ParseTree child : node.children) {
                if (!(child instanceof RuleNode)) continue;
                filters.add((ItemFilter)this.visit(child));
            }
            return this.constructFilter(filters, filterConstructor);
        }
        return this.defaultResult();
    }

    private ItemFilter getAlwaysProvidersFilter(String searchText) {
        List<ItemFilter> filters = this.searchParser.getAlwaysProvidersFilters(searchText);
        return this.constructFilter(filters, ItemList.AnyMultiItemFilter::new);
    }

    private ItemFilter constructFilter(List<ItemFilter> filters, Function<List<ItemFilter>, ItemFilter> constructor) {
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                return filters.get(0);
            }
            return constructor.apply(filters);
        }
        return this.defaultResult();
    }
}

