/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.util.NEIMouseUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiOverlayButton
extends GuiRecipeButton {
    protected static final DrawableResource ICON_FILL = new DrawableBuilder("nei:textures/nei_sprites.png", 28, 76, 9, 10).build();
    protected static final DrawableResource ICON_FILL_ERROR = new DrawableBuilder("nei:textures/nei_sprites.png", 37, 76, 9, 10).build();
    protected static final DrawableResource ICON_OVERLAY = new DrawableBuilder("nei:textures/nei_sprites.png", 46, 76, 9, 10).build();
    protected static final int BUTTON_ID_SHIFT = 4;
    public final GuiContainer firstGui;
    protected final List<ItemOverlayState> itemPresenceCache = new ArrayList<ItemOverlayState>();
    protected ItemsTooltipLineHandler missedMaterialsTooltipLineHandler;
    protected boolean requireShiftForOverlayRecipe = true;
    protected boolean canUseOverlayRenderer = false;
    protected boolean canFillCraftingGrid = false;
    protected boolean hasOverlay = false;

    public GuiOverlayButton(GuiContainer firstGui, RecipeHandlerRef handlerRef, int x, int y) {
        super(handlerRef, x, y, handlerRef.recipeIndex + 4, "+");
        this.firstGui = firstGui != null && firstGui.field_147002_h != null ? firstGui : null;
        this.canUseOverlayRenderer = this.firstGui != null && handlerRef.getRecipeOverlayRenderer(firstGui) != null;
        this.canFillCraftingGrid = this.firstGui != null && handlerRef.getOverlayHandler(firstGui) != null;
        this.hasOverlay = this.canUseOverlayRenderer || this.canFillCraftingGrid;
        this.setRequireShiftForOverlayRecipe(NEIClientConfig.requireShiftForOverlayRecipe());
        this.ingredientsOverlay();
    }

    @Override
    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip) {
        currenttip.add(NEIClientUtils.translate("recipe.overlay", new Object[0]));
        if (!this.field_146124_l && this.requireShiftForOverlayRecipe && this.canFillCraftingGrid) {
            currenttip.set(currenttip.size() - 1, currenttip.get(currenttip.size() - 1) + "\u00a7h");
            currenttip.add(EnumChatFormatting.RED + NEIClientUtils.translate("recipe.overlay.mismatch", new Object[0]) + EnumChatFormatting.RESET);
        } else if (this.missedMaterialsTooltipLineHandler != null) {
            if ((!this.requireShiftForOverlayRecipe || NEIClientUtils.shiftKey()) && this.canFillCraftingGrid) {
                this.missedMaterialsTooltipLineHandler.setLabelColor(EnumChatFormatting.RED);
            } else {
                this.missedMaterialsTooltipLineHandler.setLabelColor(EnumChatFormatting.GRAY);
            }
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.missedMaterialsTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        if (this.requireShiftForOverlayRecipe()) {
            if (this.useOverlayRenderer()) {
                hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("recipe.overlay.overlayRecipe", new Object[0]));
            }
            if (this.canFillCraftingGrid()) {
                hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0), NEIClientUtils.translate("recipe.overlay.fillCraftingGrid", new Object[0]));
            }
        } else if (this.canFillCraftingGrid()) {
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("recipe.overlay.fillCraftingGrid", new Object[0]));
        }
        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("recipe.overlay.bookmarkRecipe", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x6000000), NEIClientUtils.translate("recipe.overlay.bookmarkRecipeAndCount", new Object[0]));
        return hotkeys;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (this.firstGui != null) {
            this.firstGui.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
            this.overlayRecipe(NEIClientUtils.shiftKey());
        }
    }

    @Override
    protected void drawContent(Minecraft minecraft, int y, int x, boolean mouseOver) {
        DrawableResource icon = ICON_OVERLAY;
        if (this.hasOverlay && (!this.requireShiftForOverlayRecipe || NEIClientUtils.shiftKey())) {
            icon = this.missedMaterialsTooltipLineHandler == null ? ICON_FILL : ICON_FILL_ERROR;
        }
        int iconX = this.field_146128_h + (this.field_146120_f - icon.width - 1) / 2;
        int iconY = this.field_146129_i + (this.field_146121_g - icon.height) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_146124_l ? 1.0f : 0.5f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        icon.draw(iconX, iconY);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawItemOverlay() {
        int presenceOverlay = NEIClientConfig.itemPresenceOverlay();
        if (presenceOverlay > 0) {
            boolean highlightPresentItem = NEIClientConfig.isSlotHighlightPresent();
            ItemOverlayFormat format = ItemOverlayFormat.from(presenceOverlay);
            for (ItemOverlayState overlay : this.ingredientsOverlay()) {
                if (!highlightPresentItem && overlay.isPresent()) continue;
                overlay.draw(format);
            }
        }
    }

    protected List<ItemOverlayState> ingredientsOverlay() {
        List<PositionedStack> ingredients = this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex);
        if (this.itemPresenceCache.size() != ingredients.size()) {
            this.itemPresenceCache.clear();
            if (this.canFillCraftingGrid) {
                this.itemPresenceCache.addAll(this.handlerRef.getPresenceOverlay(this.firstGui));
            } else if (this.firstGui != null) {
                this.itemPresenceCache.addAll(this.presenceOverlay(ingredients));
            }
            List<ItemStack> items = this.itemPresenceCache.stream().filter(state -> !state.isPresent()).map(state -> state.getSlot().item).collect(Collectors.toList());
            this.missedMaterialsTooltipLineHandler = !items.isEmpty() ? new ItemsTooltipLineHandler(NEIClientUtils.translate("recipe.overlay.missing", new Object[0]), items, true, Integer.MAX_VALUE) : null;
        }
        return this.itemPresenceCache;
    }

    public void setRequireShiftForOverlayRecipe(boolean require) {
        this.requireShiftForOverlayRecipe = require;
        this.field_146124_l = this.hasOverlay && (this.requireShiftForOverlayRecipe || this.canFillCraftingGrid);
    }

    public void setCanUseOverlayRenderer(boolean use) {
        this.canUseOverlayRenderer = use;
    }

    public boolean useOverlayRenderer() {
        return this.canUseOverlayRenderer;
    }

    public boolean requireShiftForOverlayRecipe() {
        return this.requireShiftForOverlayRecipe;
    }

    public boolean canFillCraftingGrid() {
        return this.missedMaterialsTooltipLineHandler == null || this.handlerRef.canFillCraftingGrid(this.firstGui);
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public Recipe getRecipe() {
        return Recipe.of(this.handlerRef);
    }

    private List<ItemOverlayState> presenceOverlay(List<PositionedStack> ingredients) {
        ArrayList<ItemOverlayState> itemPresenceSlots = new ArrayList<ItemOverlayState>();
        List invStacks = this.firstGui.field_147002_h.field_75151_b.stream().filter(s -> s != null && s.func_75211_c() != null && s.func_75211_c().field_77994_a > 0 && s.func_75214_a(s.func_75211_c()) && s.func_82869_a((EntityPlayer)this.firstGui.field_146297_k.field_71439_g)).map(s -> s.func_75211_c().func_77946_l()).collect(Collectors.toCollection(ArrayList::new));
        for (PositionedStack stack : ingredients) {
            Optional<ItemStack> used = invStacks.stream().filter(is -> is.field_77994_a > 0 && stack.contains((ItemStack)is)).findAny();
            itemPresenceSlots.add(new ItemOverlayState(stack, used.isPresent()));
            if (!used.isPresent()) continue;
            ItemStack is2 = used.get();
            --is2.field_77994_a;
        }
        return itemPresenceSlots;
    }

    public void overlayRecipe(boolean shift) {
        if (!this.hasOverlay) {
            return;
        }
        if (!this.requireShiftForOverlayRecipe || shift) {
            if (this.canFillCraftingGrid()) {
                this.handlerRef.fillCraftingGrid(this.firstGui, 0);
            }
        } else if (this.useOverlayRenderer()) {
            this.handlerRef.useOverlayRenderer(this.firstGui);
        }
    }

    @Override
    public void lastKeyTyped(GuiRecipe<?> gui, char keyChar, int keyID) {
        if (NEIClientConfig.isKeyHashDown("gui.bookmark") && NEIClientUtils.shiftKey()) {
            this.saveRecipeInBookmark();
        }
    }

    public void saveRecipeInBookmark() {
        Recipe recipe = this.getRecipe();
        if (!ItemPanels.bookmarkPanel.removeRecipe(recipe.getRecipeId(), 0)) {
            ItemPanels.bookmarkPanel.addRecipe(recipe, NEIClientUtils.controlKey() ? 1 : 0, 0);
        }
    }

    public static enum ItemOverlayFormat {
        BACKGROUND,
        ICON;


        public static ItemOverlayFormat from(int overlay) {
            return overlay == 2 ? BACKGROUND : ICON;
        }
    }

    public static class ItemOverlayState {
        protected PositionedStack slot;
        protected boolean isPresent;

        public ItemOverlayState(PositionedStack slot, boolean isPresent) {
            this.slot = slot;
            this.isPresent = isPresent;
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public PositionedStack getSlot() {
            return this.slot;
        }

        public void draw(ItemOverlayFormat format) {
            LayoutManager.drawItemPresenceOverlay(this.slot.relx, this.slot.rely, this.isPresent, format == ItemOverlayFormat.BACKGROUND);
        }
    }
}

