/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.asm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtils {
    public static boolean findInsns(MethodNode method, InsnPredicate[] matchers, InsnConsumer consumer) {
        if (matchers.length == 0) {
            return false;
        }
        AbstractInsnNode current = method.instructions.getFirst();
        ArrayList<AbstractInsnNode> contents = new ArrayList<AbstractInsnNode>();
        boolean foundAnything = false;
        while (current != null) {
            AbstractInsnNode cursor;
            int i = 0;
            contents.clear();
            for (cursor = current; cursor != null && i < matchers.length; cursor = cursor.getNext()) {
                if (cursor.getOpcode() != -1) {
                    if (!matchers[i].test(method, cursor)) break;
                    ++i;
                }
                contents.add(cursor);
            }
            if (i == matchers.length) {
                AbstractInsnNode first = current;
                current = cursor.getNext();
                consumer.consume(first, cursor, contents);
                foundAnything = true;
                continue;
            }
            current = current.getNext();
        }
        return foundAnything;
    }

    public static boolean injectInsns(MethodNode method, InsnPredicate[] matchers, Supplier<AbstractInsnNode[]> toInject) {
        return ASMUtils.findInsns(method, matchers, (first, last, nodes) -> {
            AbstractInsnNode[] inject;
            for (AbstractInsnNode node : inject = (AbstractInsnNode[])toInject.get()) {
                method.instructions.insert(last, node);
                last = node;
            }
        });
    }

    public static boolean removeInsns(MethodNode method, InsnPredicate ... matchers) {
        return ASMUtils.findInsns(method, matchers, (first, last, nodes) -> ASMUtils.removeInsns(method, nodes));
    }

    public static void removeInsns(MethodNode method, List<AbstractInsnNode> nodes) {
        for (AbstractInsnNode node : nodes) {
            ASMUtils.removeInsn(method, node);
        }
    }

    public static void removeInsns(MethodNode method, AbstractInsnNode start, AbstractInsnNode end) {
        while (start != end) {
            AbstractInsnNode next = start.getNext();
            ASMUtils.removeInsn(method, start);
            start = next;
        }
    }

    public static void removeInsn(MethodNode method, AbstractInsnNode node) {
        method.instructions.remove(node);
        if (node instanceof LabelNode) {
            LabelNode label = (LabelNode)node;
            Iterator iter = method.tryCatchBlocks.iterator();
            while (iter.hasNext()) {
                if (((TryCatchBlockNode)iter.next()).start != label) continue;
                iter.remove();
            }
        }
    }

    public static MethodNode findMethod(List<MethodNode> methods, int access, String name, String desc) {
        for (MethodNode method : methods) {
            if ((method.access & access) != access || name != null && !Objects.equals(method.name, name) || desc != null && !Objects.equals(method.desc, desc)) continue;
            return method;
        }
        return null;
    }

    public static <T extends AbstractInsnNode> T findInsn(MethodNode method, AbstractInsnNode start, InsnPredicate matcher) {
        while (start != null) {
            if (matcher.test(method, start)) {
                return (T)start;
            }
            start = start.getNext();
        }
        return null;
    }

    public static InsnPredicate isAny() {
        return (method, node) -> true;
    }

    public static InsnPredicate isGetStatic(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() != 178) return false;
            if (!(insn instanceof FieldInsnNode)) return false;
            FieldInsnNode node = (FieldInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name == null) return true;
            if (!name.equals(node.name)) return false;
            return true;
        };
    }

    public static InsnPredicate isPutStatic(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() != 179) return false;
            if (!(insn instanceof FieldInsnNode)) return false;
            FieldInsnNode node = (FieldInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name == null) return true;
            if (!name.equals(node.name)) return false;
            return true;
        };
    }

    public static InsnPredicate isGetVar(@javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() == 25 && insn instanceof VarInsnNode) {
                VarInsnNode node = (VarInsnNode)insn;
                LocalVariableNode var = ASMUtils.getVariableNode(method.localVariables, node.var);
                return !(var == null || desc != null && !desc.equals(var.desc) || name != null && !name.equals(var.name));
            }
            return false;
        };
    }

    public static InsnPredicate isStoreVar(@javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() == 58 && insn instanceof VarInsnNode) {
                VarInsnNode node = (VarInsnNode)insn;
                LocalVariableNode var = ASMUtils.getVariableNode(method.localVariables, node.var);
                return !(var == null || desc != null && !desc.equals(var.desc) || name != null && !name.equals(var.name));
            }
            return false;
        };
    }

    public static InsnPredicate isInvokeStatic(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() != 184) return false;
            if (!(insn instanceof MethodInsnNode)) return false;
            MethodInsnNode node = (MethodInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name != null) {
                if (!name.equals(node.name)) return false;
            }
            if (node.itf) return false;
            return true;
        };
    }

    public static InsnPredicate isInvokeInterface(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() != 185) return false;
            if (!(insn instanceof MethodInsnNode)) return false;
            MethodInsnNode node = (MethodInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name != null) {
                if (!name.equals(node.name)) return false;
            }
            if (!node.itf) return false;
            return true;
        };
    }

    public static InsnPredicate isInvokeSpecial(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (insn.getOpcode() != 183) return false;
            if (!(insn instanceof MethodInsnNode)) return false;
            MethodInsnNode node = (MethodInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name == null) return true;
            if (!name.equals(node.name)) return false;
            return true;
        };
    }

    public static InsnPredicate isInvoke(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc, @javax.annotation.Nullable String name) {
        return (method, insn) -> {
            if (!(insn instanceof MethodInsnNode)) return false;
            MethodInsnNode node = (MethodInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (name == null) return true;
            if (!name.equals(node.name)) return false;
            return true;
        };
    }

    public static InsnPredicate isNew(@javax.annotation.Nullable String desc) {
        return (method, insn) -> {
            if (insn.getOpcode() != 187) return false;
            if (!(insn instanceof TypeInsnNode)) return false;
            TypeInsnNode node = (TypeInsnNode)insn;
            if (desc == null) return true;
            if (!desc.equals(node.desc)) return false;
            return true;
        };
    }

    public static InsnPredicate isInit(@javax.annotation.Nullable String owner, @javax.annotation.Nullable String desc) {
        return (method, insn) -> {
            if (insn.getOpcode() != 183) return false;
            if (!(insn instanceof MethodInsnNode)) return false;
            MethodInsnNode node = (MethodInsnNode)insn;
            if (owner != null) {
                if (!owner.equals(node.owner)) return false;
            }
            if (!node.name.equals("<init>")) return false;
            if (desc != null) {
                if (!desc.equals(node.desc)) return false;
            }
            if (node.itf) return false;
            return true;
        };
    }

    public static InsnPredicate isIf(LabelNode label) {
        return (method, insn) -> {
            if (insn.getOpcode() != 153) return false;
            if (!(insn instanceof JumpInsnNode)) return false;
            JumpInsnNode node = (JumpInsnNode)insn;
            if (label == null) return true;
            if (!label.equals(node.label)) return false;
            return true;
        };
    }

    public static InsnPredicate isBasic(int opcode) {
        return (method, insn) -> insn.getOpcode() == opcode;
    }

    public static InsnPredicate isLDC(@Nullable Object cst) {
        return (method, insn) -> {
            if (insn.getOpcode() != 18) return false;
            if (!(insn instanceof LdcInsnNode)) return false;
            LdcInsnNode node = (LdcInsnNode)insn;
            if (cst == null) return true;
            if (!cst.equals(node.cst)) return false;
            return true;
        };
    }

    public static InsnPredicate isLoadInt(Integer value) {
        return (method, node) -> ASMUtils.getLoadedInt(node) != null;
    }

    public static InsnPredicate isLineNumber(@Nullable Integer line) {
        return (method, node) -> {
            if (!(node instanceof LineNumberNode)) return false;
            LineNumberNode lnn = (LineNumberNode)node;
            if (line == null) return true;
            if (line != lnn.line) return false;
            return true;
        };
    }

    public static Integer getLoadedInt(AbstractInsnNode insn) {
        IntInsnNode intNode;
        if (insn instanceof InsnNode) {
            Integer n;
            InsnNode basic = (InsnNode)insn;
            switch (basic.getOpcode()) {
                case 3: {
                    n = 0;
                    break;
                }
                case 4: {
                    n = 1;
                    break;
                }
                case 5: {
                    n = 2;
                    break;
                }
                case 6: {
                    n = 3;
                    break;
                }
                case 7: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 5;
                    break;
                }
                default: {
                    n = null;
                }
            }
            return n;
        }
        if (insn instanceof IntInsnNode && (intNode = (IntInsnNode)insn).getOpcode() == 16) {
            return intNode.operand;
        }
        return null;
    }

    public static AbstractInsnNode getIntConstInsn(int value) {
        InsnNode insnNode;
        switch (value) {
            case 0: {
                insnNode = new InsnNode(3);
                break;
            }
            case 1: {
                insnNode = new InsnNode(4);
                break;
            }
            case 2: {
                insnNode = new InsnNode(5);
                break;
            }
            case 3: {
                insnNode = new InsnNode(6);
                break;
            }
            case 4: {
                insnNode = new InsnNode(7);
                break;
            }
            case 5: {
                insnNode = new InsnNode(8);
                break;
            }
            default: {
                insnNode = new LdcInsnNode((Object)value);
            }
        }
        return insnNode;
    }

    @javax.annotation.Nullable
    public static LocalVariableNode getVariableNode(@javax.annotation.Nullable List<LocalVariableNode> vars, int index) {
        if (vars == null) {
            return null;
        }
        for (LocalVariableNode var : vars) {
            if (var.index != index) continue;
            return var;
        }
        return null;
    }

    public static void debug(LocalVariableNode var) {
        System.out.format("LocalVariableNode{name=%s, desc=%s, signature=%s, index=%s}\n", var.name, var.desc, var.signature, var.index);
    }

    public static void debug(AbstractInsnNode insn, @javax.annotation.Nullable List<LocalVariableNode> vars) {
        if (insn instanceof MethodInsnNode) {
            MethodInsnNode method = (MethodInsnNode)insn;
            System.out.format("MethodInsnNode{opcode=%s, owner=%s, name=%s, desc=%s, itf=%b}\n", ASMUtils.getOpcodeName(method.getOpcode()), method.owner, method.name, method.desc, method.itf);
        } else if (insn instanceof FieldInsnNode) {
            FieldInsnNode field = (FieldInsnNode)insn;
            System.out.format("FieldInsnNode{opcode=%s, owner=%s, name=%s, desc=%s}\n", ASMUtils.getOpcodeName(field.getOpcode()), field.owner, field.name, field.desc);
        } else if (insn instanceof TypeInsnNode) {
            TypeInsnNode type = (TypeInsnNode)insn;
            System.out.format("TypeInsnNode{opcode=%s, desc=%s}\n", ASMUtils.getOpcodeName(type.getOpcode()), type.desc);
        } else if (insn instanceof LdcInsnNode) {
            LdcInsnNode ldc = (LdcInsnNode)insn;
            System.out.format("LdcInsnNode{opcode=%s, cst=%s}\n", ASMUtils.getOpcodeName(ldc.getOpcode()), ldc.cst);
        } else if (insn instanceof VarInsnNode) {
            VarInsnNode var = (VarInsnNode)insn;
            if (vars == null) {
                System.out.format("VarInsnNode{opcode=%s, var index=%s, var name=%s}\n", ASMUtils.getOpcodeName(var.getOpcode()), var.var);
            } else {
                LocalVariableNode vnode = ASMUtils.getVariableNode(vars, var.var);
                if (vnode == null) {
                    System.out.format("VarInsnNode{opcode=%s, var index=%s, name=unknown}\n", ASMUtils.getOpcodeName(var.getOpcode()), var.var);
                } else {
                    System.out.format("VarInsnNode{opcode=%s, var index=%s, name=%s, desc=%s, signature=%s}\n", ASMUtils.getOpcodeName(var.getOpcode()), var.var, vnode.name, vnode.desc, vnode.signature);
                }
            }
        } else if (insn instanceof InsnNode) {
            InsnNode insnNode = (InsnNode)insn;
            System.out.format("InsnNode{opcode=%s}\n", ASMUtils.getOpcodeName(insnNode.getOpcode()));
        } else if (insn instanceof LabelNode) {
            LabelNode label = (LabelNode)insn;
            System.out.format("LabelNode{label=%s}\n", label.getLabel());
        } else if (insn instanceof LineNumberNode) {
            LineNumberNode ln = (LineNumberNode)insn;
            System.out.format("LineNumberNode{start=%s, line=%d}\n", ln.start.getLabel(), ln.line);
        } else if (insn instanceof FrameNode) {
            String string;
            LabelNode uninit;
            String ref;
            Integer primitive;
            FrameNode frame = (FrameNode)insn;
            ArrayList<String> locals = new ArrayList<String>();
            for (int i = 0; i < (frame.local == null ? 0 : frame.local.size()); ++i) {
                String varName = vars == null ? "[unknown]" : (i >= vars.size() ? "[illegal var index]" : vars.get((int)i).name);
                Object local = frame.local.get(i);
                if (local instanceof Integer) {
                    String string2;
                    primitive = (Integer)local;
                    StringBuilder stringBuilder = new StringBuilder().append(varName).append(": ");
                    switch (primitive) {
                        case 0: {
                            string2 = "ITEM_TOP";
                            break;
                        }
                        case 1: {
                            string2 = "ITEM_INTEGER";
                            break;
                        }
                        case 2: {
                            string2 = "ITEM_FLOAT";
                            break;
                        }
                        case 3: {
                            string2 = "ITEM_DOUBLE";
                            break;
                        }
                        case 4: {
                            string2 = "ITEM_LONG";
                            break;
                        }
                        case 5: {
                            string2 = "ITEM_NULL";
                            break;
                        }
                        case 6: {
                            string2 = "ITEM_UNINITIALIZED_THIS";
                            break;
                        }
                        case 7: {
                            string2 = "ITEM_OBJECT";
                            break;
                        }
                        case 8: {
                            string2 = "ITEM_UNINITIALIZED";
                            break;
                        }
                        case 9: {
                            string2 = "ITEM_ASM_BOOLEAN";
                            break;
                        }
                        case 10: {
                            string2 = "ITEM_ASM_BYTE";
                            break;
                        }
                        case 11: {
                            string2 = "ITEM_ASM_CHAR";
                            break;
                        }
                        case 12: {
                            string2 = "ITEM_ASM_SHORT";
                            break;
                        }
                        default: {
                            string2 = "[ILLEGAL TYPE]";
                        }
                    }
                    locals.add(stringBuilder.append(string2).toString());
                    continue;
                }
                if (local instanceof String) {
                    ref = (String)local;
                    locals.add(varName + ": " + ref);
                    continue;
                }
                if (local instanceof LabelNode) {
                    uninit = (LabelNode)local;
                    locals.add(varName + ": uninit until label " + uninit.getLabel());
                    continue;
                }
                locals.add(varName + ": " + local);
            }
            ArrayList stack = new ArrayList();
            for (int i = 0; i < (frame.stack == null ? 0 : frame.stack.size()); ++i) {
                Object stackValue = frame.stack.get(i);
                if (stackValue instanceof Integer) {
                    String string3;
                    primitive = (Integer)stackValue;
                    StringBuilder stringBuilder = new StringBuilder().append(i).append(": ");
                    switch (primitive) {
                        case 0: {
                            string3 = "ITEM_TOP";
                            break;
                        }
                        case 1: {
                            string3 = "ITEM_INTEGER";
                            break;
                        }
                        case 2: {
                            string3 = "ITEM_FLOAT";
                            break;
                        }
                        case 3: {
                            string3 = "ITEM_DOUBLE";
                            break;
                        }
                        case 4: {
                            string3 = "ITEM_LONG";
                            break;
                        }
                        case 5: {
                            string3 = "ITEM_NULL";
                            break;
                        }
                        case 6: {
                            string3 = "ITEM_UNINITIALIZED_THIS";
                            break;
                        }
                        case 7: {
                            string3 = "ITEM_OBJECT";
                            break;
                        }
                        case 8: {
                            string3 = "ITEM_UNINITIALIZED";
                            break;
                        }
                        case 9: {
                            string3 = "ITEM_ASM_BOOLEAN";
                            break;
                        }
                        case 10: {
                            string3 = "ITEM_ASM_BYTE";
                            break;
                        }
                        case 11: {
                            string3 = "ITEM_ASM_CHAR";
                            break;
                        }
                        case 12: {
                            string3 = "ITEM_ASM_SHORT";
                            break;
                        }
                        default: {
                            string3 = "[ILLEGAL TYPE]";
                        }
                    }
                    locals.add(stringBuilder.append(string3).toString());
                    continue;
                }
                if (stackValue instanceof String) {
                    ref = (String)stackValue;
                    locals.add(i + ": " + ref);
                    continue;
                }
                if (stackValue instanceof LabelNode) {
                    uninit = (LabelNode)stackValue;
                    locals.add(i + ": uninit until label w/ offset " + uninit.getLabel().getOffset());
                    continue;
                }
                locals.add(i + ": " + stackValue);
            }
            Object[] objectArray = new Object[3];
            switch (frame.type) {
                case -1: {
                    string = "F_NEW";
                    break;
                }
                case 0: {
                    string = "F_FULL";
                    break;
                }
                case 1: {
                    string = "F_APPEND";
                    break;
                }
                case 2: {
                    string = "F_CHOP";
                    break;
                }
                case 3: {
                    string = "F_SAME";
                    break;
                }
                case 4: {
                    string = "F_SAME1";
                    break;
                }
                default: {
                    string = "[INVALID]";
                }
            }
            objectArray[0] = string;
            objectArray[1] = String.join((CharSequence)", ", locals);
            objectArray[2] = String.join((CharSequence)", ", stack);
            System.out.format("FrameNode{type=%s, locals={%s}, stack={%s}}\n", objectArray);
        } else if (insn instanceof JumpInsnNode) {
            JumpInsnNode jump = (JumpInsnNode)insn;
            System.out.format("JumpInsnNode{opcode=%s, label=%s}\n", ASMUtils.getOpcodeName(insn.getOpcode()), jump.label);
        } else {
            String string;
            switch (insn.getType()) {
                case 0: {
                    string = "INSN";
                    break;
                }
                case 1: {
                    string = "INT_INSN";
                    break;
                }
                case 2: {
                    string = "VAR_INSN";
                    break;
                }
                case 3: {
                    string = "TYPE_INSN";
                    break;
                }
                case 4: {
                    string = "FIELD_INSN";
                    break;
                }
                case 5: {
                    string = "METHOD_INSN";
                    break;
                }
                case 6: {
                    string = "INVOKE_DYNAMIC_INSN";
                    break;
                }
                case 7: {
                    string = "JUMP_INSN";
                    break;
                }
                case 9: {
                    string = "LDC_INSN";
                    break;
                }
                case 10: {
                    string = "IINC_INSN";
                    break;
                }
                case 11: {
                    string = "TABLESWITCH_INSN";
                    break;
                }
                case 12: {
                    string = "LOOKUPSWITCH_INSN";
                    break;
                }
                case 13: {
                    string = "MULTIANEWARRAY_INSN";
                    break;
                }
                case 14: {
                    string = "FRAME";
                    break;
                }
                case 15: {
                    string = "LINE";
                    break;
                }
                default: {
                    string = "AbstractInsnNode";
                }
            }
            String insnName = string;
            System.out.format("%s{opcode=%s, ...}\n", insnName, ASMUtils.getOpcodeName(insn.getOpcode()));
        }
    }

    public static void debug(String prefix, InsnList insns, @javax.annotation.Nullable List<LocalVariableNode> vars) {
        for (AbstractInsnNode insn : insns.toArray()) {
            System.out.print(prefix);
            ASMUtils.debug(insn, vars);
        }
    }

    public static String getOpcodeName(int opcode) {
        String string;
        switch (opcode) {
            case 0: {
                string = "NOP";
                break;
            }
            case 1: {
                string = "ACONST_NULL";
                break;
            }
            case 2: {
                string = "ICONST_M1";
                break;
            }
            case 3: {
                string = "ICONST_0";
                break;
            }
            case 4: {
                string = "ICONST_1";
                break;
            }
            case 5: {
                string = "ICONST_2";
                break;
            }
            case 6: {
                string = "ICONST_3";
                break;
            }
            case 7: {
                string = "ICONST_4";
                break;
            }
            case 8: {
                string = "ICONST_5";
                break;
            }
            case 9: {
                string = "LCONST_0";
                break;
            }
            case 10: {
                string = "LCONST_1";
                break;
            }
            case 11: {
                string = "FCONST_0";
                break;
            }
            case 12: {
                string = "FCONST_1";
                break;
            }
            case 13: {
                string = "FCONST_2";
                break;
            }
            case 14: {
                string = "DCONST_0";
                break;
            }
            case 15: {
                string = "DCONST_1";
                break;
            }
            case 16: {
                string = "BIPUSH";
                break;
            }
            case 17: {
                string = "SIPUSH";
                break;
            }
            case 18: {
                string = "LDC";
                break;
            }
            case 21: {
                string = "ILOAD";
                break;
            }
            case 22: {
                string = "LLOAD";
                break;
            }
            case 23: {
                string = "FLOAD";
                break;
            }
            case 24: {
                string = "DLOAD";
                break;
            }
            case 25: {
                string = "ALOAD";
                break;
            }
            case 46: {
                string = "IALOAD";
                break;
            }
            case 47: {
                string = "LALOAD";
                break;
            }
            case 48: {
                string = "FALOAD";
                break;
            }
            case 49: {
                string = "DALOAD";
                break;
            }
            case 50: {
                string = "AALOAD";
                break;
            }
            case 51: {
                string = "BALOAD";
                break;
            }
            case 52: {
                string = "CALOAD";
                break;
            }
            case 53: {
                string = "SALOAD";
                break;
            }
            case 54: {
                string = "ISTORE";
                break;
            }
            case 55: {
                string = "LSTORE";
                break;
            }
            case 56: {
                string = "FSTORE";
                break;
            }
            case 57: {
                string = "DSTORE";
                break;
            }
            case 58: {
                string = "ASTORE";
                break;
            }
            case 79: {
                string = "IASTORE";
                break;
            }
            case 80: {
                string = "LASTORE";
                break;
            }
            case 81: {
                string = "FASTORE";
                break;
            }
            case 82: {
                string = "DASTORE";
                break;
            }
            case 83: {
                string = "AASTORE";
                break;
            }
            case 84: {
                string = "BASTORE";
                break;
            }
            case 85: {
                string = "CASTORE";
                break;
            }
            case 86: {
                string = "SASTORE";
                break;
            }
            case 87: {
                string = "POP";
                break;
            }
            case 88: {
                string = "POP2";
                break;
            }
            case 89: {
                string = "DUP";
                break;
            }
            case 90: {
                string = "DUP_X1";
                break;
            }
            case 91: {
                string = "DUP_X2";
                break;
            }
            case 92: {
                string = "DUP2";
                break;
            }
            case 93: {
                string = "DUP2_X1";
                break;
            }
            case 94: {
                string = "DUP2_X2";
                break;
            }
            case 95: {
                string = "SWAP";
                break;
            }
            case 96: {
                string = "IADD";
                break;
            }
            case 97: {
                string = "LADD";
                break;
            }
            case 98: {
                string = "FADD";
                break;
            }
            case 99: {
                string = "DADD";
                break;
            }
            case 100: {
                string = "ISUB";
                break;
            }
            case 101: {
                string = "LSUB";
                break;
            }
            case 102: {
                string = "FSUB";
                break;
            }
            case 103: {
                string = "DSUB";
                break;
            }
            case 104: {
                string = "IMUL";
                break;
            }
            case 105: {
                string = "LMUL";
                break;
            }
            case 106: {
                string = "FMUL";
                break;
            }
            case 107: {
                string = "DMUL";
                break;
            }
            case 108: {
                string = "IDIV";
                break;
            }
            case 109: {
                string = "LDIV";
                break;
            }
            case 110: {
                string = "FDIV";
                break;
            }
            case 111: {
                string = "DDIV";
                break;
            }
            case 112: {
                string = "IREM";
                break;
            }
            case 113: {
                string = "LREM";
                break;
            }
            case 114: {
                string = "FREM";
                break;
            }
            case 115: {
                string = "DREM";
                break;
            }
            case 116: {
                string = "INEG";
                break;
            }
            case 117: {
                string = "LNEG";
                break;
            }
            case 118: {
                string = "FNEG";
                break;
            }
            case 119: {
                string = "DNEG";
                break;
            }
            case 120: {
                string = "ISHL";
                break;
            }
            case 121: {
                string = "LSHL";
                break;
            }
            case 122: {
                string = "ISHR";
                break;
            }
            case 123: {
                string = "LSHR";
                break;
            }
            case 124: {
                string = "IUSHR";
                break;
            }
            case 125: {
                string = "LUSHR";
                break;
            }
            case 126: {
                string = "IAND";
                break;
            }
            case 127: {
                string = "LAND";
                break;
            }
            case 128: {
                string = "IOR";
                break;
            }
            case 129: {
                string = "LOR";
                break;
            }
            case 130: {
                string = "IXOR";
                break;
            }
            case 131: {
                string = "LXOR";
                break;
            }
            case 132: {
                string = "IINC";
                break;
            }
            case 133: {
                string = "I2L";
                break;
            }
            case 134: {
                string = "I2F";
                break;
            }
            case 135: {
                string = "I2D";
                break;
            }
            case 136: {
                string = "L2I";
                break;
            }
            case 137: {
                string = "L2F";
                break;
            }
            case 138: {
                string = "L2D";
                break;
            }
            case 139: {
                string = "F2I";
                break;
            }
            case 140: {
                string = "F2L";
                break;
            }
            case 141: {
                string = "F2D";
                break;
            }
            case 142: {
                string = "D2I";
                break;
            }
            case 143: {
                string = "D2L";
                break;
            }
            case 144: {
                string = "D2F";
                break;
            }
            case 145: {
                string = "I2B";
                break;
            }
            case 146: {
                string = "I2C";
                break;
            }
            case 147: {
                string = "I2S";
                break;
            }
            case 148: {
                string = "LCMP";
                break;
            }
            case 149: {
                string = "FCMPL";
                break;
            }
            case 150: {
                string = "FCMPG";
                break;
            }
            case 151: {
                string = "DCMPL";
                break;
            }
            case 152: {
                string = "DCMPG";
                break;
            }
            case 153: {
                string = "IFEQ";
                break;
            }
            case 154: {
                string = "IFNE";
                break;
            }
            case 155: {
                string = "IFLT";
                break;
            }
            case 156: {
                string = "IFGE";
                break;
            }
            case 157: {
                string = "IFGT";
                break;
            }
            case 158: {
                string = "IFLE";
                break;
            }
            case 159: {
                string = "IF_ICMPEQ";
                break;
            }
            case 160: {
                string = "IF_ICMPNE";
                break;
            }
            case 161: {
                string = "IF_ICMPLT";
                break;
            }
            case 162: {
                string = "IF_ICMPGE";
                break;
            }
            case 163: {
                string = "IF_ICMPGT";
                break;
            }
            case 164: {
                string = "IF_ICMPLE";
                break;
            }
            case 165: {
                string = "IF_ACMPEQ";
                break;
            }
            case 166: {
                string = "IF_ACMPNE";
                break;
            }
            case 167: {
                string = "GOTO";
                break;
            }
            case 168: {
                string = "JSR";
                break;
            }
            case 169: {
                string = "RET";
                break;
            }
            case 170: {
                string = "TABLESWITCH";
                break;
            }
            case 171: {
                string = "LOOKUPSWITCH";
                break;
            }
            case 172: {
                string = "IRETURN";
                break;
            }
            case 173: {
                string = "LRETURN";
                break;
            }
            case 174: {
                string = "FRETURN";
                break;
            }
            case 175: {
                string = "DRETURN";
                break;
            }
            case 176: {
                string = "ARETURN";
                break;
            }
            case 177: {
                string = "RETURN";
                break;
            }
            case 178: {
                string = "GETSTATIC";
                break;
            }
            case 179: {
                string = "PUTSTATIC";
                break;
            }
            case 180: {
                string = "GETFIELD";
                break;
            }
            case 181: {
                string = "PUTFIELD";
                break;
            }
            case 182: {
                string = "INVOKEVIRTUAL";
                break;
            }
            case 183: {
                string = "INVOKESPECIAL";
                break;
            }
            case 184: {
                string = "INVOKESTATIC";
                break;
            }
            case 185: {
                string = "INVOKEINTERFACE";
                break;
            }
            case 186: {
                string = "INVOKEDYNAMIC";
                break;
            }
            case 187: {
                string = "NEW";
                break;
            }
            case 188: {
                string = "NEWARRAY";
                break;
            }
            case 189: {
                string = "ANEWARRAY";
                break;
            }
            case 190: {
                string = "ARRAYLENGTH";
                break;
            }
            case 191: {
                string = "ATHROW";
                break;
            }
            case 192: {
                string = "CHECKCAST";
                break;
            }
            case 193: {
                string = "INSTANCEOF";
                break;
            }
            case 194: {
                string = "MONITORENTER";
                break;
            }
            case 195: {
                string = "MONITOREXIT";
                break;
            }
            case 197: {
                string = "MULTIANEWARRAY";
                break;
            }
            case 198: {
                string = "IFNULL";
                break;
            }
            case 199: {
                string = "IFNONNULL";
                break;
            }
            default: {
                string = Integer.toString(opcode);
            }
        }
        return string;
    }

    @FunctionalInterface
    public static interface InsnPredicate {
        public boolean test(MethodNode var1, AbstractInsnNode var2);
    }

    public static interface InsnConsumer {
        public void consume(AbstractInsnNode var1, AbstractInsnNode var2, List<AbstractInsnNode> var3);
    }
}

