/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.world;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DVertex;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAlpha;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IColorizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IThroughVisibility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class Triangle3D
extends Widget
implements IAlpha,
IColorizable,
IThroughVisibility,
I3DVertex {
    float[] x = new float[3];
    float[] y = new float[3];
    float[] z = new float[3];
    float alpha = 0.5f;
    float r;
    float g;
    float b;
    boolean isThroughVisibility = true;

    @Override
    public void writeData(ByteBuf buff) {
        buff.writeFloat(this.x[0]);
        buff.writeFloat(this.x[1]);
        buff.writeFloat(this.x[2]);
        buff.writeFloat(this.y[0]);
        buff.writeFloat(this.y[1]);
        buff.writeFloat(this.y[2]);
        buff.writeFloat(this.z[0]);
        buff.writeFloat(this.z[1]);
        buff.writeFloat(this.z[2]);
        buff.writeFloat(this.alpha);
        buff.writeFloat(this.r);
        buff.writeFloat(this.g);
        buff.writeFloat(this.b);
        buff.writeBoolean(this.isThroughVisibility);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.x[0] = buff.readFloat();
        this.x[1] = buff.readFloat();
        this.x[2] = buff.readFloat();
        this.y[0] = buff.readFloat();
        this.y[1] = buff.readFloat();
        this.y[2] = buff.readFloat();
        this.z[0] = buff.readFloat();
        this.z[1] = buff.readFloat();
        this.z[2] = buff.readFloat();
        this.alpha = buff.readFloat();
        this.r = buff.readFloat();
        this.g = buff.readFloat();
        this.b = buff.readFloat();
        this.isThroughVisibility = buff.readBoolean();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.TRIANGLE3D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderTriangle3D();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = (float)alpha;
    }

    @Override
    public void setColor(double d, double e, double f) {
        this.r = (float)d;
        this.g = (float)e;
        this.b = (float)f;
    }

    @Override
    public float getColorR() {
        return this.r;
    }

    @Override
    public float getColorG() {
        return this.g;
    }

    @Override
    public float getColorB() {
        return this.b;
    }

    @Override
    public boolean isVisibleThroughObjects() {
        return this.isThroughVisibility;
    }

    @Override
    public void setVisibleThroughObjects(boolean visible) {
        this.isThroughVisibility = visible;
    }

    @Override
    public int getVertexCount() {
        return this.x.length;
    }

    @Override
    public void setVertex(int n, double x, double y, double z) {
        this.x[n] = (float)x;
        this.y[n] = (float)y;
        this.z[n] = (float)z;
    }

    @SideOnly(value=Side.CLIENT)
    class RenderTriangle3D
    implements IRenderableWidget {
        RenderTriangle3D() {
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            GL11.glPushMatrix();
            if (Triangle3D.this.isThroughVisibility) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)3553);
            GL11.glBegin((int)5);
            GL11.glColor4f((float)Triangle3D.this.r, (float)Triangle3D.this.g, (float)Triangle3D.this.b, (float)Triangle3D.this.alpha);
            GL11.glVertex3f((float)Triangle3D.this.x[0], (float)Triangle3D.this.y[0], (float)Triangle3D.this.z[0]);
            GL11.glVertex3f((float)Triangle3D.this.x[1], (float)Triangle3D.this.y[1], (float)Triangle3D.this.z[1]);
            GL11.glVertex3f((float)Triangle3D.this.x[2], (float)Triangle3D.this.y[2], (float)Triangle3D.this.z[2]);
            GL11.glVertex3f((float)Triangle3D.this.x[0], (float)Triangle3D.this.y[0], (float)Triangle3D.this.z[0]);
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3553);
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.WorldLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return Triangle3D.this.isVisible();
        }
    }
}

