/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.tuples;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPPosition {
    private double xPos;
    private double yPos;
    private double zPos;

    public LPPosition(double xPos, double yPos, double zPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    public LPPosition(int xPos, int yPos, int zPos) {
        this((double)xPos, (double)yPos, (double)zPos);
    }

    public LPPosition(TileEntity tile) {
        this((double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e);
    }

    public LPPosition(CoreUnroutedPipe pipe) {
        this((double)pipe.getX(), (double)pipe.getY(), (double)pipe.getZ());
    }

    public LPPosition(IPipeInformationProvider pipe) {
        this((double)pipe.getX(), (double)pipe.getY(), (double)pipe.getZ());
    }

    public LPPosition(CoordinatesPacket packet) {
        this((double)packet.getPosX(), (double)packet.getPosY(), (double)packet.getPosZ());
    }

    public LPPosition(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public int getX() {
        return (int)this.xPos;
    }

    public int getY() {
        return (int)this.yPos;
    }

    public int getZ() {
        return (int)this.zPos;
    }

    public double getXD() {
        return this.xPos;
    }

    public double getYD() {
        return this.yPos;
    }

    public double getZD() {
        return this.zPos;
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.getX(), this.getY(), this.getZ());
    }

    public LPPosition moveForward(ForgeDirection dir, double steps) {
        switch (dir) {
            case UP: {
                this.yPos += steps;
                break;
            }
            case DOWN: {
                this.yPos -= steps;
                break;
            }
            case NORTH: {
                this.zPos -= steps;
                break;
            }
            case SOUTH: {
                this.zPos += steps;
                break;
            }
            case EAST: {
                this.xPos += steps;
                break;
            }
            case WEST: {
                this.xPos -= steps;
                break;
            }
        }
        return this;
    }

    public LPPosition moveForward(ForgeDirection dir) {
        return this.moveForward(dir, 1.0);
    }

    public String toString() {
        return "(" + this.xPos + ", " + this.yPos + ", " + this.zPos + ")";
    }

    public String toIntBasedString() {
        return "(" + this.xPos + ", " + this.yPos + ", " + this.zPos + ")";
    }

    public LPPosition copy() {
        return new LPPosition(this.xPos, this.yPos, this.zPos);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.getX(), this.getY(), this.getZ());
    }

    public boolean blockExists(World world) {
        return world.func_72899_e(this.getX(), this.getY(), this.getZ());
    }

    public double distanceTo(LPPosition targetPos) {
        return Math.sqrt(Math.pow(targetPos.xPos - this.xPos, 2.0) + Math.pow(targetPos.yPos - this.yPos, 2.0) + Math.pow(targetPos.zPos - this.zPos, 2.0));
    }

    public LPPosition center() {
        this.xPos += 0.5;
        this.yPos += 0.5;
        this.zPos += 0.5;
        return this;
    }

    public LPPosition reset(double x, double y, double z) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        return this;
    }

    public void writeToNBT(String prefix, NBTTagCompound nbt) {
        nbt.func_74780_a(prefix + "xPos", this.xPos);
        nbt.func_74780_a(prefix + "yPos", this.yPos);
        nbt.func_74780_a(prefix + "zPos", this.zPos);
    }

    public static LPPosition readFromNBT(String prefix, NBTTagCompound nbt) {
        if (nbt.func_74764_b(prefix + "xPos") && nbt.func_74764_b(prefix + "yPos") && nbt.func_74764_b(prefix + "zPos")) {
            return new LPPosition(nbt.func_74769_h(prefix + "xPos"), nbt.func_74769_h(prefix + "yPos"), nbt.func_74769_h(prefix + "zPos"));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LPPosition)) {
            return false;
        }
        LPPosition other = (LPPosition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.xPos, other.xPos) != 0) {
            return false;
        }
        if (Double.compare(this.yPos, other.yPos) != 0) {
            return false;
        }
        return Double.compare(this.zPos, other.zPos) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LPPosition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $xPos = Double.doubleToLongBits(this.xPos);
        result = result * 59 + (int)($xPos >>> 32 ^ $xPos);
        long $yPos = Double.doubleToLongBits(this.yPos);
        result = result * 59 + (int)($yPos >>> 32 ^ $yPos);
        long $zPos = Double.doubleToLongBits(this.zPos);
        result = result * 59 + (int)($zPos >>> 32 ^ $zPos);
        return result;
    }
}

