/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.inventory.slot;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import de.eydamos.backpack.inventory.InventoryCraftingGrid;
import de.eydamos.backpack.inventory.container.ContainerWorkbenchBackpack;
import de.eydamos.backpack.util.BackpackUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class SlotCraftingAdvanced
extends SlotCrafting {
    protected final InventoryCraftingGrid craftingGrid;
    protected final IInventory backpackInventory;
    protected final ContainerWorkbenchBackpack eventHandler;
    protected final World worldObj;
    protected boolean realResult = false;

    public SlotCraftingAdvanced(EntityPlayer player, ContainerWorkbenchBackpack container, int slotIndex, int xPosition, int yPosition, IInventory[] inventories) {
        super(player, inventories[2], container.craftResult, slotIndex, xPosition, yPosition);
        this.craftingGrid = (InventoryCraftingGrid)inventories[2];
        this.backpackInventory = inventories[1];
        this.eventHandler = container;
        this.worldObj = player.field_70170_p;
    }

    public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
        ArrayList<ItemStack> currentRecipe = this.getRecipeIngredients();
        FMLCommonHandler.instance().firePlayerCraftingEvent(entityPlayer, itemStack, (IInventory)this.craftingGrid);
        this.func_75208_c(itemStack);
        for (ItemStack ingredient : currentRecipe) {
            for (int j = 0; j < this.backpackInventory.func_70302_i_(); ++j) {
                ItemStack containerItem;
                ItemStack itemstack = this.backpackInventory.func_70301_a(j);
                if (itemstack == null || !BackpackUtil.areStacksEqual(ingredient, itemstack)) continue;
                ingredient.field_77994_a -= this.backpackInventory.func_70298_a((int)j, (int)ingredient.field_77994_a).field_77994_a;
                if (itemstack.func_77973_b().hasContainerItem(itemstack) && (containerItem = itemstack.func_77973_b().getContainerItem(itemstack)) != null) {
                    if (containerItem.func_77984_f() && containerItem.func_77960_j() > containerItem.func_77958_k()) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(entityPlayer, containerItem));
                        containerItem = null;
                    }
                    if (containerItem != null) {
                        if (this.backpackInventory.func_70301_a(j) == null) {
                            this.backpackInventory.func_70299_a(j, containerItem);
                        } else if (!this.mergeItemStack(containerItem, this.backpackInventory) && !entityPlayer.field_71071_by.func_70441_a(containerItem)) {
                            entityPlayer.func_70099_a(containerItem, 0.0f);
                        }
                    }
                }
                if (ingredient.field_77994_a == 0) break;
            }
            int slot = 0;
            while (ingredient.field_77994_a != 0 && (slot = this.findAlternative(ingredient, slot)) >= 0) {
                ingredient.field_77994_a -= this.backpackInventory.func_70298_a((int)slot, (int)ingredient.field_77994_a).field_77994_a;
            }
        }
        this.eventHandler.func_75130_a((IInventory)this.craftingGrid);
    }

    public ItemStack getCraftingResult() {
        this.craftingGrid.setUseInventoryMode(true);
        ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftingGrid, this.worldObj);
        this.craftingGrid.setUseInventoryMode(false);
        return result;
    }

    protected int findAlternative(ItemStack original) {
        return this.findAlternative(original, 0);
    }

    protected int findAlternative(ItemStack original, int startingSlot) {
        for (int i = startingSlot; i < this.backpackInventory.func_70302_i_(); ++i) {
            ItemStack alternative = this.backpackInventory.func_70301_a(i);
            if (alternative == null || !BackpackUtil.areStacksEqual(original, alternative, true)) continue;
            return i;
        }
        return -1;
    }

    public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
        ArrayList<ItemStack> currentRecipe = this.getRecipeIngredients();
        Iterator<ItemStack> recipeIterator = currentRecipe.iterator();
        block0: while (recipeIterator.hasNext()) {
            ItemStack recipeStack = recipeIterator.next();
            for (int i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
                ItemStack backpackStack = this.backpackInventory.func_70301_a(i);
                if (!BackpackUtil.areStacksEqual(recipeStack, backpackStack, true)) continue;
                recipeStack.field_77994_a -= backpackStack.field_77994_a;
                if (recipeStack.field_77994_a > 0) continue;
                recipeIterator.remove();
                continue block0;
            }
        }
        return currentRecipe.isEmpty();
    }

    protected ArrayList<ItemStack> getRecipeIngredients() {
        ArrayList<ItemStack> currentRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.craftingGrid.func_70302_i_(); ++i) {
            boolean add = true;
            ItemStack recipeStack = this.craftingGrid.func_70301_a(i);
            if (recipeStack == null) continue;
            for (ItemStack stack : currentRecipe) {
                if (!stack.func_77969_a(recipeStack)) continue;
                ++stack.field_77994_a;
                add = false;
                break;
            }
            if (!add) continue;
            ItemStack ingredient = recipeStack.func_77946_l();
            ingredient.field_77994_a = 1;
            currentRecipe.add(ingredient);
        }
        return currentRecipe;
    }

    protected boolean mergeItemStack(ItemStack sourceStack, IInventory inventory) {
        ItemStack slotStack;
        boolean result = false;
        if (sourceStack.func_77985_e()) {
            for (int currentSlotIndex = 0; sourceStack.field_77994_a > 0 && currentSlotIndex < inventory.func_70302_i_(); ++currentSlotIndex) {
                slotStack = inventory.func_70301_a(currentSlotIndex);
                if (slotStack == null || slotStack.func_77973_b() != sourceStack.func_77973_b() || sourceStack.func_77981_g() && sourceStack.func_77960_j() != slotStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)sourceStack, (ItemStack)slotStack)) continue;
                int l = slotStack.field_77994_a + sourceStack.field_77994_a;
                if (l <= sourceStack.func_77976_d()) {
                    sourceStack.field_77994_a = 0;
                    slotStack.field_77994_a = l;
                    inventory.func_70296_d();
                    result = true;
                    continue;
                }
                if (slotStack.field_77994_a >= sourceStack.func_77976_d()) continue;
                sourceStack.field_77994_a -= sourceStack.func_77976_d() - slotStack.field_77994_a;
                slotStack.field_77994_a = sourceStack.func_77976_d();
                inventory.func_70296_d();
                result = true;
            }
        }
        if (sourceStack.field_77994_a > 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                slotStack = inventory.func_70301_a(i);
                if (slotStack != null) continue;
                inventory.func_70299_a(i, sourceStack.func_77946_l());
                sourceStack.field_77994_a = 0;
                result = true;
                break;
            }
        }
        return result;
    }
}

