/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.ItemType;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BoundPickaxe
extends ItemPickaxe
implements IBindable {
    public float field_77864_a = 12.0f;
    public float field_77865_bY;
    public int rightClickCost = 10000;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int energyUsed;

    public BoundPickaxe() {
        super(AlchemicalWizardry.bloodBoundToolMaterial);
        this.field_77777_bU = 1;
        this.field_77864_a = 12.0f;
        this.field_77865_bY = 5.0f;
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.setEnergyUsed(5);
        this.setHarvestLevel("pickaxe", 7);
    }

    public void setEnergyUsed(int i) {
        this.energyUsed = i;
    }

    public int getEnergyUsed() {
        return this.energyUsed;
    }

    @Override
    public int drainCost() {
        return this.energyUsed;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.boundpickaxe.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.boundpickaxe.desc2"));
        this.addBindingInformation(par1ItemStack, par3List);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:BoundPickaxe_activated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundPickaxe_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (IBindable.isActive(stack)) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.checkRightClick(par1ItemStack, par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)par3EntityPlayer);
        int posX = (int)blockVec.field_72450_a;
        int posY = (int)blockVec.field_72448_b;
        int posZ = (int)blockVec.field_72449_c;
        boolean silkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)par3EntityPlayer);
        int fortuneLvl = EnchantmentHelper.func_77517_e((EntityLivingBase)par3EntityPlayer);
        HashMultiset dropMultiset = HashMultiset.create();
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                for (int k = -5; k <= 5; ++k) {
                    float str;
                    Block block = par2World.func_147439_a(posX + i, posY + j, posZ + k);
                    int meta = par2World.func_72805_g(posX + i, posY + j, posZ + k);
                    if (block == null || block.func_149712_f(par2World, posX + i, posY + j, posZ + k) == -1.0f || !((str = this.func_150893_a(par1ItemStack, block)) > 1.1f) || !par2World.func_72962_a(par3EntityPlayer, posX + i, posY + j, posZ + k)) continue;
                    if (silkTouch && block.canSilkHarvest(par2World, par3EntityPlayer, posX + i, posY + j, posZ + k, meta)) {
                        dropMultiset.add((Object)new ItemType(block, meta));
                    } else {
                        ArrayList itemDropList = block.getDrops(par2World, posX + i, posY + j, posZ + k, meta, fortuneLvl);
                        if (itemDropList != null) {
                            for (ItemStack stack : itemDropList) {
                                dropMultiset.add((Object)ItemType.fromStack(stack), stack.field_77994_a);
                            }
                        }
                    }
                    par2World.func_147468_f(posX + i, posY + j, posZ + k);
                }
            }
        }
        BoundPickaxe.dropMultisetStacks((Multiset<ItemType>)dropMultiset, par2World, posX, (float)posY + par3EntityPlayer.func_70047_e(), posZ);
        return par1ItemStack;
    }

    public static void dropMultisetStacks(Multiset<ItemType> dropMultiset, World world, double x, double y, double z) {
        for (Multiset.Entry entry : dropMultiset.entrySet()) {
            int count;
            ItemType type = (ItemType)entry.getElement();
            int maxStackSize = type.item.getItemStackLimit(type.createStack(1));
            for (count = entry.getCount(); count >= maxStackSize; count -= maxStackSize) {
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, type.createStack(maxStackSize)));
            }
            if (count <= 0) continue;
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, type.createStack(count)));
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        this.checkPassiveDrain(par1ItemStack, par2World, par3EntityPlayer);
        par1ItemStack.func_77964_b(0);
    }

    public float func_150893_a(ItemStack par1ItemStack, Block par2Block) {
        if (!IBindable.isActive(par1ItemStack)) {
            return 0.0f;
        }
        return super.func_150893_a(par1ItemStack, par2Block);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return IBindable.isActive(par1ItemStack);
    }

    public boolean func_150894_a(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLivingBase) {
        if (par7EntityLivingBase instanceof EntityPlayer) {
            EnergyItems.syphonBatteries(par1ItemStack, (EntityPlayer)par7EntityLivingBase, this.drainCost());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 30;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!IBindable.isActive(stack)) {
            return 0.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.field_77864_a;
        }
        return this.func_150893_a(stack, block);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !IBindable.isActive(stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return IBindable.isActive(stack) ? super.getHarvestLevel(stack, toolClass) : -1;
    }

    @Override
    public boolean isBoundTool() {
        return true;
    }

    @Override
    public int rightClickCost() {
        return this.rightClickCost;
    }
}

