/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.AELog;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.FCBaseItemCell;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSuperStockReplenisher
extends AENetworkInvTile
implements IAEFluidInventory,
IFluidHandler,
IPowerChannelState,
IGridTickable {
    private final AppEngInternalInventory cell = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final AppEngInternalInventory invItems = new AppEngInternalInventory((IAEAppEngInventory)this, 63);
    private final AEFluidInventory invFluids = new AEFluidInventory((IAEFluidInventory)this, 9, Integer.MAX_VALUE);
    private final AppEngInternalAEInventory configFluids = new AppEngInternalAEInventory((IAEAppEngInventory)this, 9);
    private final AppEngInternalAEInventory configItems = new AppEngInternalAEInventory((IAEAppEngInventory)this, 63);
    private final BaseActionSource source;
    private boolean isPowered;
    private long totalBytes;
    private long storedFluidCount;
    private long storedItemCount;

    public TileSuperStockReplenisher() {
        this.getProxy().setIdlePowerUsage(4.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
        this.invItems.setMaxStackSize(Integer.MAX_VALUE);
    }

    private TickRateModulation doWork() {
        int i;
        for (i = 0; i < 9; ++i) {
            IAEFluidStack invFluid = this.invFluids.getFluidInSlot(i);
            IAEItemStack configFluid = this.configFluids.getAEStackInSlot(i);
            if (configFluid != null) {
                AEFluidStack fs = AEFluidStack.create((Object)ItemFluidPacket.getFluidStack(configFluid));
                if (invFluid == null) {
                    this.requestFluid((IAEFluidStack)fs, i);
                    continue;
                }
                if (invFluid.equals(fs)) {
                    long confSize;
                    long invSize = invFluid.getStackSize();
                    if ((float)invSize < (float)(confSize = fs.getStackSize()) / 2.0f) {
                        fs.setStackSize(confSize - invSize);
                        this.requestFluid((IAEFluidStack)fs, i);
                        continue;
                    }
                    if (invSize <= confSize) continue;
                    this.returnFluid(i, invSize - confSize);
                    continue;
                }
                this.returnFluid(i, Long.MAX_VALUE);
                continue;
            }
            if (invFluid == null) continue;
            this.returnFluid(i, Long.MAX_VALUE);
        }
        for (i = 0; i < 63; ++i) {
            ItemStack invItem = this.invItems.func_70301_a(i);
            IAEItemStack configItem = this.configItems.getAEStackInSlot(i);
            if (configItem != null) {
                IAEItemStack is = configItem.copy();
                if (invItem == null) {
                    this.requestItem(is, i);
                    continue;
                }
                if (is.equals(invItem)) {
                    int confSize = (int)is.getStackSize();
                    if ((float)invItem.field_77994_a < (float)confSize / 2.0f) {
                        is.setStackSize((long)(confSize - invItem.field_77994_a));
                        this.requestItem(is, i);
                        continue;
                    }
                    if (invItem.field_77994_a <= confSize) continue;
                    this.returnItem(i, invItem.field_77994_a - confSize);
                    continue;
                }
                this.returnItem(i, Integer.MAX_VALUE);
                continue;
            }
            if (invItem == null) continue;
            this.returnItem(i, Integer.MAX_VALUE);
        }
        return TickRateModulation.SAME;
    }

    private void returnFluid(int index, long amount) {
        try {
            IAEFluidStack ias = this.invFluids.drain(index, amount, true);
            this.storedFluidCount -= ias.getStackSize();
            IAEFluidStack notInserted = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().injectItems((IAEStack)ias, Actionable.MODULATE, this.source);
            if (notInserted != null) {
                this.invFluids.fill(index, notInserted, true);
                this.storedFluidCount += notInserted.getStackSize();
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void requestFluid(IAEFluidStack fs, int index) {
        if (this.getRemainingFluidCount() == 0L) {
            return;
        }
        try {
            IAEFluidStack extracted;
            long remFluid = this.getRemainingFluidCount();
            if (fs.getStackSize() > remFluid) {
                fs.setStackSize(remFluid);
            }
            if ((extracted = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().extractItems((IAEStack)fs, Actionable.MODULATE, this.source)) != null) {
                this.storedFluidCount += extracted.getStackSize();
                this.invFluids.fill(index, extracted, true);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void returnItem(int index, int amount) {
        try {
            ItemStack is = this.invItems.func_70301_a(index);
            if (amount != Integer.MAX_VALUE) {
                is.field_77994_a -= amount;
                is = is.func_77946_l();
                is.field_77994_a = amount;
                this.storedItemCount -= (long)is.field_77994_a;
            } else {
                this.invItems.func_70299_a(index, null);
            }
            IAEItemStack notInserted = (IAEItemStack)this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)AEItemStack.create((ItemStack)is), Actionable.MODULATE, this.source);
            if (notInserted != null) {
                ItemStack tempStack = this.invItems.func_70301_a(index);
                if (tempStack != null) {
                    tempStack.field_77994_a += (int)notInserted.getStackSize();
                    this.storedItemCount += notInserted.getStackSize();
                } else {
                    this.invItems.func_70299_a(index, notInserted.getItemStack());
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void requestItem(IAEItemStack is, int index) {
        if (this.getRemainingItemCount() == 0L) {
            return;
        }
        try {
            IAEItemStack extracted;
            long remItem = this.getRemainingItemCount();
            if (is.getStackSize() > remItem) {
                is.setStackSize(remItem);
            }
            if ((extracted = (IAEItemStack)this.getProxy().getStorage().getItemInventory().extractItems((IAEStack)is, Actionable.MODULATE, this.source)) != null) {
                ItemStack tempStack = this.invItems.func_70301_a(index);
                if (tempStack != null) {
                    tempStack.field_77994_a += (int)extracted.getStackSize();
                    this.storedItemCount += extracted.getStackSize();
                } else {
                    this.invItems.func_70299_a(index, extracted.getItemStack());
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return IntStream.rangeClosed(0, 62).toArray();
    }

    @Nonnull
    public IInventory getInternalInventory() {
        return this.invItems;
    }

    public AppEngInternalAEInventory getConfigFluid() {
        return this.configFluids;
    }

    public AppEngInternalAEInventory getConfigItems() {
        return this.configItems;
    }

    public AppEngInternalInventory getCell() {
        return this.cell;
    }

    public long getFreeBytes() {
        return this.totalBytes - ((this.storedItemCount + (long)this.getUnusedItemCount()) / 8L + (this.storedFluidCount + (long)this.getUnusedFluidCount()) / 2048L);
    }

    public long getRemainingFluidCount() {
        double remaining = (double)this.getFreeBytes() * 2048.0 + (double)this.getUnusedFluidCount();
        if (remaining > 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        return remaining > 0.0 ? (long)remaining : 0L;
    }

    public int getUnusedFluidCount() {
        int div = (int)(this.storedFluidCount % 2048L);
        if (div == 0) {
            return 0;
        }
        return 2048 - div;
    }

    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * 8L + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int getUnusedItemCount() {
        long div = this.storedItemCount % 8L;
        if (div == 0L) {
            return 0;
        }
        return (int)(8L - div);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        switch (mc) {
            case setInventorySlotContents: {
                if (added != null) {
                    if (inv == this.cell) {
                        Item item = added.func_77973_b();
                        if (item instanceof ItemBasicStorageCell) {
                            ItemBasicStorageCell ibsc = (ItemBasicStorageCell)item;
                            this.totalBytes = ibsc.getBytesLong(added);
                        } else {
                            item = added.func_77973_b();
                            if (item instanceof FCBaseItemCell) {
                                FCBaseItemCell fcbic = (FCBaseItemCell)item;
                                this.totalBytes = fcbic.getBytes(added);
                            }
                        }
                        this.getProxy().setIdlePowerUsage(Math.sqrt(Math.pow(this.totalBytes, 0.576)));
                    } else if (inv == this.invItems) {
                        this.storedItemCount += (long)added.field_77994_a;
                    }
                }
                if (removed == null) break;
                if (inv == this.cell) {
                    this.totalBytes = 0L;
                    this.getProxy().setIdlePowerUsage(4.0);
                    break;
                }
                if (inv != this.invItems) break;
                this.storedItemCount -= (long)removed.field_77994_a;
                break;
            }
            case decreaseStackSize: {
                if (inv == this.cell) {
                    this.totalBytes = 0L;
                    this.getProxy().setIdlePowerUsage(4.0);
                }
                if (inv != this.invItems) break;
                this.storedItemCount -= (long)removed.field_77994_a;
                break;
            }
        }
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException e) {
            AELog.error((Throwable)e, (String)"Couldn't wake up level emitter for delayed updates");
        }
        this.markForUpdate();
    }

    public void fullRefund() {
        int i;
        for (i = 0; i < 9; ++i) {
            if (this.invFluids.getFluidStackInSlot(i) == null) continue;
            this.returnFluid(i, Long.MAX_VALUE);
        }
        for (i = 0; i < 63; ++i) {
            if (this.invItems.func_70301_a(i) == null) continue;
            this.returnItem(i, Integer.MAX_VALUE);
        }
    }

    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.cell.func_70301_a(0) != null) {
            drops.add(this.cell.func_70301_a(0));
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack ifp = ItemFluidPacket.newStack(this.invFluids.getFluidStackInSlot(i));
            if (ifp == null) continue;
            drops.add(ifp);
        }
        super.getDrops(w, x, y, z, drops);
    }

    public boolean func_102007_a(int slotIndex, ItemStack insertingItem, int side) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack fs = this.invFluids.drain(from, resource, doDrain);
        if (doDrain && fs != null) {
            this.storedFluidCount -= (long)fs.amount;
        }
        return fs;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fs = this.invFluids.drain(from, maxDrain, doDrain);
        if (doDrain && fs != null) {
            this.storedFluidCount -= (long)fs.amount;
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.invFluids.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.invFluids.getTankInfo(from);
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.markForUpdate();
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.invFluids;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileSuperStockReplenisher(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileSuperStockReplenisher(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.invItems.readFromNBT(data, "ItemInv");
        this.invFluids.readFromNBT(data, "FluidInv");
        this.configItems.readFromNBT(data, "configItems");
        this.configFluids.readFromNBT(data, "configFluids");
        this.cell.readFromNBT(data, "cellHolder");
        this.totalBytes = data.func_74763_f("totalBytes");
        this.storedFluidCount = data.func_74763_f("storedFluidCount");
        this.storedItemCount = data.func_74763_f("storedItemCount");
        this.getProxy().setIdlePowerUsage(data.func_74769_h("powerDraw"));
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.invItems.writeToNBT(data, "ItemInv");
        this.invFluids.writeToNBT(data, "FluidInv");
        this.configItems.writeToNBT(data, "configItems");
        this.configFluids.writeToNBT(data, "configFluids");
        this.cell.writeToNBT(data, "cellHolder");
        data.func_74772_a("totalBytes", this.totalBytes);
        data.func_74772_a("storedFluidCount", this.storedFluidCount);
        data.func_74772_a("storedItemCount", this.storedItemCount);
        data.func_74780_a("powerDraw", this.getProxy().getIdlePowerUsage());
        return data;
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(120, 120, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doWork();
    }
}

