/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fuzzycraft.botanichorizons.addons.BHBlocks;
import net.fuzzycraft.botanichorizons.addons.Multiblocks;
import net.fuzzycraft.botanichorizons.addons.tileentity.SimpleAutomationTileEntity;
import net.fuzzycraft.botanichorizons.util.ChargeState;
import net.fuzzycraft.botanichorizons.util.Facing2D;
import net.fuzzycraft.botanichorizons.util.InventoryHelper;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.client.core.handler.HUDHandler;

public class TileAdvancedAlfPortal
extends SimpleAutomationTileEntity<RecipeElvenTrade>
implements IManaReceiver,
ISparkAttachable,
IWrenchable {
    public static final int MANA_CAPACITY = 200000;
    public static final int CYCLE_TICKS = 20;
    public static final int CYCLE_UPKEEP = 75;
    public static final int RECIPE_MANA = 10;
    public static final int ACTIVATE_MANA = 95000;
    public static final int MAX_PARALLELS = 32;
    protected int cycleRemaining = 0;

    public TileAdvancedAlfPortal() {
        super(Multiblocks.alfPortal);
    }

    @Override
    protected void updateEntityCrafting() {
        if (!this.isOnline) {
            return;
        }
        if (this.cycleRemaining > 0) {
            --this.cycleRemaining;
        } else if (this.storedMana < 75) {
            this.isOnline = false;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
        } else if (this.partialStructureValidation()) {
            this.cycleRemaining = 20;
            this.storedMana -= 75;
            this.handleCrafts();
            this.handleOutputs();
            this.cleanupInventory(0, 2);
            this.cleanupInventory(2, 4);
            this.func_70296_d();
        } else {
            this.isOnline = false;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
        }
    }

    @Override
    public int getManaMaximum() {
        return this.isOnline ? 200000 : 97000;
    }

    @Override
    public int getAvailableParallels(@Nonnull RecipeElvenTrade recipe) {
        int parallel = 32;
        int max_mana_parallel = (this.storedMana - 75) / 10;
        parallel = Math.min(parallel, max_mana_parallel);
        return parallel;
    }

    @Override
    @Nullable
    public RecipeElvenTrade findMatchingRecipe(@Nonnull ItemStack stack) {
        for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
            List inputs = recipe.getInputs();
            if (this.getRecipeInputStackSize(recipe) <= 0) continue;
            for (Object input : inputs) {
                if (!InventoryHelper.isIngredient(stack, input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    void consumeNonItemResources(RecipeElvenTrade recipe, int parallel) {
        this.storedMana -= parallel * 10;
    }

    @Override
    public int getRecipeInputStackSize(RecipeElvenTrade recipe) {
        List inputs = recipe.getInputs();
        if (inputs.size() == 1) {
            Object entry = inputs.get(0);
            if (entry instanceof String) {
                return 1;
            }
            if (entry instanceof ItemStack) {
                return ((ItemStack)entry).field_77994_a;
            }
        } else if (inputs.size() > 1) {
            Object reference = inputs.get(0);
            if (!(reference instanceof String)) {
                return 0;
            }
            String oredict = (String)reference;
            for (int i = 1; i < inputs.size(); ++i) {
                Object compare = inputs.get(i);
                if (!(compare instanceof String)) {
                    return 0;
                }
                if (oredict.equals(compare)) continue;
                return 0;
            }
            return inputs.size();
        }
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput(@Nonnull RecipeElvenTrade recipe) {
        return recipe.getOutput();
    }

    public boolean onWanded(EntityPlayer wandUser) {
        this.facing = Facing2D.fromIndex(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >> 1 & 3);
        if (!this.isOnline) {
            Exception error = this.structure.checkEntireStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing);
            if (error != null) {
                boolean handled = MultiblockHelper.handleFailedStructure(this.field_145850_b, wandUser, error);
                return false;
            }
            if (this.storedMana <= 95000) {
                return false;
            }
            this.storedMana -= 95000;
            this.cycleRemaining = 20;
            this.isOnline = true;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1 + this.facing.index * 2, 3);
            this.func_70296_d();
            return true;
        }
        this.isOnline = false;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index * 2, 3);
        this.func_70296_d();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        ChargeState state = ChargeState.genState(this.isOnline, this.storedMana, 95000);
        String tooltip = state.getLocalisedHudString((Block)BHBlocks.autoPortal);
        HUDHandler.drawSimpleManaHUD((int)state.color, (int)this.storedMana, (int)200000, (String)tooltip, (ScaledResolution)res);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)BHBlocks.autoPortal);
    }
}

