/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme.info;

import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.HighContrastDarkTheme;
import com.github.weisj.darklaf.theme.HighContrastLightTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.UnsupportedThemeException;
import com.github.weisj.darklaf.theme.info.ThemeProvider;
import com.github.weisj.darklaf.theme.spec.ColorToneRule;
import com.github.weisj.darklaf.theme.spec.ContrastRule;
import com.github.weisj.darklaf.theme.spec.PreferredThemeStyle;
import java.util.Objects;

public class DefaultThemeProvider
implements ThemeProvider {
    private final Theme lightTheme;
    private final Theme darkTheme;
    private final Theme lightHighContrastTheme;
    private final Theme darkHighContrastTheme;

    public DefaultThemeProvider() {
        this(new IntelliJTheme(), new DarculaTheme(), new HighContrastLightTheme(), new HighContrastDarkTheme());
    }

    public DefaultThemeProvider(Theme lightTheme, Theme darkTheme) {
        this(lightTheme, darkTheme, new HighContrastLightTheme(), new HighContrastDarkTheme());
    }

    public DefaultThemeProvider(Theme lightTheme, Theme darkTheme, Theme lightHighContrastTheme, Theme darkHighContrastTheme) {
        Objects.requireNonNull(lightTheme, "Light theme is null");
        Objects.requireNonNull(darkTheme, "Dark theme is null");
        Objects.requireNonNull(lightHighContrastTheme, "Light high contrast theme is null");
        Objects.requireNonNull(darkHighContrastTheme, "Dark high contrast theme is null");
        if (Theme.isDark(lightTheme)) {
            throw new UnsupportedThemeException("Given light theme " + lightTheme + "is declared as dark");
        }
        if (Theme.isDark(lightHighContrastTheme)) {
            throw new UnsupportedThemeException("Given light high-contrast theme " + lightHighContrastTheme + " is declared as dark");
        }
        if (!Theme.isDark(darkTheme)) {
            throw new UnsupportedThemeException("Given dark theme " + darkTheme + " is not declared as dark");
        }
        if (!Theme.isDark(darkHighContrastTheme)) {
            throw new UnsupportedThemeException("Given dark high-contrast theme " + darkHighContrastTheme + "is not declared as dark");
        }
        if (!Theme.isHighContrast(lightHighContrastTheme)) {
            throw new UnsupportedThemeException("Given light high-contrast theme " + lightHighContrastTheme + " is not declared as high-contrast");
        }
        if (!Theme.isHighContrast(darkHighContrastTheme)) {
            throw new UnsupportedThemeException("Given dark high-contrast theme " + darkHighContrastTheme + " is not declared as high-contrast");
        }
        this.lightTheme = lightTheme;
        this.darkTheme = darkTheme;
        this.lightHighContrastTheme = lightHighContrastTheme;
        this.darkHighContrastTheme = darkHighContrastTheme;
    }

    @Override
    public Theme getTheme(PreferredThemeStyle themeStyle) {
        boolean highContrast;
        if (themeStyle == null) {
            return this.lightTheme;
        }
        boolean dark = themeStyle.getColorToneRule() == ColorToneRule.DARK;
        boolean bl = highContrast = themeStyle.getContrastRule() == ContrastRule.HIGH_CONTRAST;
        Theme theme = dark ? (highContrast ? this.darkHighContrastTheme : this.darkTheme) : (highContrast ? this.lightHighContrastTheme : this.lightTheme);
        return theme.derive(themeStyle.getFontSizeRule(), null, themeStyle.getAccentColorRule());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultThemeProvider)) {
            return false;
        }
        DefaultThemeProvider that = (DefaultThemeProvider)o;
        return this.lightTheme.appearsEqualTo(that.lightTheme) && this.darkTheme.appearsEqualTo(that.darkTheme) && this.lightHighContrastTheme.appearsEqualTo(that.lightHighContrastTheme) && this.darkHighContrastTheme.appearsEqualTo(that.darkHighContrastTheme);
    }

    public int hashCode() {
        return Objects.hash(this.lightTheme, this.darkTheme, this.lightHighContrastTheme, this.darkHighContrastTheme);
    }
}

