/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBasicGrowthCraft
extends Crop {
    private final Block block;
    private final int meta;
    private final boolean isRice;
    private final boolean isGrape;

    public CropBasicGrowthCraft(World world, Block block, int meta, Vect position, boolean isRice, boolean isGrape) {
        super(world, position);
        this.block = block;
        this.meta = meta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    protected boolean isCrop(IVect pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(IVect pos) {
        ArrayList harvest = this.block.getDrops(this.world, pos.getX(), pos.getY(), pos.getZ(), this.meta, 0);
        if (harvest.size() > 1) {
            harvest.remove(0);
        }
        Proxies.common.addBlockDestroyEffects(this.world, pos.getX(), pos.getY(), pos.getZ(), this.block, 0);
        if (this.isGrape) {
            this.world.func_147468_f(pos.getX(), pos.getY(), pos.getZ());
        } else {
            this.world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), 0, 2);
        }
        if (this.isRice) {
            this.world.func_72921_c(pos.getX(), pos.getY() - 1, pos.getZ(), 7, 2);
        }
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicGrowthCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.func_149739_a(), this.meta);
    }
}

