/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.compat;

import gcewing.architecture.common.block.BlockArchitecture;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.IOrientationHandler;
import gcewing.architecture.compat.IProperty;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.legacy.properties.PropertyTurn;
import gcewing.architecture.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Orient4WaysByState
implements IOrientationHandler {
    public static final IProperty<EnumFacing> FACING = new PropertyTurn("facing");

    @Override
    public void defineProperties(BlockArchitecture block) {
        block.addProperty(FACING);
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState baseState, EntityLivingBase placer) {
        EnumFacing dir = this.getHorizontalFacing((Entity)placer);
        return baseState.withProperty(FACING, dir);
    }

    protected EnumFacing getHorizontalFacing(Entity entity) {
        return Utils.horizontalFacings[Utils.iround((double)entity.field_70177_z / 90.0) & 3];
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te, Vector3 origin) {
        int n;
        EnumFacing f = state.getValue(FACING);
        switch (f) {
            case NORTH: {
                n = 0;
                break;
            }
            case WEST: {
                n = 1;
                break;
            }
            case SOUTH: {
                n = 2;
                break;
            }
            case EAST: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        int i = n;
        return new Trans3(origin).turn(i);
    }
}

