/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.compat;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gcewing.architecture.compat.GetList;
import gcewing.architecture.compat.Product;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Cartesian {
    public static <T> Iterable<T[]> cartesianProduct(Class<T> clazz, Iterable<? extends Iterable<? extends T>> sets) {
        return new Product<T>(clazz, Cartesian.toArray(Iterable.class, sets));
    }

    public static <T> Iterable<List<T>> cartesianProduct(Iterable<? extends Iterable<? extends T>> sets) {
        return Cartesian.arraysAsLists(Cartesian.cartesianProduct(Object.class, sets));
    }

    private static <T> Iterable<List<T>> arraysAsLists(Iterable<Object[]> arrays) {
        return Iterables.transform(arrays, new GetList());
    }

    private static <T> T[] toArray(Class<? super T> clazz, Iterable<? extends T> it) {
        ArrayList list = Lists.newArrayList();
        for (T t : it) {
            list.add(t);
        }
        return list.toArray(Cartesian.createArray(clazz, list.size()));
    }

    public static <T> T[] createArray(Class<? super T> p_179319_0_, int p_179319_1_) {
        return (Object[])Array.newInstance(p_179319_0_, p_179319_1_);
    }
}

